/*
 * Decompiled with CFR 0.152.
 */
package org.apithefire.sql.connect;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apithefire.sql.RuntimeSqlException;
import org.apithefire.sql.connect.ConnectionProvider;
import org.apithefire.sql.connect.DataSourceWrapper;
import org.apithefire.util.lang.Objects;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionProviderWrapper
implements DataSource {
    private final PrintWriter nullPrintWriter = ConnectionProviderWrapper.newNullPrintWriter();
    private final ConnectionProvider connectionProvider;

    public static DataSource wrap(ConnectionProvider connectionProvider) {
        if (connectionProvider instanceof DataSourceWrapper) {
            return ((DataSourceWrapper)connectionProvider).getWrappedDataSource();
        }
        return new ConnectionProviderWrapper(connectionProvider);
    }

    private ConnectionProviderWrapper(ConnectionProvider connectionProvider) {
        this.connectionProvider = (ConnectionProvider)Objects.nonNull((Object)connectionProvider);
    }

    @Override
    public Connection getConnection() throws SQLException {
        try {
            return this.connectionProvider.getConnection();
        }
        catch (RuntimeSqlException e) {
            Throwable cause = e.getCause();
            if (cause != null && cause instanceof SQLException) {
                throw (SQLException)cause;
            }
            throw e;
        }
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.getConnection();
    }

    private static PrintWriter newNullPrintWriter() {
        return new PrintWriter(new Writer(){

            public void close() throws IOException {
            }

            public void flush() throws IOException {
            }

            public void write(char[] arg0, int arg1, int arg2) throws IOException {
            }
        });
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.nullPrintWriter;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return 0;
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLException("Can not unwrap " + iface);
    }
}

