/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.AbstractVarExpr;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.expr.VarInfo;
import com.caucho.quercus.expr.VarState;
import com.caucho.quercus.parser.QuercusParser;

public class VarExpr
extends AbstractVarExpr {
    private static final NullValue NULL = NullValue.create();
    private final VarInfo _var;
    protected final String _name;
    private VarState _varState = VarState.INIT;

    protected VarExpr(Location location, VarInfo var) {
        super(location);
        this._var = var;
        this._name = var.getName();
    }

    protected VarExpr(VarInfo var) {
        this._var = var;
        this._name = var.getName();
    }

    public VarInfo getVarInfo() {
        return this._var;
    }

    public String getName() {
        return this._name;
    }

    public String getJavaVar() {
        return "v_" + this._name;
    }

    public Expr copy(Location location) {
        return new VarExpr(location, this._var);
    }

    public Expr createAssign(QuercusParser parser, Expr value) {
        return super.createAssign(parser, value);
    }

    public void assign(QuercusParser parser) {
    }

    public Expr createAssignRef(QuercusParser parser, Expr value) {
        return super.createAssignRef(parser, value);
    }

    public Value eval(Env env) {
        Value value = this._var.isGlobal() ? env.getGlobalValue(this._name) : env.getValue(this._name);
        if (value != null) {
            return value;
        }
        return NULL;
    }

    public Value evalCopy(Env env) {
        Value v = this.eval(env);
        return v.copy();
    }

    public Value evalArray(Env env) {
        Value value;
        if (this._var.isGlobal()) {
            value = env.getGlobalValue(this._name);
            if (value == null) {
                value = new ArrayValueImpl();
                env.setGlobalValue(this._name, value);
            } else {
                Value array = value.toAutoArray();
                if (array != value) {
                    env.setGlobalValue(this._name, array);
                    value = array;
                }
            }
        } else {
            value = env.getVar(this._name);
            if (value == null) {
                value = new ArrayValueImpl();
                env.setValue(this._name, value);
            } else {
                value = value.toAutoArray();
            }
        }
        return value;
    }

    public Value evalObject(Env env) {
        Value value;
        if (this._var.isGlobal()) {
            value = env.getGlobalValue(this._name);
            if (value == null || value.isString() || value.isNull()) {
                value = env.createObject();
                env.setGlobalValue(this._name, value);
            }
        } else {
            value = env.getValue(this._name);
            if (value == null || value.isString() || value.isNull()) {
                value = env.createObject();
                env.setValue(this._name, value);
            }
        }
        return value;
    }

    public Value evalRef(Env env) {
        if (this.getVarInfo().isGlobal()) {
            return env.getGlobalVar(this._name);
        }
        return env.getVar(this._name);
    }

    public Value evalArg(Env env) {
        if (this.getVarInfo().isGlobal()) {
            return env.getGlobalVar(this._name);
        }
        return env.getVar(this._name);
    }

    public void evalAssign(Env env, Value value) {
        env.setValue(this._name, value);
    }

    public void evalUnset(Env env) {
        env.unsetLocalVar(this._name);
    }

    public int hashCode() {
        return this._name.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        VarExpr var = (VarExpr)o;
        return this._var == var._var;
    }

    public String toString() {
        return "$" + this._name;
    }
}

