/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.date;

import com.caucho.quercus.UnimplementedException;
import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.lib.date.DateModule;
import com.caucho.quercus.lib.date.DateTimeZone;
import com.caucho.util.Alarm;
import com.caucho.util.QDate;

public class DateTime {
    public static final String ATOM = "Y-m-d\\TH:i:sP";
    public static final String COOKIE = "l, d-M-y H:i:s T";
    public static final String ISO8601 = "Y-m-d\\TH:i:sO";
    public static final String RFC822 = "D, d M y H:i:s O";
    public static final String RFC850 = "l, d-M-y H:i:s T";
    public static final String RFC1036 = "D, d M y H:i:s O";
    public static final String RFC1123 = "D, d M Y H:i:s O";
    public static final String RFC2822 = "D, d M Y H:i:s O";
    public static final String RFC3339 = "Y-m-d\\TH:i:sP";
    public static final String RSS = "D, d M Y H:i:s O";
    public static final String W3C = "Y-m-d\\TH:i:sP";
    private QDate _qDate;
    private DateTimeZone _dateTimeZone;

    protected DateTime(String timeString) {
        this(timeString, new DateTimeZone());
    }

    protected DateTime(String timeString, DateTimeZone dateTimeZone) {
        this._qDate = new QDate(dateTimeZone.getTimeZone());
        this._dateTimeZone = dateTimeZone;
        this.init(timeString);
    }

    private void init(String timeString) {
        long now = Alarm.getCurrentTime();
        this._qDate.setGMTTime(now);
        if (timeString.equals("")) {
            this._qDate.setHour(0);
            this._qDate.setMinute(0);
            this._qDate.setSecond(0);
        }
        DateModule.DateParser parser = new DateModule.DateParser(timeString, this._qDate);
        long time = parser.parse();
        this._qDate.setGMTTime(time);
    }

    public static DateTime __construct(@Optional(value="now") String time, @Optional DateTimeZone timeZone) {
        if (timeZone == null) {
            return new DateTime(time);
        }
        return new DateTime(time, timeZone);
    }

    public String format(String format) {
        return DateModule.date(format, this._qDate.getLocalTime() / 1000L, this._qDate);
    }

    public void modify(String modify) {
        DateModule.DateParser parser = new DateModule.DateParser(modify, this._qDate);
        long time = parser.parse();
        this.setTime(time);
    }

    public DateTimeZone getTimeZone() {
        return this._dateTimeZone;
    }

    public void setTimeZone(DateTimeZone dateTimeZone) {
        this._dateTimeZone = dateTimeZone;
        this._qDate = new QDate(dateTimeZone.getTimeZone());
    }

    public long getOffset() {
        return this._qDate.getZoneOffset() / 1000L;
    }

    public void setTime(int hour, int minute, @Optional int second) {
        this._qDate.setTime((long)hour, (long)minute, (long)second, 0L);
    }

    public void setDate(int year, int month, int day) {
        this._qDate.setDate((long)year, (long)month, (long)day);
    }

    public void setISODate(int year, int week, @Optional int day) {
        throw new UnimplementedException("DateTime::setISODate()");
    }

    protected QDate getQDate() {
        return this._qDate;
    }

    protected long getTime() {
        return this._qDate.getLocalTime();
    }

    protected void setTime(long time) {
        this._qDate.setLocalTime(time);
    }

    public String toString() {
        return this.format("now");
    }
}

