/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.json;

import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.NumberValue;
import com.caucho.quercus.env.ObjectValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.json.JsonDecoder;
import com.caucho.quercus.module.AbstractQuercusModule;
import com.caucho.util.L10N;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;

public class JsonModule
extends AbstractQuercusModule {
    private static final Logger log = Logger.getLogger(JsonModule.class.getName());
    private static final L10N L = new L10N(JsonModule.class);

    public String[] getLoadedExtensions() {
        return new String[]{"json"};
    }

    public StringValue json_encode(Env env, Value val) {
        StringValue sb = env.createUnicodeBuilder();
        this.jsonEncodeImpl(env, sb, val);
        return sb;
    }

    private void jsonEncodeImpl(Env env, StringValue sb, Value val) {
        if (val.isString()) {
            sb.append('\"');
            this.encodeString(sb, (StringValue)val);
            sb.append('\"');
        } else if (val == BooleanValue.TRUE) {
            sb.append("true");
        } else if (val == BooleanValue.FALSE) {
            sb.append("false");
        } else if (val instanceof NumberValue) {
            sb.append(val.toStringValue());
        } else if (val.isArray()) {
            this.encodeArray(env, sb, (ArrayValue)val);
        } else if (val.isObject()) {
            this.encodeObject(env, sb, (ObjectValue)val);
        } else if (val == null || val.isNull()) {
            sb.append("null");
        } else {
            env.warning(L.l("type is unsupported; encoded as null"));
        }
    }

    private void encodeArray(Env env, StringValue sb, ArrayValue val) {
        long length = 0L;
        Iterator<Value> keyIter = val.getKeyIterator(env);
        while (keyIter.hasNext()) {
            Value key = keyIter.next();
            if (!key.isLongConvertible() || key.toLong() != length) {
                this.encodeAssociativeArray(env, sb, val);
                return;
            }
            ++length;
        }
        sb.append('[');
        length = 0L;
        for (Value value : val.values()) {
            if (length > 0L) {
                sb.append(',');
            }
            this.jsonEncodeImpl(env, sb, value);
            ++length;
        }
        sb.append(']');
    }

    private void encodeAssociativeArray(Env env, StringValue sb, ArrayValue val) {
        sb.append('{');
        int length = 0;
        Iterator<Map.Entry<Value, Value>> iter = val.getIterator(env);
        while (iter.hasNext()) {
            Map.Entry<Value, Value> entry = iter.next();
            if (length > 0) {
                sb.append(',');
            }
            this.jsonEncodeImpl(env, sb, entry.getKey().toStringValue());
            sb.append(':');
            this.jsonEncodeImpl(env, sb, entry.getValue());
            ++length;
        }
        sb.append('}');
    }

    private void encodeObject(Env env, StringValue sb, ObjectValue val) {
        sb.append('{');
        int length = 0;
        Iterator<Map.Entry<Value, Value>> iter = val.getIterator(env);
        while (iter.hasNext()) {
            Map.Entry<Value, Value> entry = iter.next();
            if (length > 0) {
                sb.append(',');
            }
            this.jsonEncodeImpl(env, sb, entry.getKey().toStringValue());
            sb.append(':');
            this.jsonEncodeImpl(env, sb, entry.getValue());
            ++length;
        }
        sb.append('}');
    }

    private void encodeString(StringValue sb, StringValue val) {
        int len = val.length();
        block10: for (int i = 0; i < len; ++i) {
            char c = val.charAt(i);
            switch (c) {
                case '\b': {
                    sb.append('\\');
                    sb.append('b');
                    continue block10;
                }
                case '\f': {
                    sb.append('\\');
                    sb.append('f');
                    continue block10;
                }
                case '\n': {
                    sb.append('\\');
                    sb.append('n');
                    continue block10;
                }
                case '\r': {
                    sb.append('\\');
                    sb.append('r');
                    continue block10;
                }
                case '\t': {
                    sb.append('\\');
                    sb.append('t');
                    continue block10;
                }
                case '\\': {
                    sb.append('\\');
                    sb.append('\\');
                    continue block10;
                }
                case '\"': {
                    sb.append('\\');
                    sb.append('\"');
                    continue block10;
                }
                case '/': {
                    sb.append('\\');
                    sb.append('/');
                    continue block10;
                }
                default: {
                    char c1;
                    if (c <= '\u001f') {
                        this.addUnicode(sb, c);
                        continue block10;
                    }
                    if (c < '\u0080') {
                        sb.append(c);
                        continue block10;
                    }
                    if ((c & 0xE0) == 192 && i + 1 < len) {
                        c1 = val.charAt(i + 1);
                        ++i;
                        int ch = ((c & 0x1F) << 6) + (c1 & 0x3F);
                        this.addUnicode(sb, ch);
                        continue block10;
                    }
                    if ((c & 0xF0) == 224 && i + 2 < len) {
                        c1 = val.charAt(i + 1);
                        char c2 = val.charAt(i + 2);
                        i += 2;
                        int ch = ((c & 0xF) << 12) + ((c1 & 0x3F) << 6) + (c2 & 0x3F);
                        this.addUnicode(sb, ch);
                        continue block10;
                    }
                    this.addUnicode(sb, c);
                }
            }
        }
    }

    private void addUnicode(StringValue sb, int c) {
        sb.append('\\');
        sb.append('u');
        int d = c >> 12 & 0xF;
        if (d < 10) {
            sb.append((char)(48 + d));
        } else {
            sb.append((char)(97 + d - 10));
        }
        d = c >> 8 & 0xF;
        if (d < 10) {
            sb.append((char)(48 + d));
        } else {
            sb.append((char)(97 + d - 10));
        }
        d = c >> 4 & 0xF;
        if (d < 10) {
            sb.append((char)(48 + d));
        } else {
            sb.append((char)(97 + d - 10));
        }
        d = c & 0xF;
        if (d < 10) {
            sb.append((char)(48 + d));
        } else {
            sb.append((char)(97 + d - 10));
        }
    }

    public Value json_decode(Env env, StringValue s, @Optional(value="false") boolean assoc) {
        return new JsonDecoder().jsonDecode(env, s, assoc);
    }
}

