/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.regexp;

import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.annotation.Reference;
import com.caucho.quercus.annotation.UsesSymbolTable;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.Callback;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.regexp.CauchoRegexpModule;
import com.caucho.quercus.lib.regexp.JavaRegexpModule;
import com.caucho.quercus.module.AbstractQuercusModule;

public class RegexpModule
extends AbstractQuercusModule {
    public static final int PREG_REPLACE_EVAL = 1;
    public static final int PCRE_UTF8 = 2;
    public static final int PREG_PATTERN_ORDER = 1;
    public static final int PREG_SET_ORDER = 2;
    public static final int PREG_OFFSET_CAPTURE = 4;
    public static final int PREG_SPLIT_NO_EMPTY = 1;
    public static final int PREG_SPLIT_DELIM_CAPTURE = 2;
    public static final int PREG_SPLIT_OFFSET_CAPTURE = 4;
    public static final int PREG_GREP_INVERT = 1;

    public String[] getLoadedExtensions() {
        return new String[]{"ereg", "pcre"};
    }

    public static Value ereg(Env env, Value pattern, StringValue string, @Optional @Reference Value regsV) {
        if (RegexpModule.useJavaRegexp(env)) {
            return JavaRegexpModule.ereg(env, pattern, string, regsV);
        }
        return CauchoRegexpModule.ereg(env, pattern, string, regsV);
    }

    public static Value eregi(Env env, Value pattern, StringValue string, @Optional @Reference Value regsV) {
        if (RegexpModule.useJavaRegexp(env)) {
            return JavaRegexpModule.eregi(env, pattern, string, regsV);
        }
        return CauchoRegexpModule.eregi(env, pattern, string, regsV);
    }

    public static Value preg_match(Env env, StringValue regexp, StringValue subject, @Optional @Reference Value matchRef, @Optional int flags, @Optional int offset) {
        if (RegexpModule.useJavaRegexp(env)) {
            return JavaRegexpModule.preg_match(env, regexp, subject, matchRef, flags, offset);
        }
        return CauchoRegexpModule.preg_match(env, regexp, subject, matchRef, flags, offset);
    }

    public static Value preg_match_all(Env env, StringValue regexp, StringValue subject, @Reference Value matchRef, @Optional(value="PREG_PATTERN_ORDER") int flags, @Optional int offset) {
        if (RegexpModule.useJavaRegexp(env)) {
            return JavaRegexpModule.preg_match_all(env, regexp, subject, matchRef, flags, offset);
        }
        return CauchoRegexpModule.preg_match_all(env, regexp, subject, matchRef, flags, offset);
    }

    public static StringValue preg_quote(Env env, StringValue string, @Optional StringValue delim) {
        if (RegexpModule.useJavaRegexp(env)) {
            return JavaRegexpModule.preg_quote(string, delim);
        }
        return CauchoRegexpModule.preg_quote(string, delim);
    }

    @UsesSymbolTable
    public static Value preg_replace(Env env, Value pattern, Value replacement, Value subject, @Optional(value="-1") long limit, @Optional @Reference Value count) {
        if (RegexpModule.useJavaRegexp(env)) {
            return JavaRegexpModule.preg_replace(env, pattern, replacement, subject, limit, count);
        }
        return CauchoRegexpModule.preg_replace(env, pattern, replacement, subject, limit, count);
    }

    public static Value ereg_replace(Env env, Value pattern, Value replacement, StringValue subject) {
        if (RegexpModule.useJavaRegexp(env)) {
            return JavaRegexpModule.ereg_replace(env, pattern, replacement, subject);
        }
        return CauchoRegexpModule.ereg_replace(env, pattern, replacement, subject);
    }

    public static Value eregi_replace(Env env, Value pattern, Value replacement, StringValue subject) {
        if (RegexpModule.useJavaRegexp(env)) {
            return JavaRegexpModule.eregi_replace(env, pattern, replacement, subject);
        }
        return CauchoRegexpModule.eregi_replace(env, pattern, replacement, subject);
    }

    public static Value preg_replace_callback(Env env, Value pattern, Callback fun, Value subject, @Optional(value="-1") long limit, @Optional @Reference Value count) {
        if (RegexpModule.useJavaRegexp(env)) {
            return JavaRegexpModule.preg_replace_callback(env, pattern, fun, subject, limit, count);
        }
        return CauchoRegexpModule.preg_replace_callback(env, pattern, fun, subject, limit, count);
    }

    public static Value preg_split(Env env, StringValue patternString, StringValue string, @Optional(value="-1") long limit, @Optional int flags) {
        if (RegexpModule.useJavaRegexp(env)) {
            return JavaRegexpModule.preg_split(env, patternString, string, limit, flags);
        }
        return CauchoRegexpModule.preg_split(env, patternString, string, limit, flags);
    }

    public static StringValue sql_regcase(Env env, StringValue string) {
        if (RegexpModule.useJavaRegexp(env)) {
            return JavaRegexpModule.sql_regcase(string);
        }
        return CauchoRegexpModule.sql_regcase(string);
    }

    public static Value split(Env env, StringValue patternString, StringValue string, @Optional(value="-1") long limit) {
        if (RegexpModule.useJavaRegexp(env)) {
            return JavaRegexpModule.split(env, patternString, string, limit);
        }
        return CauchoRegexpModule.split(env, patternString, string, limit);
    }

    public static Value preg_grep(Env env, StringValue patternString, ArrayValue input, @Optional(value="0") int flag) {
        if (RegexpModule.useJavaRegexp(env)) {
            return JavaRegexpModule.preg_grep(env, patternString, input, flag);
        }
        return CauchoRegexpModule.preg_grep(env, patternString, input, flag);
    }

    public static Value spliti(Env env, StringValue patternString, StringValue string, @Optional(value="-1") long limit) {
        if (RegexpModule.useJavaRegexp(env)) {
            return JavaRegexpModule.spliti(env, patternString, string, limit);
        }
        return CauchoRegexpModule.spliti(env, patternString, string, limit);
    }

    private static boolean useJavaRegexp(Env env) {
        return false;
    }
}

