/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.parser;

import com.caucho.quercus.Location;
import com.caucho.quercus.expr.ExprFactory;
import com.caucho.quercus.parser.Scope;
import com.caucho.quercus.program.Function;
import com.caucho.quercus.program.InterpretedClassDef;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IfScope
extends Scope {
    private static final L10N L = new L10N(IfScope.class);
    private ExprFactory _exprFactory;
    private HashMap<String, Function> _functionMap = new HashMap();
    private HashMap<String, Function> _conditionalFunctionMap;
    private HashMap<String, InterpretedClassDef> _classMap = new HashMap();
    private HashMap<String, InterpretedClassDef> _conditionalClassMap;

    IfScope(ExprFactory exprFactory, Scope parent) {
        super(parent);
        this._exprFactory = exprFactory;
    }

    @Override
    public boolean isIf() {
        return true;
    }

    public void addFunction(String name, Function function) {
        if (this._functionMap.get(name = name.toLowerCase()) == null) {
            this._functionMap.put(name, function);
        }
        this._parent.addConditionalFunction(function);
    }

    @Override
    protected void addConditionalFunction(Function function) {
        if (this._conditionalFunctionMap == null) {
            this._conditionalFunctionMap = new HashMap(4);
        }
        this._conditionalFunctionMap.put(function.getCompilationName(), function);
        this._parent.addConditionalFunction(function);
    }

    public InterpretedClassDef addClass(Location location, String name, String parentName, ArrayList<String> ifaceList, int index) {
        InterpretedClassDef existingClass = this._classMap.get(name);
        String[] ifaceArray = new String[ifaceList.size()];
        ifaceList.toArray(ifaceArray);
        InterpretedClassDef cl = this._exprFactory.createClassDef(location, name, parentName, ifaceArray, index);
        if (existingClass == null) {
            this._classMap.put(name, cl);
        }
        this._parent.addConditionalClass(cl);
        return cl;
    }

    @Override
    protected void addConditionalClass(InterpretedClassDef def) {
        if (this._conditionalClassMap == null) {
            this._conditionalClassMap = new HashMap(1);
        }
        this._conditionalClassMap.put(def.getCompilationName(), def);
        this._parent.addConditionalClass(def);
    }
}

