/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.pbx.agi;

import org.asteriskjava.fastagi.AgiException;
import org.asteriskjava.fastagi.AgiHangupException;
import org.asteriskjava.pbx.AgiChannelActivityAction;
import org.asteriskjava.pbx.Channel;
import org.asteriskjava.pbx.ChannelHangupListener;
import org.asteriskjava.pbx.InvalidChannelName;
import org.asteriskjava.pbx.PBXFactory;
import org.asteriskjava.pbx.agi.AgiChannelActivityHold;
import org.asteriskjava.pbx.agi.RateLimiter;
import org.asteriskjava.pbx.agi.config.ServiceAgiScriptImpl;
import org.asteriskjava.pbx.internal.core.AsteriskPBX;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

public abstract class ActivityAgi
extends ServiceAgiScriptImpl {
    private final Log logger = LogFactory.getLog(this.getClass());

    @Override
    public void service() throws AgiException {
        Channel channelProxy = null;
        String channelName = this.channel.getName();
        try {
            AsteriskPBX pbx = (AsteriskPBX)PBXFactory.getActivePBX();
            String proxyId = this.getVariable("proxyId");
            if (proxyId != null && proxyId.length() > 0) {
                channelProxy = pbx.getProxyById(proxyId);
            }
            if (channelProxy == null) {
                this.logger.warn("'proxyId' var not set or proxy doesn't exist anymore, trying to match the channel name... " + channelName);
                channelProxy = pbx.internalRegisterChannel(this.channel.getName(), this.channel.getUniqueId());
            }
            this.logger.info("Channel " + channelName + " arrived in agi");
            channelProxy.setIsInAgi(true);
            channelProxy.addHangupListener(new ChannelHangupListener(){

                @Override
                public void channelHangup(Channel channel, Integer cause, String causeText) {
                    AgiChannelActivityAction currentActivityAction = channel.getCurrentActivityAction();
                    if (currentActivityAction != null) {
                        currentActivityAction.cancel(channel);
                    }
                }
            });
            AgiChannelActivityAction action = channelProxy.getCurrentActivityAction();
            if (action == null) {
                action = new AgiChannelActivityHold();
            }
            boolean isAlive = true;
            RateLimiter rateLimiter = new RateLimiter(2);
            while (!action.isDisconnect() && isAlive) {
                action.execute(this.channel, channelProxy);
                action = channelProxy.getCurrentActivityAction();
                this.logger.debug("Action for proxy " + channelProxy + " is " + action.getClass().getSimpleName());
                isAlive = this.checkChannelIsStillUp();
                rateLimiter.acquire();
            }
        }
        catch (AgiHangupException e) {
            this.logger.warn("Channel hungup " + channelName);
        }
        catch (InterruptedException | InvalidChannelName e) {
            this.logger.error(e, e);
        }
        this.logger.debug("Channel leaving agi " + channelName);
    }

    private boolean checkChannelIsStillUp() {
        try {
            this.answer();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

