/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.pbx.internal.activity;

import java.util.HashSet;
import java.util.Set;
import org.asteriskjava.pbx.Activity;
import org.asteriskjava.pbx.ActivityCallback;
import org.asteriskjava.pbx.ActivityStatusEnum;
import org.asteriskjava.pbx.Channel;
import org.asteriskjava.pbx.ListenerPriority;
import org.asteriskjava.pbx.PBXException;
import org.asteriskjava.pbx.PBXFactory;
import org.asteriskjava.pbx.asterisk.wrap.actions.SetVarAction;
import org.asteriskjava.pbx.asterisk.wrap.events.ManagerEvent;
import org.asteriskjava.pbx.asterisk.wrap.response.ManagerResponse;
import org.asteriskjava.pbx.internal.core.AsteriskPBX;
import org.asteriskjava.pbx.internal.managerAPI.EventListenerBaseClass;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

public abstract class ActivityHelper<T extends Activity>
implements Runnable,
Activity {
    private static final Log logger = LogFactory.getLog(ActivityHelper.class);
    private PBXException lastException;
    private volatile boolean _success = false;
    private final ActivityCallback<T> callback;
    private final String activityName;
    private boolean _sendEvents;
    Exception callSite = new Exception("Invoked from here");

    public ActivityHelper(String activityName, ActivityCallback<T> callback) {
        this.callback = callback;
        this.activityName = activityName;
    }

    private AutoCloseable getManagerListener() {
        if (!this._sendEvents) {
            return new AutoCloseable(){

                @Override
                public void close() throws Exception {
                }
            };
        }
        EventListenerBaseClass listener = new EventListenerBaseClass(this.activityName){

            @Override
            public Set<Class<? extends ManagerEvent>> requiredEvents() {
                return ActivityHelper.this.requiredEvents();
            }

            @Override
            public void onManagerEvent(ManagerEvent event) {
                ActivityHelper.this.onManagerEvent(event);
            }

            @Override
            public ListenerPriority getPriority() {
                return ActivityHelper.this.getPriority();
            }
        };
        listener.startListener(PBXFactory.getActivePBX());
        return listener;
    }

    public void startActivity(boolean sendEvents) {
        this._sendEvents = sendEvents;
        if (this.callback != null) {
            this.callback.progress(this, ActivityStatusEnum.START, ActivityStatusEnum.START.getDefaultMessage());
        }
        Thread thread = new Thread((Runnable)this, this.activityName);
        thread.setDaemon(true);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try (AutoCloseable closer = this.getManagerListener();){
            this._success = this.doActivity();
        }
        catch (PBXException e) {
            this.lastException = e;
            logger.error(e, e);
            logger.error(this.callSite, this.callSite);
        }
        catch (Throwable e) {
            this.lastException = new PBXException(e);
            logger.error(this.callSite, this.callSite);
            logger.error(e, e);
        }
        finally {
            if (this.callback != null) {
                if (this._success) {
                    this.callback.progress(this, ActivityStatusEnum.SUCCESS, ActivityStatusEnum.SUCCESS.getDefaultMessage());
                } else {
                    this.callback.progress(this, ActivityStatusEnum.FAILURE, ActivityStatusEnum.FAILURE.getDefaultMessage());
                }
            }
        }
    }

    protected abstract boolean doActivity() throws PBXException;

    public boolean validateChannel(Channel channel) {
        boolean ret = false;
        SetVarAction var = new SetVarAction(channel, "testState", "1");
        ManagerResponse response = null;
        try {
            AsteriskPBX pbx = (AsteriskPBX)PBXFactory.getActivePBX();
            response = pbx.sendAction(var, 500);
        }
        catch (Exception e) {
            logger.debug(e, e);
            logger.error("getVariable: " + e);
        }
        if (response != null && response.getAttribute("Response").compareToIgnoreCase("success") == 0) {
            ret = true;
        }
        return ret;
    }

    @Override
    public boolean isSuccess() {
        return this._success;
    }

    protected void setLastException(PBXException e) {
        this.lastException = e;
    }

    @Override
    public Throwable getLastException() {
        return this.lastException;
    }

    public void progess(T activity, String message) {
        this.callback.progress(activity, ActivityStatusEnum.PROGRESS, message);
    }

    abstract HashSet<Class<? extends ManagerEvent>> requiredEvents();

    abstract void onManagerEvent(ManagerEvent var1);

    public abstract ListenerPriority getPriority();
}

