/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import java.security.SecureRandom;
import java.util.Random;

public class RandomUtil {
    private static long _seed = System.currentTimeMillis();
    private static SecureRandom _secureRandom;
    private static Random _random;
    private static boolean _isTest;

    public static synchronized long getRandomLong() {
        return RandomUtil.getRandom().nextLong();
    }

    public static synchronized int nextInt(int n) {
        return RandomUtil.getRandom().nextInt(n);
    }

    public static void addRandom(String random) {
        if (random == null) {
            return;
        }
        for (int i = 0; i < random.length(); ++i) {
            RandomUtil.addRandom(random.charAt(i));
        }
    }

    public static void addRandom(long seed) {
        Random random = RandomUtil.getRandom();
        if (random instanceof SecureRandom) {
            ((SecureRandom)random).setSeed(seed);
        }
    }

    private static Random getRandom() {
        if (_random == null) {
            _random = new SecureRandom();
            _random.setSeed(_seed);
        }
        return _random;
    }

    public static void setTestSeed(long seed) {
        _seed = seed;
        _isTest = true;
        _random = new Random(seed);
    }

    public static void setSecureRandom(SecureRandom random) {
        _secureRandom = random;
    }

    public static SecureRandom getSecureRandom() {
        if (_secureRandom == null) {
            _secureRandom = new SecureRandom();
        }
        return _secureRandom;
    }

    public static Random getTestRandom() {
        return _random;
    }
}

