/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.quercus.QuercusRuntimeException;
import com.caucho.quercus.env.BinaryValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.UnicodeBuilderValue;
import com.caucho.quercus.env.Value;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.IdentityHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BytesValue
extends BinaryValue {
    @Override
    public BinaryValue toBinaryValue(Env env) {
        return this;
    }

    @Override
    public String toDebugString() {
        StringBuilder sb = new StringBuilder();
        int length = this.length();
        sb.append("string(");
        sb.append(length);
        sb.append(") \"");
        int appendLength = length > 256 ? 256 : length;
        for (int i = 0; i < appendLength; ++i) {
            sb.append(this.charAt(i));
        }
        if (length > 256) {
            sb.append(" ...");
        }
        sb.append('\"');
        return sb.toString();
    }

    @Override
    public void varDumpImpl(Env env, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet) throws IOException {
        int length = this.length();
        out.print("string(" + this.length() + ") \"");
        for (int i = 0; i < length; ++i) {
            char ch = this.charAt(i);
            if (' ' <= ch && ch < '\u007f') {
                out.print(ch);
                continue;
            }
            if (ch == '\r' || ch == '\n' || ch == '\t') {
                out.print(ch);
                continue;
            }
            out.print("\\x" + Integer.toHexString(ch >> 4) + Integer.toHexString(ch % 16));
        }
        out.print("\"");
    }

    @Override
    public InputStream toInputStream(String charset) throws UnsupportedEncodingException {
        return this.toInputStream();
    }

    @Override
    public Reader toReader(String charset) throws UnsupportedEncodingException {
        return new InputStreamReader(this.toInputStream(), charset);
    }

    @Override
    public StringValue toStringBuilder() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BytesValue toBinaryValue(Env env, String charset) {
        return this;
    }

    @Override
    public StringValue toUnicodeValue(Env env) {
        UnicodeBuilderValue sb = new UnicodeBuilderValue();
        this.appendTo(sb);
        return sb;
    }

    @Override
    public StringValue appendTo(UnicodeBuilderValue sb) {
        if (this.length() == 0) {
            return sb;
        }
        Env env = Env.getInstance();
        try {
            Reader reader = env.getRuntimeEncodingFactory().create(this.toInputStream());
            if (reader != null) {
                sb.append(reader);
                reader.close();
            }
            return sb;
        }
        catch (IOException e) {
            throw new QuercusRuntimeException(e);
        }
    }

    @Override
    public abstract byte[] toBytes();
}

