/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib;

import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.annotation.Reference;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.module.AbstractQuercusModule;
import com.caucho.util.Alarm;
import com.caucho.util.L10N;
import com.caucho.util.QDate;
import java.util.ArrayList;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpModule
extends AbstractQuercusModule {
    private static final L10N L = new L10N(HttpModule.class);
    private static final QDate _calendar = new QDate(false);

    private static ArrayList<String> getHeaders(Env env) {
        ArrayList headers = (ArrayList)env.getSpecialValue("caucho.headers");
        if (headers == null) {
            headers = new ArrayList();
            env.setSpecialValue("caucho.headers", headers);
        }
        return headers;
    }

    public static Value header(Env env, StringValue headerStr, @Optional(value="true") boolean replace, @Optional long httpResponseCode) {
        int colonIndex;
        HttpServletResponse res = env.getResponse();
        if (res == null) {
            env.error(L.l("header requires a http context"));
            return NullValue.NULL;
        }
        String header = headerStr.toString();
        int len = header.length();
        if (header.startsWith("HTTP/")) {
            char ch;
            int p;
            int status = 0;
            for (p = header.indexOf(32); p < len && header.charAt(p) == ' '; ++p) {
            }
            while (p < len && '0' <= (ch = header.charAt(p)) && ch <= '9') {
                status = 10 * status + ch - 48;
                ++p;
            }
            while (p < len && header.charAt(p) == ' ') {
                ++p;
            }
            if (status > 0) {
                res.setStatus(status, header.substring(p));
                return NullValue.NULL;
            }
        }
        if ((colonIndex = header.indexOf(58)) > 0) {
            String encoding;
            String key = header.substring(0, colonIndex).trim();
            String value = header.substring(colonIndex + 1).trim();
            if (key.equalsIgnoreCase("Location")) {
                res.setStatus(302, "Found");
            }
            if (replace) {
                res.setHeader(key, value);
                ArrayList<String> headers = HttpModule.getHeaders(env);
                int regionEnd = colonIndex + 1;
                for (int i = 0; i < headers.size(); ++i) {
                    String compare = headers.get(i);
                    if (!compare.regionMatches(true, 0, header, 0, regionEnd)) continue;
                    headers.remove(i);
                    break;
                }
                headers.add(header);
            } else {
                res.addHeader(key, value);
                HttpModule.getHeaders(env).add(header);
            }
            if (key.equalsIgnoreCase("Content-Type") && (encoding = env.getOutputEncoding()) != null) {
                if (value.indexOf("charset") < 0) {
                    if (value.indexOf("text/") < 0) {
                        res.setCharacterEncoding(encoding);
                    }
                } else if ("".equals(res.getCharacterEncoding())) {
                    res.setCharacterEncoding(encoding);
                }
            }
        } else if ((header.equals("Not Modified") || header.equals("No Content")) && httpResponseCode != 0L) {
            res.setStatus((int)httpResponseCode, header);
        }
        return NullValue.NULL;
    }

    public static ArrayValue headers_list(Env env) {
        ArrayList<String> headersList = HttpModule.getHeaders(env);
        int size = headersList.size();
        ArrayValueImpl headersArray = new ArrayValueImpl(size);
        for (int i = 0; i < size; ++i) {
            headersArray.put(headersList.get(i));
        }
        return headersArray;
    }

    public static boolean headers_sent(Env env, @Optional @Reference Value file, @Optional @Reference Value line) {
        HttpServletResponse res = env.getResponse();
        return res.isCommitted();
    }

    public static boolean setcookie(Env env, String name, @Optional String value, @Optional long expire, @Optional String path, @Optional String domain, @Optional boolean secure, @Optional boolean httpOnly) {
        long now = Alarm.getCurrentTime();
        if (value == null || value.equals("")) {
            value = "";
        }
        StringBuilder sb = new StringBuilder();
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char ch = value.charAt(i);
            if ('0' <= ch && ch <= '9' || 'a' <= ch && ch <= 'z' || 'A' <= ch && ch <= 'Z' || ch == '-' || ch == '.' || ch == '_') {
                sb.append(ch);
                continue;
            }
            if (ch == ' ') {
                sb.append('+');
                continue;
            }
            sb.append('%');
            int d = ch / 16 & 0xF;
            if (d < 10) {
                sb.append((char)(48 + d));
            } else {
                sb.append((char)(65 + d - 10));
            }
            d = ch & 0xF;
            if (d < 10) {
                sb.append((char)(48 + d));
                continue;
            }
            sb.append((char)(65 + d - 10));
        }
        Cookie cookie = new Cookie(name, sb.toString());
        int maxAge = 0;
        if (expire > 0L) {
            maxAge = (int)(expire - now / 1000L);
            if (maxAge > 0) {
                cookie.setMaxAge(maxAge);
            } else {
                cookie.setMaxAge(0);
            }
        }
        if (path != null && !path.equals("")) {
            cookie.setPath(path);
        }
        if (domain != null && !domain.equals("")) {
            cookie.setDomain(domain);
        }
        if (secure) {
            cookie.setSecure(true);
        }
        env.getResponse().addCookie(cookie);
        StringBuilder cookieHeader = new StringBuilder();
        cookieHeader.append("Set-Cookie: ");
        cookieHeader.append(cookie.getName());
        cookieHeader.append("=");
        cookieHeader.append(cookie.getValue());
        if (maxAge == 0) {
            cookieHeader.append("; expires=Thu, 01-Dec-1994 16:00:00 GMT");
        } else {
            _calendar.setGMTTime(now + 1000L * (long)maxAge);
            cookieHeader.append("; expires=");
            cookieHeader.append(_calendar.format("%a, %d-%b-%Y %H:%M:%S GMT"));
        }
        if (path != null && !path.equals("")) {
            cookieHeader.append("; path=");
            cookieHeader.append(path);
        }
        if (domain != null && !domain.equals("")) {
            cookieHeader.append("; domain=");
            cookieHeader.append(domain);
        }
        if (secure) {
            cookieHeader.append("; secure");
        }
        HttpModule.getHeaders(env).add(cookieHeader.toString());
        return true;
    }

    public static String urldecode(String s) {
        int len = s.length();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            if (ch == '%' && i + 2 < len) {
                char d1 = s.charAt(i + 1);
                char d2 = s.charAt(i + 2);
                int v = 0;
                if ('0' <= d1 && d1 <= '9') {
                    v = 16 * (d1 - 48);
                } else if ('a' <= d1 && d1 <= 'f') {
                    v = 16 * (d1 - 97 + 10);
                } else if ('A' <= d1 && d1 <= 'F') {
                    v = 16 * (d1 - 65 + 10);
                } else {
                    sb.append('%');
                    continue;
                }
                if ('0' <= d2 && d2 <= '9') {
                    v += d2 - 48;
                } else if ('a' <= d2 && d2 <= 'f') {
                    v += d2 - 97 + 10;
                } else if ('A' <= d2 && d2 <= 'F') {
                    v += d2 - 65 + 10;
                } else {
                    sb.append('%');
                    continue;
                }
                i += 2;
                sb.append((char)v);
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }
}

