/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.file;

import com.caucho.quercus.QuercusModuleException;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.file.BinaryOutput;
import com.caucho.vfs.TempBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class AbstractBinaryOutput
extends OutputStream
implements BinaryOutput {
    private int lockedShared = 0;
    private boolean lockedExclusive = false;

    public OutputStream getOutputStream() {
        return this;
    }

    public int write(InputStream is, int length) {
        int writeLength = 0;
        TempBuffer tb = TempBuffer.allocate();
        byte[] buffer = tb.getBuffer();
        try {
            int sublen;
            while (length > 0) {
                sublen = length < buffer.length ? length : buffer.length;
                if ((sublen = is.read(buffer, 0, sublen)) < 0) break;
                this.write(buffer, 0, sublen);
                writeLength += sublen;
                length -= sublen;
            }
            sublen = writeLength;
            return sublen;
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
        finally {
            TempBuffer.free((TempBuffer)tb);
        }
    }

    public void print(char v) throws IOException {
        this.write((byte)v);
    }

    public void print(String v) throws IOException {
        for (int i = 0; i < v.length(); ++i) {
            this.write(v.charAt(i));
        }
    }

    public void flush() throws IOException {
    }

    public void closeWrite() {
        this.close();
    }

    public void close() {
    }

    public boolean isEOF() {
        return false;
    }

    public long getPosition() {
        return 0L;
    }

    public boolean setPosition(long offset) {
        return false;
    }

    public long seek(long offset, int whence) {
        long position;
        switch (whence) {
            case 1: {
                position = this.getPosition() + offset;
                break;
            }
            case 2: {
                position = this.getPosition();
                break;
            }
            default: {
                position = offset;
            }
        }
        if (!this.setPosition(position)) {
            return -1L;
        }
        return position;
    }

    public String getResourceType() {
        return "stream";
    }

    public Value stat() {
        return BooleanValue.FALSE;
    }
}

