/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.i18n;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.lib.i18n.Decoder;
import com.caucho.util.L10N;
import java.util.logging.Logger;

public class Utf8Decoder
extends Decoder {
    private static final Logger log = Logger.getLogger(Utf8Decoder.class.getName());
    private static final L10N L = new L10N(Utf8Decoder.class);
    private static final int ERROR_CHARACTER = 65534;
    private static final int EOF = -1;

    public Utf8Decoder(String charset) {
        super(charset);
    }

    public boolean isUtf8() {
        return true;
    }

    public boolean isDecodable(Env env, StringValue str) {
        int ch;
        if (str.isUnicode()) {
            return true;
        }
        Utf8Reader reader = new Utf8Reader(str);
        while ((ch = reader.read()) >= 0) {
            if (ch != 65534) continue;
            return false;
        }
        return true;
    }

    protected StringBuilder decodeImpl(Env env, StringValue str) {
        StringBuilder sb = new StringBuilder();
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char ch3;
            char ch2;
            char ch = str.charAt(i);
            if (ch <= '\u007f') {
                sb.append(ch);
                continue;
            }
            if ('\u00c2' <= ch && ch <= '\u00df') {
                if (i + 1 < len && '\u0080' <= (ch2 = str.charAt(i + 1)) && ch2 <= '\u00bf') {
                    ++i;
                    int code = (ch - 192 << 6) + (ch2 - 128);
                    sb.append((char)code);
                    continue;
                }
                if (this._isIgnoreErrors) continue;
                if (this._replacement != null) {
                    sb.append(this._replacement);
                    continue;
                }
                if (this._isAllowMalformedOut) {
                    sb.append(ch);
                    continue;
                }
                return sb;
            }
            if ('\u00e0' <= ch && ch <= '\u00ef') {
                if (i + 2 < len && '\u0080' <= (ch2 = str.charAt(i + 1)) && ch2 <= '\u00bf' && '\u0080' <= (ch3 = str.charAt(i + 2)) && ch3 <= '\u00bf') {
                    i += 2;
                    int code = (ch - 224 << 12) + (ch2 - 128 << 6) + (ch3 - 128);
                    if (55296 <= code && code <= 56319) {
                        int high = 55296 + ((code &= 0xFFFFF) >> 10);
                        int low = 56320 + (code & 0x3FF);
                        sb.append((char)high);
                        sb.append((char)low);
                        continue;
                    }
                    sb.append((char)code);
                    continue;
                }
                if (this._isIgnoreErrors) continue;
                if (this._replacement != null) {
                    sb.append(this._replacement);
                    continue;
                }
                if (this._isAllowMalformedOut) {
                    sb.append(ch);
                    continue;
                }
                return sb;
            }
            if ('\u00f0' <= ch && ch <= '\u00f4') {
                char ch4;
                if (i + 3 < len && '\u0080' <= (ch2 = str.charAt(i + 1)) && ch2 <= '\u00bf' && '\u0080' <= (ch3 = str.charAt(i + 2)) && ch3 <= '\u00bf' && '\u0080' <= (ch4 = str.charAt(i + 3)) && ch4 <= '\u00bf') {
                    i += 3;
                    int code = (ch - 240 << 18) + (ch2 - 128 << 12) + (ch3 - 128 << 6) + (ch4 - 128);
                    if (code > 65535 || 55296 <= code && code <= 56319) {
                        int high = 55296 + (code &= 0xFFFFF) >> 10;
                        int low = 56320 + code & 0x3FF;
                        sb.append((char)high);
                        sb.append((char)low);
                        continue;
                    }
                    sb.append((char)code);
                    continue;
                }
                if (this._isIgnoreErrors) continue;
                if (this._replacement != null) {
                    sb.append(this._replacement);
                    continue;
                }
                if (this._isAllowMalformedOut) {
                    sb.append(ch);
                    continue;
                }
                return sb;
            }
            if (this._isIgnoreErrors) continue;
            if (this._replacement != null) {
                sb.append(this._replacement);
                continue;
            }
            if (this._isAllowMalformedOut) {
                sb.append(ch);
                continue;
            }
            return sb;
        }
        return sb;
    }

    private static void decodeCodePoint(StringBuilder sb, int code) {
        int high = 55296 + (code &= 0xFFFFF) >> 10;
        int low = 56320 + code & 0x3FF;
        sb.append((char)high);
        sb.append((char)low);
    }

    static class Utf8Reader {
        int _peek = -1;
        int _index;
        final int _len;
        StringValue _str;

        public Utf8Reader(StringValue str) {
            this._str = str;
            this._len = str.length();
        }

        public int read() {
            int ch1;
            if (this._peek >= 0) {
                ch1 = this._peek;
                this._peek = -1;
            } else {
                ch1 = this.readByte();
            }
            if (ch1 < 128) {
                return ch1;
            }
            if ((ch1 & 0xE0) == 192) {
                int ch2 = this.readByte();
                if (ch2 < 0) {
                    return 65534;
                }
                if ((ch2 & 0xC0) != 128) {
                    this.unread();
                    return 65534;
                }
                return ((ch1 & 0x1F) << 6) + (ch2 & 0x3F);
            }
            if ((ch1 & 0xF0) == 224) {
                int ch2 = this.readByte();
                if (ch2 < 0) {
                    return 65534;
                }
                if ((ch2 & 0xC0) != 128) {
                    this.unread();
                    return 65534;
                }
                int ch3 = this.readByte();
                if (ch3 < 0) {
                    this.unread();
                    return 65534;
                }
                if ((ch3 & 0xC0) != 128) {
                    this.unread();
                    this.unread();
                    return 65534;
                }
                int ch = ((ch1 & 0x1F) << 12) + ((ch2 & 0x3F) << 6) + (ch3 & 0x3F);
                if (ch == 65279) {
                    return this.readByte();
                }
                return ch;
            }
            if ((ch1 & 0xF0) == 240) {
                int ch2 = this.readByte();
                if (ch2 < 0) {
                    return 65534;
                }
                if ((ch2 & 0xC0) != 128) {
                    this.unread();
                    return 65534;
                }
                int ch3 = this.readByte();
                if (ch3 < 0) {
                    this.unread();
                    return 65534;
                }
                if ((ch3 & 0xC0) != 128) {
                    this.unread();
                    this.unread();
                    return 65534;
                }
                int ch4 = this.readByte();
                if (ch4 < 0) {
                    this.unread();
                    this.unread();
                    return 65534;
                }
                if ((ch4 & 0xC0) != 128) {
                    this.unread();
                    this.unread();
                    this.unread();
                    return 65534;
                }
                int ch = ((ch1 & 0xF) << 18) + ((ch2 & 0x3F) << 12) + ((ch3 & 0x3F) << 6) + (ch4 & 0x3F);
                this._peek = 56320 + (ch & 0x3FF);
                return 55296 + (ch - 65536) / 1024;
            }
            return 65534;
        }

        private int readByte() {
            if (this._index < this._len) {
                return this._str.charAt(this._index++);
            }
            return -1;
        }

        private void unread() {
            --this._index;
        }
    }
}

