/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.xml;

import com.caucho.quercus.QuercusException;
import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.annotation.Reference;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Callback;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.util.L10N;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Xml {
    private static final Logger log = Logger.getLogger(Xml.class.getName());
    private static final L10N L = new L10N(Xml.class);
    private boolean _xmlOptionCaseFolding = true;
    private String _xmlOptionTargetEncoding;
    private long _xmlOptionSkipTagstart = 0L;
    private boolean _xmlOptionSkipWhite = false;
    private Env _env;
    private String _separator;
    private int _errorCode = 0;
    private String _errorString;
    private Callback _startElementHandler;
    private Callback _endElementHandler;
    private Callback _characterDataHandler;
    private Callback _processingInstructionHandler;
    private Callback _defaultHandler;
    private Callback _startNamespaceDeclHandler;
    private Callback _endNamespaceDeclHandler;
    private Callback _notationDeclHandler;
    private Callback _unparsedEntityDeclHandler;
    private Value _parser;
    private Value _obj;
    SAXParserFactory _factory = SAXParserFactory.newInstance();
    private StringValue _xmlString;
    private XmlHandler _xmlHandler;

    public Xml(Env env, String outputEncoding, String separator) {
        this._env = env;
        this._xmlOptionTargetEncoding = outputEncoding;
        this._parser = this._env.wrapJava(this);
        this._separator = separator;
    }

    public int getLine() {
        if (this._xmlHandler != null) {
            return this._xmlHandler.getLine();
        }
        return 0;
    }

    public int getColumn() {
        if (this._xmlHandler != null) {
            return this._xmlHandler.getColumn();
        }
        return 0;
    }

    public int getByteIndex() {
        return 0;
    }

    public int getErrorCode() {
        return this._errorCode;
    }

    public String getErrorString() {
        return this._errorString;
    }

    public boolean xml_set_element_handler(Value startElementHandler, Value endElementHandler) {
        if (this._obj == null) {
            this._startElementHandler = this._env.createCallback(startElementHandler);
            this._endElementHandler = this._env.createCallback(endElementHandler);
        } else {
            ArrayValueImpl value;
            if (!startElementHandler.isEmpty()) {
                value = new ArrayValueImpl();
                ((Value)value).put(this._obj);
                ((Value)value).put(startElementHandler);
                this._startElementHandler = this._env.createCallback(value);
            }
            if (!endElementHandler.isEmpty()) {
                value = new ArrayValueImpl();
                ((Value)value).put(this._obj);
                ((Value)value).put(endElementHandler);
                this._endElementHandler = this._env.createCallback(value);
            }
        }
        return true;
    }

    public boolean xml_set_character_data_handler(Value handler) {
        if (this._obj == null) {
            this._characterDataHandler = this._env.createCallback(handler);
        } else {
            ArrayValueImpl value = new ArrayValueImpl();
            ((Value)value).put(this._obj);
            ((Value)value).put(handler);
            this._characterDataHandler = this._env.createCallback(value);
        }
        return true;
    }

    public boolean xml_set_default_handler(Value handler) {
        if (this._obj == null) {
            this._defaultHandler = this._env.createCallback(handler);
        } else {
            ArrayValueImpl value = new ArrayValueImpl();
            ((Value)value).put(this._obj);
            ((Value)value).put(handler);
            this._defaultHandler = this._env.createCallback(value);
        }
        return true;
    }

    public boolean xml_set_processing_instruction_handler(Value processingInstructionHandler) {
        if (this._obj == null) {
            this._processingInstructionHandler = this._env.createCallback(processingInstructionHandler);
        } else {
            ArrayValueImpl value = new ArrayValueImpl();
            ((Value)value).put(this._obj);
            ((Value)value).put(processingInstructionHandler);
            this._processingInstructionHandler = this._env.createCallback(value);
        }
        return true;
    }

    public boolean xml_set_start_namespace_decl_handler(Value startNamespaceDeclHandler) {
        if (this._obj == null) {
            this._startNamespaceDeclHandler = this._env.createCallback(startNamespaceDeclHandler);
        } else {
            ArrayValueImpl value = new ArrayValueImpl();
            ((Value)value).put(this._obj);
            ((Value)value).put(startNamespaceDeclHandler);
            this._startNamespaceDeclHandler = this._env.createCallback(value);
        }
        return true;
    }

    public boolean xml_set_unparsed_entity_decl_handler(Value handler) {
        if (this._obj == null) {
            this._unparsedEntityDeclHandler = this._env.createCallback(handler);
        } else {
            ArrayValueImpl value = new ArrayValueImpl();
            ((Value)value).put(this._obj);
            ((Value)value).put(handler);
            this._unparsedEntityDeclHandler = this._env.createCallback(value);
        }
        return true;
    }

    public boolean xml_set_end_namespace_decl_handler(Value endNamespaceDeclHandler) {
        if (this._obj == null) {
            this._endNamespaceDeclHandler = this._env.createCallback(endNamespaceDeclHandler);
        } else {
            ArrayValueImpl value = new ArrayValueImpl();
            ((Value)value).put(this._obj);
            ((Value)value).put(endNamespaceDeclHandler);
            this._endNamespaceDeclHandler = this._env.createCallback(value);
        }
        return true;
    }

    public boolean xml_set_notation_decl_handler(Value handler) {
        if (this._obj == null) {
            this._notationDeclHandler = this._env.createCallback(handler);
        } else {
            ArrayValueImpl value = new ArrayValueImpl();
            ((Value)value).put(this._obj);
            ((Value)value).put(handler);
            this._notationDeclHandler = this._env.createCallback(value);
        }
        return true;
    }

    public boolean xml_set_object(Value obj) {
        if (obj == null) {
            return false;
        }
        this._obj = obj;
        return true;
    }

    public int xml_parse(Env env, StringValue data, @Optional(value="true") boolean isFinal) throws Exception {
        if (this._xmlString == null) {
            this._xmlString = data.createStringBuilder();
        }
        this._xmlString.append(data);
        if (isFinal) {
            InputSource is = this._xmlString.isUnicode() ? new InputSource(this._xmlString.toReader("utf-8")) : (this._xmlOptionTargetEncoding != null ? new InputSource(this._xmlString.toReader(this._xmlOptionTargetEncoding)) : new InputSource(this._xmlString.toInputStream()));
            if (this._xmlOptionTargetEncoding == null) {
                this._xmlOptionTargetEncoding = is.getEncoding();
            }
            try {
                this._errorCode = 0;
                this._errorString = null;
                this._xmlHandler = new XmlHandler();
                SAXParser saxParser = this._factory.newSAXParser();
                saxParser.parse(is, (DefaultHandler)this._xmlHandler);
            }
            catch (SAXException e) {
                this._errorCode = 2;
                this._errorString = e.toString();
                log.log(Level.FINE, e.getMessage(), e);
                return 0;
            }
            catch (IOException e) {
                this._errorCode = 2;
                this._errorString = e.toString();
                log.log(Level.FINE, e.getMessage(), e);
                return 0;
            }
            catch (Exception e) {
                this._errorCode = 2;
                this._errorString = e.toString();
                log.log(Level.FINE, e.toString(), e);
                return 0;
            }
        }
        return 1;
    }

    public int xml_parse_into_struct(Env env, StringValue data, @Reference Value valsV, @Optional @Reference Value indexV) throws Exception {
        ArrayValueImpl valueArray = new ArrayValueImpl();
        ArrayValueImpl indexArray = new ArrayValueImpl();
        valsV.set(valueArray);
        indexV.set(indexArray);
        if (data == null || data.length() == 0) {
            return 0;
        }
        if (this._xmlString == null) {
            this._xmlString = data.toStringBuilder();
        }
        InputSource is = this._xmlString.isUnicode() ? new InputSource(this._xmlString.toReader("utf-8")) : new InputSource(this._xmlString.toInputStream());
        try {
            SAXParser saxParser = this._factory.newSAXParser();
            saxParser.parse(is, (DefaultHandler)new StructHandler(valueArray, indexArray));
        }
        catch (SAXException e) {
            this._errorCode = 2;
            this._errorString = e.toString();
            log.log(Level.FINE, e.toString(), e);
            return 0;
        }
        catch (IOException e) {
            this._errorCode = 2;
            this._errorString = e.toString();
            log.log(Level.FINE, e.toString(), e);
            return 0;
        }
        catch (Exception e) {
            this._errorCode = 2;
            this._errorString = e.toString();
            log.log(Level.FINE, e.toString(), e);
            return 0;
        }
        return 1;
    }

    public boolean xml_parser_set_option(int option, Value value) {
        switch (option) {
            case 0: {
                this._xmlOptionCaseFolding = value.toBoolean();
                return true;
            }
            case 1: {
                this._xmlOptionSkipTagstart = value.toLong();
                return true;
            }
            case 2: {
                this._xmlOptionSkipWhite = value.toBoolean();
                return true;
            }
            case 3: {
                this._xmlOptionTargetEncoding = value.toString();
                return true;
            }
        }
        return false;
    }

    public Value xml_parser_get_option(int option) {
        switch (option) {
            case 0: {
                return this._xmlOptionCaseFolding ? LongValue.ONE : LongValue.ZERO;
            }
            case 1: {
                return LongValue.create(this._xmlOptionSkipTagstart);
            }
            case 2: {
                return this._xmlOptionSkipWhite ? LongValue.ONE : LongValue.ZERO;
            }
            case 3: {
                return this._env.createString(this._xmlOptionTargetEncoding);
            }
        }
        return BooleanValue.FALSE;
    }

    public String toString() {
        return "Xml[]";
    }

    class XmlHandler
    extends DefaultHandler {
        private Locator _locator;

        XmlHandler() {
        }

        public void setDocumentLocator(Locator locator) {
            this._locator = locator;
        }

        public int getLine() {
            if (this._locator != null) {
                return this._locator.getLineNumber();
            }
            return 0;
        }

        public int getColumn() {
            if (this._locator != null) {
                return this._locator.getColumnNumber();
            }
            return 0;
        }

        public void startElement(String namespaceURI, String lName, String qName, Attributes attrs) throws SAXException {
            Value[] args = new Value[3];
            args[0] = Xml.this._parser;
            String eName = lName;
            if ("".equals(eName)) {
                eName = qName;
            }
            if (Xml.this._xmlOptionCaseFolding) {
                eName = eName.toUpperCase();
            }
            args[1] = Xml.this._env.createString(eName);
            args[2] = new ArrayValueImpl();
            for (int i = 0; i < attrs.getLength(); ++i) {
                String aName = attrs.getLocalName(i);
                if ("".equals(aName)) {
                    aName = attrs.getQName(i);
                }
                if (Xml.this._xmlOptionCaseFolding) {
                    aName = aName.toUpperCase();
                }
                args[2].put(Xml.this._env.createString(aName), Xml.this._env.createString(attrs.getValue(i)));
            }
            try {
                if (Xml.this._startElementHandler != null) {
                    Xml.this._startElementHandler.call(Xml.this._env, args);
                } else if (log.isLoggable(Level.FINER)) {
                    log.finer(this + " startElement " + qName);
                }
            }
            catch (Exception t) {
                log.log(Level.FINE, t.toString(), t);
                throw new SAXException(L.l(t.getMessage()));
            }
        }

        public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
            try {
                String eName = sName;
                if ("".equals(eName)) {
                    eName = qName;
                }
                if (Xml.this._xmlOptionCaseFolding) {
                    eName = eName.toUpperCase();
                }
                if (Xml.this._endElementHandler != null) {
                    Xml.this._endElementHandler.call(Xml.this._env, Xml.this._parser, Xml.this._env.createString(eName));
                } else if (log.isLoggable(Level.FINER)) {
                    log.finer(this + " endElement " + sName);
                }
            }
            catch (Exception t) {
                log.log(Level.FINE, t.toString(), t);
                throw new SAXException(L.l(t.getMessage()));
            }
        }

        public void characters(char[] buf, int start, int length) throws SAXException {
            StringValue value;
            if (Xml.this._env.isUnicodeSemantics()) {
                value = Xml.this._env.createString(buf, start, length);
            } else {
                byte[] bytes;
                String s = new String(buf, start, length);
                try {
                    bytes = s.getBytes(Xml.this._xmlOptionTargetEncoding);
                }
                catch (UnsupportedEncodingException e) {
                    throw new QuercusException(e);
                }
                value = Xml.this._env.createStringBuilder();
                value.append(bytes);
            }
            try {
                if (Xml.this._characterDataHandler != null) {
                    Xml.this._characterDataHandler.call(Xml.this._env, Xml.this._parser, value);
                } else if (Xml.this._defaultHandler != null) {
                    Xml.this._defaultHandler.call(Xml.this._env, Xml.this._parser, value);
                } else if (log.isLoggable(Level.FINER)) {
                    log.finer(this + " characters '" + value + "'");
                }
            }
            catch (Exception t) {
                log.log(Level.FINE, t.toString(), t);
                throw new SAXException(L.l(t.getMessage()));
            }
        }

        public void processingInstruction(String target, String data) throws SAXException {
            try {
                if (Xml.this._processingInstructionHandler != null) {
                    Xml.this._processingInstructionHandler.call(Xml.this._env, Xml.this._parser, (Value)Xml.this._env.createString(target), (Value)Xml.this._env.createString(data));
                } else if (log.isLoggable(Level.FINER)) {
                    log.finer(this + " processingInstruction " + target);
                }
            }
            catch (Exception t) {
                log.log(Level.FINE, t.toString(), t);
                throw new SAXException(L.l(t.getMessage()));
            }
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            try {
                if (Xml.this._startNamespaceDeclHandler != null) {
                    Xml.this._startNamespaceDeclHandler.call(Xml.this._env, Xml.this._env.createString(prefix), Xml.this._env.createString(uri));
                } else if (log.isLoggable(Level.FINER)) {
                    log.finer(this + " startPrefixMapping " + prefix + " " + uri);
                }
            }
            catch (Exception t) {
                log.log(Level.FINE, t.toString(), t);
                throw new SAXException(L.l(t.getMessage()));
            }
        }

        public void endPrefixMapping(String prefix) throws SAXException {
            try {
                if (Xml.this._endNamespaceDeclHandler != null) {
                    Xml.this._endNamespaceDeclHandler.call(Xml.this._env, Xml.this._env.createString(prefix));
                } else if (log.isLoggable(Level.FINER)) {
                    log.finer(this + " endPrefixMapping");
                }
            }
            catch (Exception t) {
                log.log(Level.FINE, t.toString(), t);
                throw new SAXException(L.l(t.getMessage()));
            }
        }

        public void notationDecl(String name, String publicId, String systemId) throws SAXException {
            try {
                if (Xml.this._notationDeclHandler != null) {
                    Xml.this._notationDeclHandler.call(Xml.this._env, Xml.this._parser, (Value)Xml.this._env.createString(name), (Value)Xml.this._env.createString(""), (Value)Xml.this._env.createString(systemId), (Value)Xml.this._env.createString(publicId));
                } else if (log.isLoggable(Level.FINER)) {
                    log.finer(this + " notation " + name);
                }
            }
            catch (Exception t) {
                log.log(Level.FINE, t.toString(), t);
                throw new SAXException(L.l(t.getMessage()));
            }
        }

        public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
            Value[] args = new Value[]{Xml.this._parser, Xml.this._env.createString(name), Xml.this._env.createString(""), Xml.this._env.createString(systemId), Xml.this._env.createString(publicId), Xml.this._env.createString(notationName)};
            try {
                if (Xml.this._unparsedEntityDeclHandler != null) {
                    Xml.this._unparsedEntityDeclHandler.call(Xml.this._env, args);
                } else if (log.isLoggable(Level.FINER)) {
                    log.finer(this + " unparsedEntity " + name);
                }
            }
            catch (Exception t) {
                log.log(Level.FINE, t.toString(), t);
                throw new SAXException(L.l(t.getMessage()));
            }
        }
    }

    class StructHandler
    extends DefaultHandler {
        private ArrayValueImpl _valueArray;
        private ArrayValueImpl _indexArray;
        private int _level = 1;
        private HashMap<Integer, String> _paramHashMap = new HashMap();
        private HashMap<StringValue, ArrayValueImpl> _indexArrayHashMap = new HashMap();
        private ArrayList<StringValue> _indexArrayKeys = new ArrayList();
        private boolean _isComplete = true;
        private boolean _isOutside = true;
        private int _valueArrayIndex = 0;
        private Locator _locator;

        public StructHandler(ArrayValueImpl valueArray, ArrayValueImpl indexArray) {
            this._valueArray = valueArray;
            this._indexArray = indexArray;
        }

        public void setDocumentLocator(Locator locator) {
            this._locator = locator;
        }

        public int getLine() {
            if (this._locator != null) {
                return this._locator.getLineNumber();
            }
            return 0;
        }

        public int getColumn() {
            if (this._locator != null) {
                return this._locator.getColumnNumber();
            }
            return 0;
        }

        private ArrayValueImpl createAttributeArray(Attributes attrs) {
            ArrayValueImpl result = new ArrayValueImpl();
            for (int i = 0; i < attrs.getLength(); ++i) {
                String aName = attrs.getLocalName(i);
                if ("".equals(aName)) {
                    aName = attrs.getQName(i);
                }
                if (Xml.this._xmlOptionCaseFolding) {
                    aName = aName.toUpperCase();
                }
                result.put(Xml.this._env.createString(aName), Xml.this._env.createString(attrs.getValue(i)));
            }
            return result;
        }

        public void endDocument() throws SAXException {
            for (StringValue sv : this._indexArrayKeys) {
                this._indexArray.put(sv, this._indexArrayHashMap.get(sv));
            }
        }

        public void startElement(String namespaceURI, String lName, String qName, Attributes attrs) throws SAXException {
            ArrayValueImpl elementArray = new ArrayValueImpl();
            String eName = lName;
            if ("".equals(eName)) {
                eName = qName;
            }
            if (Xml.this._xmlOptionCaseFolding) {
                eName = eName.toUpperCase();
            }
            ((Value)elementArray).put(Xml.this._env.createString("tag"), Xml.this._env.createString(eName));
            ((Value)elementArray).put(Xml.this._env.createString("type"), Xml.this._env.createString("open"));
            ((Value)elementArray).put(Xml.this._env.createString("level"), LongValue.create(this._level));
            this._paramHashMap.put(this._level, eName);
            if (attrs.getLength() > 0) {
                ((Value)elementArray).put(Xml.this._env.createString("attributes"), this.createAttributeArray(attrs));
            }
            this._valueArray.put(LongValue.create(this._valueArrayIndex), elementArray);
            this.addToIndexArrayHashMap(eName);
            ++this._valueArrayIndex;
            ++this._level;
            this._isComplete = true;
            this._isOutside = false;
        }

        public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
            --this._level;
            if (this._isComplete) {
                Value elementArray = this._valueArray.get(LongValue.create(this._valueArrayIndex - 1));
                elementArray.put(Xml.this._env.createString("type"), Xml.this._env.createString("complete"));
            } else {
                ArrayValueImpl elementArray = new ArrayValueImpl();
                String eName = sName;
                if ("".equals(sName)) {
                    eName = qName;
                }
                if (Xml.this._xmlOptionCaseFolding) {
                    eName = eName.toUpperCase();
                }
                ((Value)elementArray).put(Xml.this._env.createString("tag"), Xml.this._env.createString(eName));
                ((Value)elementArray).put(Xml.this._env.createString("type"), Xml.this._env.createString("close"));
                ((Value)elementArray).put(Xml.this._env.createString("level"), LongValue.create(this._level));
                this._valueArray.put(LongValue.create(this._valueArrayIndex), elementArray);
                this.addToIndexArrayHashMap(eName);
                ++this._valueArrayIndex;
            }
            this._isComplete = false;
            this._isOutside = true;
        }

        private void addToIndexArrayHashMap(String eName) {
            StringValue key = Xml.this._env.createString(eName);
            ArrayValueImpl indexArray = this._indexArrayHashMap.get(key);
            if (indexArray == null) {
                indexArray = new ArrayValueImpl();
                this._indexArrayKeys.add(key);
            }
            indexArray.put(LongValue.create(this._valueArrayIndex));
            this._indexArrayHashMap.put(key, indexArray);
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            String s = new String(ch, start, length);
            if (this._isOutside) {
                ArrayValueImpl elementArray = new ArrayValueImpl();
                ((Value)elementArray).put(Xml.this._env.createString("tag"), Xml.this._env.createString(this._paramHashMap.get(this._level - 1)));
                ((Value)elementArray).put(Xml.this._env.createString("value"), Xml.this._env.createString(s));
                ((Value)elementArray).put(Xml.this._env.createString("type"), Xml.this._env.createString("cdata"));
                ((Value)elementArray).put(Xml.this._env.createString("level"), LongValue.create(this._level - 1));
                this._valueArray.put(LongValue.create(this._valueArrayIndex), elementArray);
                Value indexArray = this._indexArray.get(Xml.this._env.createString(this._paramHashMap.get(this._level - 1)));
                indexArray.put(LongValue.create(this._valueArrayIndex));
                ++this._valueArrayIndex;
            } else {
                Value elementArray = this._valueArray.get(LongValue.create(this._valueArrayIndex - 1));
                elementArray.put(Xml.this._env.createString("value"), Xml.this._env.createString(s));
            }
        }
    }
}

