/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.pbx.internal.core;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.asteriskjava.manager.ManagerEventListener;
import org.asteriskjava.manager.event.ManagerEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.BridgeEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.LinkEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.UnlinkEvent;
import org.asteriskjava.pbx.internal.core.CoherentEventFactory;
import org.asteriskjava.pbx.internal.core.CoherentManagerConnection;
import org.asteriskjava.pbx.internal.core.FilteredManagerListener;
import org.asteriskjava.pbx.internal.eventQueue.EventLifeMonitor;
import org.asteriskjava.pbx.util.LogTime;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

class CoherentManagerEventQueue
implements ManagerEventListener,
Runnable {
    private static final Log logger = LogFactory.getLog(CoherentManagerEventQueue.class);
    private final TreeSet<Listener> listeners = new TreeSet<Listener>(new ListenerPriorityComparator());
    private boolean _stop = false;
    private final Thread _th;
    private final BlockingQueue<EventLifeMonitor<ManagerEvent>> _eventQueue = new LinkedBlockingQueue<EventLifeMonitor<ManagerEvent>>();
    private int _queueMaxSize;
    private long _queueSum;
    private long _queueCount;
    private HashSet<Class<? extends org.asteriskjava.pbx.asterisk.wrap.events.ManagerEvent>> globalEvents = new HashSet();

    public CoherentManagerEventQueue(String name) {
        CoherentManagerConnection.managerConnection.addEventListener(this);
        this._th = new Thread(this);
        this._th.setName("EventQueue: " + name);
        this._th.setDaemon(true);
        this._th.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onManagerEvent(ManagerEvent event) {
        boolean wanted = false;
        HashSet<Class<? extends org.asteriskjava.pbx.asterisk.wrap.events.ManagerEvent>> hashSet = this.globalEvents;
        synchronized (hashSet) {
            Class<? extends org.asteriskjava.pbx.asterisk.wrap.events.ManagerEvent> shadowEvent = CoherentEventFactory.getShadowEvent(event);
            if (this.globalEvents.contains(shadowEvent)) {
                wanted = true;
            }
        }
        if (wanted) {
            this._eventQueue.add(new EventLifeMonitor<ManagerEvent>(event));
            int queueSize = this._eventQueue.size();
            if (this._queueMaxSize < queueSize) {
                this._queueMaxSize = queueSize;
            }
            this._queueSum += (long)queueSize;
            ++this._queueCount;
            if (logger.isDebugEnabled() && (long)this._eventQueue.size() > ((long)this._queueMaxSize + this._queueSum / this._queueCount) / 2L) {
                logger.debug("queue gtr max avg: size=" + queueSize + " max:" + this._queueMaxSize + " avg:" + this._queueSum / this._queueCount);
            }
        }
    }

    @Override
    public void run() {
        while (!this._stop) {
            try {
                EventLifeMonitor<ManagerEvent> elm = this._eventQueue.poll(2L, TimeUnit.SECONDS);
                if (elm == null) continue;
                if (elm.getEvent().getClass() == PoisonQueueEvent.class) break;
                org.asteriskjava.pbx.asterisk.wrap.events.ManagerEvent iEvent = CoherentEventFactory.build(elm.getEvent());
                if (iEvent == null) continue;
                this.dispatchEvent(iEvent);
                elm.assessAge();
            }
            catch (Exception e) {
                if (this._stop) continue;
                logger.error(e, e);
            }
        }
    }

    public void stop() {
        this._stop = true;
        try {
            this._eventQueue.put(new EventLifeMonitor<PoisonQueueEvent>(new PoisonQueueEvent()));
        }
        catch (InterruptedException e) {
            logger.error(e, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchEvent(org.asteriskjava.pbx.asterisk.wrap.events.ManagerEvent event) {
        if (logger.isDebugEnabled()) {
            logger.debug("dispatch=" + event.toString());
        }
        TreeSet<Listener> listenerCopy = new TreeSet<Listener>(new ListenerPriorityComparator());
        TreeSet<Listener> treeSet = this.listeners;
        synchronized (treeSet) {
            listenerCopy.addAll(this.listeners);
        }
        for (Listener filter : listenerCopy) {
            if (!filter.requiredEvents.contains(event.getClass())) continue;
            LogTime time = new LogTime();
            filter._listener.onManagerEvent(event);
            if (time.timeTaken() <= 500L) continue;
            logger.warn("ManagerListener :" + filter._listener.getName() + " is taken too long to process event " + event + " time taken: " + time.timeTaken());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(FilteredManagerListener<org.asteriskjava.pbx.asterisk.wrap.events.ManagerEvent> listener) {
        TreeSet<Listener> treeSet = this.listeners;
        synchronized (treeSet) {
            this.listeners.add(new Listener(listener));
            HashSet<Class<? extends org.asteriskjava.pbx.asterisk.wrap.events.ManagerEvent>> hashSet = this.globalEvents;
            synchronized (hashSet) {
                this.globalEvents.addAll(listener.requiredEvents());
            }
        }
        logger.debug("listener  added");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(FilteredManagerListener<org.asteriskjava.pbx.asterisk.wrap.events.ManagerEvent> melf) {
        TreeSet<Listener> treeSet = this.listeners;
        synchronized (treeSet) {
            if (melf != null) {
                for (Listener container : this.listeners) {
                    if (container._listener != melf) continue;
                    this.listeners.remove(container);
                    HashSet<Class<? extends org.asteriskjava.pbx.asterisk.wrap.events.ManagerEvent>> hashSet = this.globalEvents;
                    synchronized (hashSet) {
                        this.globalEvents.clear();
                        for (Listener readdContainer : this.listeners) {
                            this.globalEvents.addAll(readdContainer._listener.requiredEvents());
                        }
                        break;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transferListeners(CoherentManagerEventQueue eventQueue) {
        TreeSet<Listener> treeSet = this.listeners;
        synchronized (treeSet) {
            TreeSet<Listener> treeSet2 = eventQueue.listeners;
            synchronized (treeSet2) {
                for (Listener listener : eventQueue.listeners) {
                    this.addListener(listener._listener);
                }
                eventQueue.listeners.clear();
            }
        }
    }

    final class ListenerPriorityComparator
    implements Comparator<Listener> {
        ListenerPriorityComparator() {
        }

        @Override
        public int compare(Listener lhs, Listener rhs) {
            int result = lhs._listener.getPriority().compare(rhs._listener.getPriority());
            if (result == 0) {
                result = lhs._listener.equals(rhs._listener) ? 0 : 1;
            }
            return result;
        }
    }

    class PoisonQueueEvent
    extends ManagerEvent {
        private static final long serialVersionUID = 1L;

        public PoisonQueueEvent() {
            super("PoisonQueueEvent");
        }
    }

    private class Listener {
        FilteredManagerListener<org.asteriskjava.pbx.asterisk.wrap.events.ManagerEvent> _listener;
        Set<Class<? extends org.asteriskjava.pbx.asterisk.wrap.events.ManagerEvent>> requiredEvents;

        public Listener(FilteredManagerListener<org.asteriskjava.pbx.asterisk.wrap.events.ManagerEvent> listener) {
            this._listener = listener;
            this.requiredEvents = listener.requiredEvents();
            if (this.requiredEvents.contains(BridgeEvent.class)) {
                this.requiredEvents.add(LinkEvent.class);
                this.requiredEvents.add(UnlinkEvent.class);
            }
            for (Class<? extends org.asteriskjava.pbx.asterisk.wrap.events.ManagerEvent> event : this.requiredEvents) {
                if (CoherentEventFactory.mapEvents.values().contains(event) || CoherentEventFactory.mapResponses.values().contains(event)) continue;
                throw new RuntimeException("The requested event type of " + event + "+isn't known by " + CoherentEventFactory.class);
            }
        }

        public String toString() {
            return this._listener.getName();
        }
    }
}

