/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.pbx.internal.activity;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.asteriskjava.pbx.ActivityCallback;
import org.asteriskjava.pbx.Channel;
import org.asteriskjava.pbx.ListenerPriority;
import org.asteriskjava.pbx.PBXException;
import org.asteriskjava.pbx.PBXFactory;
import org.asteriskjava.pbx.activities.BridgeActivity;
import org.asteriskjava.pbx.agi.AgiChannelActivityBridge;
import org.asteriskjava.pbx.agi.AgiChannelActivityHoldForBridge;
import org.asteriskjava.pbx.asterisk.wrap.events.BridgeEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.LinkEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.ManagerEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.StatusCompleteEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.StatusEvent;
import org.asteriskjava.pbx.internal.activity.ActivityHelper;
import org.asteriskjava.pbx.internal.asterisk.DurationRoomOwner;
import org.asteriskjava.pbx.internal.asterisk.MeetmeRoom;
import org.asteriskjava.pbx.internal.core.AsteriskPBX;
import org.asteriskjava.pbx.internal.managerAPI.RedirectToMeetMe;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

public class BridgeActivityImpl
extends ActivityHelper<BridgeActivity>
implements BridgeActivity {
    private static final Log logger = LogFactory.getLog(BridgeActivityImpl.class);
    private final Channel _lhsChannel;
    private final Channel _rhsChannel;
    private CountDownLatch _bridgeLatch;

    public BridgeActivityImpl(Channel lhsChannel, Channel rhsChannel, ActivityCallback<BridgeActivity> callback) {
        super("Bridge", callback);
        this._lhsChannel = lhsChannel;
        this._rhsChannel = rhsChannel;
        this.startActivity(true);
    }

    @Override
    public boolean doActivity() throws PBXException {
        boolean success;
        block9: {
            success = false;
            logger.debug("*******************************************************************************");
            logger.info("***********                    begin Bridge                ****************");
            logger.info("***********                  lhs:" + this._lhsChannel + " ****************");
            logger.debug("***********                  rhs:" + this._rhsChannel + " ****************");
            logger.debug("*******************************************************************************");
            try {
                AsteriskPBX pbx = (AsteriskPBX)PBXFactory.getActivePBX();
                if (!pbx.moveChannelToAgi(this._lhsChannel)) {
                    throw new PBXException("Channel: " + this._lhsChannel + " couldn't be moved to agi");
                }
                if (!pbx.moveChannelToAgi(this._rhsChannel)) {
                    throw new PBXException("Channel: " + this._rhsChannel + " couldn't be moved to agi");
                }
                LinkedList<Channel> channels = new LinkedList<Channel>();
                channels.add(this._lhsChannel);
                channels.add(this._rhsChannel);
                if (!pbx.waitForChannelsToQuiescent(channels, 3000L)) {
                    throw new PBXException("Channel: " + this._lhsChannel + " cannot be held as it is still in transition.");
                }
                try {
                    if (pbx.isBridgeSupported()) {
                        this._bridgeLatch = new CountDownLatch(1);
                        AgiChannelActivityBridge action = new AgiChannelActivityBridge(this._lhsChannel);
                        this._lhsChannel.setCurrentActivityAction(new AgiChannelActivityHoldForBridge(action));
                        this._rhsChannel.setCurrentActivityAction(action);
                        success = this._bridgeLatch.await(3L, TimeUnit.SECONDS);
                        break block9;
                    }
                    if (pbx.isMeetmeInstalled()) {
                        RedirectToMeetMe meetmeTransfer = new RedirectToMeetMe();
                        MeetmeRoom room = pbx.acquireMeetmeRoom(new DurationRoomOwner(30L, TimeUnit.SECONDS));
                        meetmeTransfer.redirectToMeetme(this._lhsChannel, room.getRoomNumber(), true, false);
                        boolean markedCall = !this._rhsChannel.canDetectHangup();
                        meetmeTransfer.redirectToMeetme(this._rhsChannel, room.getRoomNumber(), markedCall, false);
                        success = true;
                        break block9;
                    }
                    throw new PBXException("Cannot bridge two calls as neither the BridgeAction nor Meetme is available");
                }
                catch (IllegalArgumentException | IllegalStateException | InterruptedException e) {
                    throw new PBXException(e);
                }
            }
            catch (IllegalArgumentException | IllegalStateException e) {
                logger.error(e, e);
                logger.error(e, e);
                throw new PBXException(e);
            }
        }
        return success;
    }

    @Override
    public HashSet<Class<? extends ManagerEvent>> requiredEvents() {
        HashSet<Class<? extends ManagerEvent>> required = new HashSet<Class<? extends ManagerEvent>>();
        required.add(StatusCompleteEvent.class);
        required.add(StatusEvent.class);
        required.add(BridgeEvent.class);
        required.add(LinkEvent.class);
        return required;
    }

    @Override
    public ListenerPriority getPriority() {
        return ListenerPriority.NORMAL;
    }

    @Override
    public void onManagerEvent(ManagerEvent event) {
        BridgeEvent bridge;
        if (event instanceof BridgeEvent && (bridge = (BridgeEvent)event).isLink() && (bridge.getChannel1().isSame(this._lhsChannel) || bridge.getChannel1().isSame(this._rhsChannel)) && (bridge.getChannel2().isSame(this._lhsChannel) || bridge.getChannel2().isSame(this._rhsChannel))) {
            this._bridgeLatch.countDown();
        }
    }
}

