/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import java.net.InetAddress;
import java.util.logging.Level;
import java.util.logging.Logger;

public class InetNetwork {
    private static final Logger log = Logger.getLogger(InetNetwork.class.getName());
    private long _hiAddress;
    private long _address;
    private long _mask;
    private int _maskIndex;

    public InetNetwork(InetAddress inetAddress, int maskIndex) {
        byte[] bytes = inetAddress.getAddress();
        long address = 0L;
        for (int i = 0; i < bytes.length; ++i) {
            address = 256L * address + (long)(bytes[i] & 0xFF);
        }
        this._address = address;
        this._maskIndex = maskIndex;
        this._mask = -1L << 8 * bytes.length - maskIndex;
    }

    public InetNetwork(long address, int maskIndex) {
        this._address = address;
        this._maskIndex = maskIndex;
        this._mask = -1L << 32 - maskIndex;
    }

    public InetNetwork(long hiAddress, long loAddress, int maskIndex) {
        this._hiAddress = hiAddress;
        this._address = loAddress;
        this._maskIndex = maskIndex;
        this._mask = -1L << 64 - maskIndex;
    }

    public static InetNetwork create(String network) {
        if (network == null) {
            return null;
        }
        int i = 0;
        int len = network.length();
        if (network.indexOf(58) >= 0) {
            return InetNetwork.createIPv6(network);
        }
        long address = 0L;
        int digits = 0;
        char ch = '\u0000';
        while (i < len && network.charAt(i) != '/') {
            int digit = 0;
            while (i < len && '0' <= (ch = network.charAt(i)) && ch <= '9') {
                digit = 10 * digit + ch - 48;
                ++i;
            }
            address = 256L * address + (long)digit;
            ++digits;
            if (i < len && ch == '.') {
                ++i;
                continue;
            }
            if (i >= len) continue;
            break;
        }
        int mask = 8 * digits;
        while (digits < 4) {
            address *= 256L;
            ++digits;
        }
        if (i < len && network.charAt(i) == '/') {
            mask = 0;
            ++i;
            while (i < len && '0' <= (ch = network.charAt(i)) && ch <= '9') {
                mask = 10 * mask + ch - 48;
                ++i;
            }
        }
        return new InetNetwork(address, mask);
    }

    public static InetNetwork createIPv6(String network) {
        int i = 0;
        int len = network.length();
        long hi = 0L;
        long lo = 0L;
        long topHi = 0L;
        long topLo = 0L;
        int digits = 0;
        boolean isIPv4 = false;
        char ch = '\u0000';
        while (i < len && (ch = network.charAt(i)) != '/') {
            int digit = 0;
            while (i < len) {
                ch = network.charAt(i);
                int v = 0;
                if ('0' <= ch && ch <= '9') {
                    v = ch - 48;
                } else if ('a' <= ch && ch <= 'f') {
                    v = ch - 97;
                } else {
                    if ('A' > ch || ch > 'F') break;
                    v = ch - 65;
                }
                digit = isIPv4 ? 10 * digit + v : 16 * digit + v;
                ++i;
            }
            if (ch == '.' && !isIPv4) {
                digit = digit / 256 * 100 + digit / 16 % 16 * 10 + digit % 16;
                isIPv4 = true;
            }
            if (isIPv4) {
                hi = (hi << 8) + (lo >> 56);
                lo = (lo << 8) + (long)digit;
                ++digits;
            } else {
                hi = (hi << 16) + (lo >> 48);
                lo = (lo << 16) + (long)digit;
                digits += 2;
            }
            if (len <= i || ch == '/') break;
            if (ch == '.') {
                ++i;
                continue;
            }
            if (ch == ':' && i + 1 < len && network.charAt(i + 1) == ':') {
                i += 2;
                int shift = 16 - digits;
                topHi += hi << 8 * shift;
                topHi = shift < 8 ? (topHi += lo >> 8 * (8 - shift)) : (topHi += lo << 8 * (shift - 8));
                hi = 0L;
                lo = 0L;
                continue;
            }
            if (ch != ':') break;
            ++i;
        }
        hi += topHi;
        lo += topLo;
        int mask = 64;
        if (i < len && network.charAt(i) == '/') {
            mask = 0;
            ++i;
            while (i < len && (ch = network.charAt(i)) >= '0' && ch <= '9') {
                mask = 10 * mask + ch - 48;
                ++i;
            }
        }
        return new InetNetwork(hi, lo, mask);
    }

    public boolean isMatch(InetAddress inetAddress) {
        byte[] bytes = inetAddress.getAddress();
        long address = 0L;
        for (int i = 0; i < bytes.length; ++i) {
            address = 256L * address + (long)(bytes[i] & 0xFF);
        }
        return (this._address & this._mask) == (address & this._mask);
    }

    public boolean isMatch(byte[] bytes) {
        long address = 0L;
        for (int i = 0; i < bytes.length; ++i) {
            address = 256L * address + (long)(bytes[i] & 0xFF);
        }
        return (this._address & this._mask) == (address & this._mask);
    }

    public boolean isMatch(String address) {
        try {
            return this.isMatch(InetAddress.getByName(address));
        }
        catch (Exception e) {
            log.log(Level.FINER, e.toString(), e);
            return false;
        }
    }

    public boolean isMatch(long address) {
        return (this._address & this._mask) == (address & this._mask);
    }

    public String toString() {
        StringBuilder cb = new StringBuilder();
        for (int i = 0; i < 4; ++i) {
            if (i != 0) {
                cb.append('.');
            }
            cb.append(this._address >> (3 - i) * 8 & 0xFFL);
        }
        cb.append('/');
        cb.append(this._maskIndex);
        return cb.toString();
    }
}

