/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.vfs.FileRandomAccessStream;
import com.caucho.vfs.LockableStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.StreamImpl;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileReadStream
extends StreamImpl
implements LockableStream {
    private static final Logger log = Logger.getLogger(FileRandomAccessStream.class.getName());
    private FileInputStream _is;
    private FileLock _fileLock;
    private FileChannel _fileChannel;

    public FileReadStream() {
    }

    public FileReadStream(FileInputStream is) {
        this.init(is);
    }

    public FileReadStream(FileInputStream is, Path path) {
        this.init(is);
        this.setPath(path);
    }

    public void init(FileInputStream is) {
        this._is = is;
        this.setPath(null);
    }

    public boolean hasSkip() {
        return this._is != null;
    }

    public long skip(long n) throws IOException {
        if (this._is != null) {
            return this._is.skip(n);
        }
        return -1L;
    }

    public void seekStart(long offset) throws IOException {
        if (this._is != null) {
            this._is.getChannel().position(offset);
        }
    }

    public boolean canRead() {
        return this._is != null;
    }

    public int read(byte[] buf, int offset, int length) throws IOException {
        if (this._is == null) {
            return -1;
        }
        int len = this._is.read(buf, offset, length);
        return len;
    }

    public int getAvailable() throws IOException {
        if (this._is == null) {
            return -1;
        }
        return this._is.available();
    }

    public void close() throws IOException {
        this.unlock();
        this._fileChannel = null;
        FileInputStream is = this._is;
        this._is = null;
        if (is != null) {
            ((InputStream)is).close();
        }
    }

    public boolean lock(boolean shared, boolean block) {
        this.unlock();
        if (!shared) {
            return false;
        }
        try {
            if (this._fileChannel == null) {
                this._fileChannel = this._is.getChannel();
            }
            this._fileLock = block ? this._fileChannel.lock(0L, Long.MAX_VALUE, true) : this._fileChannel.tryLock(0L, Long.MAX_VALUE, true);
            return this._fileLock != null;
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
            return false;
        }
    }

    public boolean unlock() {
        try {
            FileLock lock = this._fileLock;
            this._fileLock = null;
            if (lock != null) {
                lock.release();
                return true;
            }
            return false;
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
            return false;
        }
    }
}

