/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.reflection;

import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.ObjectValue;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.reflection.ReflectionClass;
import com.caucho.quercus.lib.reflection.ReflectionException;
import com.caucho.quercus.lib.reflection.Reflector;
import com.caucho.util.L10N;

public class ReflectionProperty
implements Reflector {
    private static final L10N L = new L10N(ReflectionProperty.class);
    public static final int IS_STATIC = 1;
    public static final int IS_PUBLIC = 256;
    public static final int IS_PROTECTED = 512;
    public static final int IS_PRIVATE = 1024;
    private Property _prop;

    protected ReflectionProperty(Env env, QuercusClass cls, StringValue nameV) {
        this._prop = Property.create(env, cls, nameV);
    }

    private final void __clone() {
    }

    public static ReflectionProperty __construct(Env env, String clsName, StringValue propName) {
        QuercusClass cls = env.findClass(clsName);
        if (cls == null) {
            throw new ReflectionException(L.l("Cannot find class '{0}'", (Object)clsName));
        }
        return new ReflectionProperty(env, cls, propName);
    }

    public static String export(Env env, Value cls, String name, @Optional boolean isReturn) {
        return null;
    }

    public StringValue getName() {
        return this._prop.getName();
    }

    public boolean isPublic() {
        return false;
    }

    public boolean isPrivate() {
        return false;
    }

    public boolean isProtected() {
        return false;
    }

    public boolean isStatic() {
        return this._prop.isStatic();
    }

    public boolean isDefault() {
        return true;
    }

    public int getModifiers() {
        return -1;
    }

    public Value getValue(Env env, @Optional ObjectValue obj) {
        return this._prop.getValue(env, obj);
    }

    public void setValue(Env env, ObjectValue obj, Value value) {
        this._prop.setValue(env, obj, value);
    }

    public ReflectionClass getDeclaringClass(Env env) {
        return this._prop.getDeclaringClass(env);
    }

    public String getDocComment() {
        return null;
    }

    public String toString() {
        return "ReflectionProperty[" + this._prop.toString() + "]";
    }

    static class StaticProperty
    extends Property {
        String _name;

        public StaticProperty(QuercusClass cls, StringValue nameV) {
            super(cls, nameV);
            this._name = nameV.toString();
        }

        public boolean isStatic() {
            return true;
        }

        public Value getValue(Env env, ObjectValue obj) {
            return this._cls.getStaticField(env, this._name).toValue();
        }

        public void setValue(Env env, ObjectValue obj, Value value) {
            this._cls.getStaticField(env, this._name).set(value);
        }

        public ReflectionClass getDeclaringClass(Env env) {
            return this.getDeclaringClass(env, this._cls);
        }

        protected ReflectionClass getDeclaringClass(Env env, QuercusClass cls) {
            if (cls == null) {
                return null;
            }
            ReflectionClass refClass = this.getDeclaringClass(env, cls.getParent());
            if (refClass != null) {
                return refClass;
            }
            if (cls.getStaticField(env, this._name) != null) {
                return new ReflectionClass(cls);
            }
            return null;
        }

        public String toString() {
            if (this._cls.getName() != null) {
                return this._cls.getName() + "::" + this._name;
            }
            return this._name;
        }
    }

    static class Property {
        final QuercusClass _cls;
        final StringValue _nameV;

        public static Property create(Env env, QuercusClass cls, StringValue nameV) {
            if (cls.findFieldIndex(nameV) >= 0) {
                return new Property(cls, nameV);
            }
            if (cls.getStaticField(env, nameV.toString()) != null) {
                return new StaticProperty(cls, nameV);
            }
            throw new ReflectionException(L.l("Property {0}->${1} does not exist", (Object)cls.getName(), (Object)nameV));
        }

        protected Property(QuercusClass cls, StringValue nameV) {
            this._cls = cls;
            this._nameV = nameV;
        }

        public boolean isStatic() {
            return false;
        }

        public final StringValue getName() {
            return this._nameV;
        }

        public Value getValue(Env env, ObjectValue obj) {
            return obj.getField(env, this._nameV);
        }

        public void setValue(Env env, ObjectValue obj, Value value) {
            obj.putField(env, this._nameV, value);
        }

        public ReflectionClass getDeclaringClass(Env env) {
            return this.getDeclaringClass(env, this._cls);
        }

        protected ReflectionClass getDeclaringClass(Env env, QuercusClass cls) {
            if (cls == null) {
                return null;
            }
            ReflectionClass refClass = this.getDeclaringClass(env, cls.getParent());
            if (refClass != null) {
                return refClass;
            }
            if (cls.findFieldIndex(this._nameV) >= 0) {
                return new ReflectionClass(cls);
            }
            return null;
        }

        public String toString() {
            if (this._cls.getName() != null) {
                return this._cls.getName() + "->" + this._nameV;
            }
            return this._nameV.toString();
        }
    }
}

