/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.session;

import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.Callback;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.SessionArrayValue;
import com.caucho.quercus.env.SessionCallback;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.Var;
import com.caucho.quercus.lib.OutputModule;
import com.caucho.quercus.module.AbstractQuercusModule;
import com.caucho.quercus.module.IniDefinition;
import com.caucho.quercus.module.IniDefinitions;
import com.caucho.quercus.module.ModuleStartupListener;
import com.caucho.util.L10N;
import java.util.logging.Logger;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;

public class SessionModule
extends AbstractQuercusModule
implements ModuleStartupListener {
    private static final L10N L = new L10N(SessionModule.class);
    private static final Logger log = Logger.getLogger(SessionModule.class.getName());
    private static final IniDefinitions _iniDefinitions = new IniDefinitions();
    static final IniDefinition INI_SESSION_SAVE_PATH = _iniDefinitions.add("session.save_path", "", 7);
    static final IniDefinition INI_SESSION_NAME = _iniDefinitions.add("session.name", "PHPSESSID", 7);
    static final IniDefinition INI_SESSION_SAVE_HANDLER = _iniDefinitions.add("session.save_handler", "files", 7);
    static final IniDefinition INI_SESSION_AUTO_START = _iniDefinitions.add("session.auto_start", false, 7);
    static final IniDefinition INI_SESSION_GC_PROBABILITY_START = _iniDefinitions.add("session.gc_probability_start", true, 7);
    static final IniDefinition INI_SESSION_GC_DIVISOR = _iniDefinitions.add("session.gc_divisor", 100L, 7);
    static final IniDefinition INI_SESSION_GC_MAXLIFETIME = _iniDefinitions.add("session.gc_maxlifetime", 1440L, 7);
    static final IniDefinition INI_SESSION_SERIALIZE_HANDLER = _iniDefinitions.add("session.serialize_handler", "quercus", 7);
    static final IniDefinition INI_SESSION_COOKIE_LIFETIME = _iniDefinitions.add("session.cookie_lifetime", 0L, 7);
    static final IniDefinition INI_SESSION_COOKIE_PATH = _iniDefinitions.add("session.cookie_path", "/", 7);
    static final IniDefinition INI_SESSION_COOKIE_DOMAIN = _iniDefinitions.add("session.cookie_domain", "", 7);
    static final IniDefinition INI_SESSION_COOKIE_SECURE = _iniDefinitions.add("session.cookie_secure", "", 7);
    static final IniDefinition INI_SESSION_USE_COOKIES = _iniDefinitions.add("session.use_cookies", true, 7);
    static final IniDefinition INI_SESSION_USE_ONLY_COOKIES = _iniDefinitions.add("session.use_only_cookies", true, 7);
    static final IniDefinition INI_SESSION_REFERER_CHECK = _iniDefinitions.add("session.referer_check", "", 7);
    static final IniDefinition INI_SESSION_ENTROPY_FILE = _iniDefinitions.add("session.entropy_file", "", 7);
    static final IniDefinition INI_SESSION_ENTROPY_LENGTH = _iniDefinitions.add("session.entropy_length", false, 7);
    static final IniDefinition INI_SESSION_CACHE_LIMITER = _iniDefinitions.add("session.cache_limiter", "nocache", 7);
    static final IniDefinition INI_SESSION_CACHE_EXPIRE = _iniDefinitions.add("session.cache_expire", 180L, 7);
    static final IniDefinition INI_SESSION_USE_TRANS_SID = _iniDefinitions.add("session.use_trans_sid", false, 7);
    static final IniDefinition INI_SESSION_BUG_COMPAT_42 = _iniDefinitions.add("session.bug_compat_42", true, 7);
    static final IniDefinition INI_SESSION_BUG_COMPAT_WARN = _iniDefinitions.add("session.bug_compat_warn", true, 7);
    static final IniDefinition INI_SESSION_HASH_FUNCTION = _iniDefinitions.add("session.hash_function", false, 7);
    static final IniDefinition INI_SESSION_HASH_BITS_PER_CHARACTER = _iniDefinitions.add("session.hash_bits_per_character", 4L, 7);
    static final IniDefinition INI_URL_REWRITER_TAGS = _iniDefinitions.add("url_rewriter.tags", "a=href,area=href,frame=src,form=,fieldset=", 7);

    public IniDefinitions getIniDefinitions() {
        return _iniDefinitions;
    }

    public String[] getLoadedExtensions() {
        return new String[]{"session"};
    }

    public void startup(Env env) {
        if (env.getConfigVar("session.auto_start").toBoolean()) {
            SessionModule.session_start(env);
        }
    }

    public Value session_cache_limiter(Env env, @Optional String newValue) {
        StringValue value = env.getIni("session.cache_limiter");
        if (newValue == null || "".equals(newValue)) {
            return value;
        }
        env.setIni("session.cache_limiter", newValue);
        return value;
    }

    public Value session_cache_expire(Env env, @Optional Value newValue) {
        Value value = (LongValue)env.getSpecialValue("cache_expire");
        if (value == null) {
            value = env.getIni("session.cache_expire");
        }
        if (newValue != null && !newValue.isDefault()) {
            env.setSpecialValue("cache_expire", newValue);
        }
        return LongValue.create(((Value)value).toLong());
    }

    public static Value session_commit(Env env) {
        return SessionModule.session_write_close(env);
    }

    public static boolean session_decode(Env env, StringValue value) {
        Value session = env.getGlobalValue("_SESSION");
        if (!(session instanceof SessionArrayValue)) {
            env.warning(L.l("session_decode requires valid session"));
            return false;
        }
        return ((SessionArrayValue)session).decode(env, value.toString());
    }

    public static String session_encode(Env env) {
        Value session = env.getGlobalValue("_SESSION");
        if (!(session instanceof SessionArrayValue)) {
            env.warning(L.l("session_encode requires valid session"));
            return null;
        }
        return ((SessionArrayValue)session).encode(env);
    }

    public static boolean session_destroy(Env env) {
        SessionArrayValue session = env.getSession();
        if (session == null) {
            return false;
        }
        env.destroySession(session.getId());
        return true;
    }

    public static ArrayValue session_get_cookie_params(Env env) {
        ArrayValueImpl array = new ArrayValueImpl();
        array.put(env, "lifetime", env.getIniLong("session.cookie_lifetime"));
        array.put(env, "path", env.getIniString("session.cookie_path"));
        array.put(env, "domain", env.getIniString("session.cookie_domain"));
        array.put(env, "secure", env.getIniBoolean("session.cookie_secure"));
        return array;
    }

    public static String session_id(Env env, @Optional String id) {
        Value sessionIdValue = (Value)env.getSpecialValue("caucho.session_id");
        String oldValue = sessionIdValue != null ? sessionIdValue.toString() : "";
        if (id != null && !"".equals(id)) {
            env.setSpecialValue("caucho.session_id", env.createString(id));
        }
        return oldValue;
    }

    public static boolean session_is_registered(Env env, String name) {
        return env.getGlobalValue("_SESSION").get(env.createString(name)).isset();
    }

    public Value session_module_name(Env env, @Optional String newValue) {
        StringValue value = env.getIni("session.save_handler");
        if (newValue != null && !newValue.equals("")) {
            env.setIni("session.save_handler", newValue);
        }
        return value;
    }

    public Value session_name(Env env, @Optional String newValue) {
        StringValue value = env.getIni("session.name");
        if (newValue != null && !newValue.equals("")) {
            env.setIni("session.name", newValue);
        }
        return value;
    }

    public static boolean session_regenerate_id(Env env, @Optional boolean deleteOld) {
        if (env.getSession() == null) {
            return !deleteOld;
        }
        String sessionId = env.generateSessionId();
        if (deleteOld) {
            SessionModule.session_destroy(env);
            SessionArrayValue session = env.createSession(sessionId, true);
        } else {
            SessionArrayValue session = env.getSession();
            session.setId(sessionId);
        }
        SessionModule.session_id(env, sessionId);
        if (env.getIni("session.use_cookies").toBoolean()) {
            SessionModule.generateSessionCookie(env, sessionId);
        }
        return true;
    }

    public boolean session_register(Env env, Value[] values) {
        Value session = env.getGlobalValue("_SESSION");
        if (!session.isArray()) {
            SessionModule.session_start(env);
            session = env.getGlobalValue("_SESSION");
        }
        for (int i = 0; i < values.length; ++i) {
            this.sessionRegisterImpl(env, (ArrayValue)session, values[i]);
        }
        return true;
    }

    private void sessionRegisterImpl(Env env, ArrayValue session, Value nameV) {
        if ((nameV = nameV.toValue()) instanceof StringValue) {
            String name = nameV.toString();
            Var var = env.getGlobalVar(name);
            Value value = session.get(nameV);
            if (value.isset()) {
                ((Value)var).set(value);
            }
            session.put(nameV, var);
        } else if (nameV.isArray()) {
            ArrayValue array = (ArrayValue)nameV.toValue();
            for (Value subValue : array.values()) {
                this.sessionRegisterImpl(env, session, subValue);
            }
        }
    }

    public Value session_save_path(Env env, @Optional String newValue) {
        StringValue value = env.getIni("session.save_path");
        if (newValue != null && !newValue.equals("")) {
            env.setIni("session.save_path", newValue);
        }
        if (value.isNull() || ((Value)value).length() == 0) {
            value = env.createString(env.getWorkDir().getPath());
        }
        return value;
    }

    public Value session_set_cookie_params(Env env, long lifetime, @Optional Value path, @Optional Value domain, @Optional Value secure) {
        env.setIni("session.cookie_lifetime", String.valueOf(lifetime));
        if (path.isset()) {
            env.setIni("session.cookie_path", path.toString());
        }
        if (domain.isset()) {
            env.setIni("session.cookie_domain", domain.toString());
        }
        if (secure.isset()) {
            env.setIni("session.cookie_secure", secure.toBoolean() ? "1" : "0");
        }
        return NullValue.NULL;
    }

    public boolean session_set_save_handler(Env env, Callback open, Callback close, Callback read, Callback write, Callback directory, Callback gc) {
        SessionCallback cb = new SessionCallback(open, close, read, write, directory, gc);
        env.setSessionCallback(cb);
        return true;
    }

    public static boolean session_start(Env env) {
        if (env.getSession() != null) {
            env.notice(L.l("session has already been started"));
            return true;
        }
        SessionCallback callback = env.getSessionCallback();
        Value sessionIdValue = (Value)env.getSpecialValue("caucho.session_id");
        String sessionId = null;
        HttpServletResponse response = env.getResponse();
        env.removeConstant("SID");
        String cookieName = env.getIni("session.name").toString();
        boolean generateCookie = true;
        boolean create = false;
        if (callback != null) {
            String savePath = env.getIni("session.save_path").toString();
            if (savePath == null || "".equals(savePath)) {
                callback.open(env, env.getWorkDir().getPath(), cookieName);
            } else {
                callback.open(env, savePath, cookieName);
            }
        }
        if (env.getIni("session.use_cookies").toBoolean()) {
            if (sessionIdValue != null) {
                sessionId = sessionIdValue.toString();
            }
            if (sessionId == null || "".equals(sessionId)) {
                Cookie[] cookies = env.getRequest().getCookies();
                for (int i = 0; cookies != null && i < cookies.length; ++i) {
                    if (!cookies[i].getName().equals(cookieName) || "".equals(cookies[i].getValue())) continue;
                    sessionId = cookies[i].getValue();
                    generateCookie = false;
                }
            }
            if (!generateCookie) {
                env.addConstant("SID", env.getEmptyString(), false);
            }
        }
        if (env.getIniBoolean("session.use_trans_sid") && !env.getIniBoolean("session.use_only_cookies")) {
            if (sessionId == null) {
                if (sessionIdValue != null) {
                    sessionId = sessionIdValue.toString();
                }
                if (sessionId == null || "".equals(sessionId)) {
                    sessionId = env.getRequest().getParameter(cookieName);
                }
                if (sessionId == null || "".equals(sessionId)) {
                    sessionId = env.generateSessionId();
                    create = true;
                }
            }
            env.addConstant("SID", env.createString(cookieName + '=' + sessionId), false);
            OutputModule.pushUrlRewriter(env);
        }
        if (sessionId == null || "".equals(sessionId)) {
            sessionId = env.generateSessionId();
            create = true;
        }
        if (response.isCommitted()) {
            env.warning(L.l("cannot send session cache limiter headers because response is committed"));
        } else {
            StringValue cacheLimiterValue = env.getIni("session.cache_limiter");
            String cacheLimiter = String.valueOf(cacheLimiterValue);
            Value cacheExpireValue = (LongValue)env.getSpecialValue("cache_expire");
            if (cacheExpireValue == null) {
                cacheExpireValue = env.getIni("session.cache_expire");
            }
            int cacheExpire = cacheExpireValue.toInt() * 60;
            if ("nocache".equals(cacheLimiter)) {
                response.setHeader("Expires", "Thu, 19 Nov 1981 08:52:00 GMT");
                response.setHeader("Cache-Control", "no-store, no-cache, must-revalidate, post-check=0, pre-check=0");
                response.setHeader("Pragma", "no-cache");
            } else if ("private".equals(cacheLimiter)) {
                response.setHeader("Cache-Control", "private, max-age=" + cacheExpire + ", pre-check=" + cacheExpire);
            } else if ("private_no_expire".equals(cacheLimiter)) {
                response.setHeader("Cache-Control", "private, max-age=" + cacheExpire + ", pre-check=" + cacheExpire);
            } else if ("public".equals(cacheLimiter)) {
                response.setHeader("Cache-Control", "max-age=" + cacheExpire + ", pre-check=" + cacheExpire);
            } else if (!"none".equals(cacheLimiter)) {
                response.setHeader("Cache-Control", cacheLimiter + ", max-age=" + cacheExpire + ", pre-check=" + cacheExpire);
            }
        }
        SessionArrayValue session = env.createSession(sessionId, create);
        sessionId = session.getId();
        if (env.getIni("session.use_cookies").toBoolean() && generateCookie) {
            SessionModule.generateSessionCookie(env, sessionId);
        }
        env.setSpecialValue("caucho.session_id", env.createString(sessionId));
        return true;
    }

    private static void generateSessionCookie(Env env, String sessionId) {
        HttpServletResponse response = env.getResponse();
        String cookieName = env.getIni("session.name").toString();
        env.addConstant("SID", env.createString(cookieName + '=' + sessionId), false);
        Cookie cookie = new Cookie(cookieName, sessionId);
        String cookieVersion = env.getIniString("session.cookie_version");
        if (!"0".equals(cookieVersion)) {
            cookie.setVersion(1);
        }
        if (response.isCommitted()) {
            env.warning(L.l("cannot send session cookie because response is committed"));
        } else {
            StringValue domain;
            StringValue path = env.getIni("session.cookie_path");
            cookie.setPath(path.toString());
            StringValue maxAge = env.getIni("session.cookie_lifetime");
            if (maxAge.toInt() != 0) {
                cookie.setMaxAge(maxAge.toInt());
            }
            if (((Value)(domain = env.getIni("session.cookie_domain"))).length() > 0) {
                cookie.setDomain(domain.toString());
            }
            StringValue secure = env.getIni("session.cookie_secure");
            cookie.setSecure(((Value)secure).toBoolean());
            response.addCookie(cookie);
        }
    }

    public boolean session_unregister(Env env, Value key) {
        Value value = env.getGlobalValue("_SESSION");
        if (!value.isArray()) {
            return false;
        }
        value.remove(key);
        return true;
    }

    public Value session_unset(Env env) {
        Value value = env.getGlobalValue("_SESSION");
        if (!value.isArray()) {
            return NullValue.NULL;
        }
        ArrayValue array = value.toArrayValue(env);
        array.clear();
        return NullValue.NULL;
    }

    public static Value session_write_close(Env env) {
        env.sessionWriteClose();
        return NullValue.NULL;
    }

    private static char encode(long code) {
        if ((code &= 0x3FL) < 26L) {
            return (char)(97L + code);
        }
        if (code < 52L) {
            return (char)(65L + code - 26L);
        }
        if (code < 62L) {
            return (char)(48L + code - 52L);
        }
        if (code == 62L) {
            return '_';
        }
        return '-';
    }
}

