/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.pbx.internal.core;

import java.util.LinkedList;
import org.asteriskjava.pbx.Channel;
import org.asteriskjava.pbx.EndPoint;
import org.asteriskjava.pbx.asterisk.wrap.events.MasqueradeEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.NewChannelEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.NewStateEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.StatusEvent;
import org.asteriskjava.pbx.internal.core.CallEndedListener;
import org.asteriskjava.pbx.internal.core.CallTracker;
import org.asteriskjava.pbx.internal.core.ChannelProxy;
import org.asteriskjava.pbx.internal.core.PeerState;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

public class Peer
implements CallEndedListener {
    private static final Log logger = LogFactory.getLog(Peer.class);
    private final EndPoint peerEndPoint;
    private final LinkedList<CallTracker> callList = new LinkedList();
    private PeerState _state = PeerState.NOTSET;
    private boolean dnd = false;

    public Peer(EndPoint endPoint) {
        this.peerEndPoint = endPoint;
    }

    public boolean isSame(Peer rhs) {
        return this.peerEndPoint.isSame(rhs.getEndPoint());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CallTracker registerChannel(Channel newChannel) {
        CallTracker associatedCall = null;
        boolean found = false;
        LinkedList<CallTracker> linkedList = this.callList;
        synchronized (linkedList) {
            for (CallTracker call : this.callList) {
                if (call.findChannel(newChannel) == -1) continue;
                found = true;
                associatedCall = call;
                break;
            }
            if (!found) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Peer adding Call: " + this.toString() + " " + newChannel.getExtendedChannelName());
                }
                associatedCall = this.createCallTracker(newChannel);
                this.dumpCallList();
            }
        }
        return associatedCall;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CallTracker createCallTracker(Channel newChannel) {
        CallTracker newCall;
        LinkedList<CallTracker> linkedList = this.callList;
        synchronized (linkedList) {
            newCall = new CallTracker(this, newChannel);
            this.callList.add(newCall);
        }
        return newCall;
    }

    public boolean getDND() {
        return this.dnd;
    }

    public PeerState getState() {
        return this._state;
    }

    private boolean isConnectedToSelf(Channel channel) {
        return this.getEndPoint().isSame(channel.getEndPoint());
    }

    public void handleEvent(MasqueradeEvent b) {
        if (this.isConnectedToSelf(b.getClone())) {
            CallTracker original = this.findCall(b.getOriginal());
            CallTracker clone = this.findCall(b.getClone());
            if (original != null && clone != null) {
                clone.mergeCalls(original);
                clone.setState(b.getCloneState());
                this.evaluateState();
            } else {
                logger.warn("When processing masquradeEvent we could not find the expected calls. event=" + b.toString() + " original=" + original + " clone=" + clone);
            }
        }
    }

    public void handleEvent(NewChannelEvent b) {
        CallTracker call;
        if (b.getChannel() == null || b.getChannel().isConsole()) {
            return;
        }
        if (this.isConnectedToSelf(b.getChannel()) && (call = this.registerChannel(b.getChannel())) != null) {
            call.setState(b.getChannelState());
            this.evaluateState();
        }
    }

    public void handleEvent(NewStateEvent b) {
        CallTracker call;
        if (this.isConnectedToSelf(b.getChannel()) && (call = this.registerChannel(b.getChannel())) != null) {
            call.setState(b.getChannelState());
            this.evaluateState();
        }
    }

    public void handleEvent(StatusEvent b) {
        Channel channel = b.getChannel();
        if (this.isConnectedToSelf(channel)) {
            ((ChannelProxy)channel).getRealChannel().markChannel();
            CallTracker call = this.findCall(channel);
            if (call != null) {
                call.setState(b.getState());
                this.evaluateState();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CallTracker findCall(Channel channel) {
        CallTracker result = null;
        LinkedList<CallTracker> linkedList = this.callList;
        synchronized (linkedList) {
            for (CallTracker call : this.callList) {
                if (call.findChannel(channel) == -1) continue;
                result = call;
                break;
            }
        }
        return result;
    }

    public void setDND(boolean on) {
        this.dnd = on;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startSweep() {
        logger.debug("Starting sweep for " + this.peerEndPoint.getFullyQualifiedName());
        LinkedList<CallTracker> linkedList = this.callList;
        synchronized (linkedList) {
            for (CallTracker call : this.callList) {
                call.startSweep();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endSweep() {
        logger.debug("Ending sweep for " + this.peerEndPoint.getFullyQualifiedName());
        LinkedList<CallTracker> linkedList = this.callList;
        synchronized (linkedList) {
            for (CallTracker call : this.callList) {
                call.endSweep();
            }
        }
        this.evaluateState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evaluateState() {
        LinkedList<CallTracker> linkedList = this.callList;
        synchronized (linkedList) {
            PeerState newState = PeerState.NOTSET;
            for (CallTracker call : this.callList) {
                if (call.getState().getPriority() <= newState.getPriority()) continue;
                newState = call.getState();
            }
            this._state = newState;
        }
    }

    public EndPoint getEndPoint() {
        return this.peerEndPoint;
    }

    public String toString() {
        return this.getEndPoint().toString();
    }

    private void dumpCallList() {
        if (logger.isDebugEnabled()) {
            logger.debug("Peer: dump CallList:" + this);
            for (CallTracker call : this.callList) {
                call.dumpChannelList();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void callEnded(CallTracker call) {
        boolean found = false;
        LinkedList<CallTracker> linkedList = this.callList;
        synchronized (linkedList) {
            for (CallTracker aCall : this.callList) {
                if (call != aCall) continue;
                found = true;
                if (logger.isDebugEnabled()) {
                    logger.debug("peer Removing call " + call);
                }
                this.callList.remove(call);
                this.evaluateState();
                this.dumpCallList();
                break;
            }
            if (!found) {
                logger.error("Error call not found removing call from peer: call=" + call + " peer=" + this);
                this.dumpCallList();
            }
        }
    }
}

