/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.fastagi.command;

import org.asteriskjava.AsteriskVersion;
import org.asteriskjava.fastagi.command.AbstractAgiCommand;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

public class DialCommand
extends AbstractAgiCommand {
    private static final long serialVersionUID = 3762248656229053753L;
    private String options;
    private String target;
    private int timeout;
    private final Log logger = LogFactory.getLog(this.getClass());

    public DialCommand(String target, int timeout, String options) {
        this.target = target;
        this.timeout = timeout;
        this.options = options;
    }

    @Override
    public String buildCommand() {
        String separator = "|";
        if (this.getAsteriskVersion().isAtLeast(AsteriskVersion.ASTERISK_10)) {
            separator = ",";
        }
        String command = "EXEC " + this.escapeAndQuote("dial") + " " + this.escapeAndQuote(this.target) + separator + this.escapeAndQuote("" + this.timeout);
        if (this.options != null && this.options.length() > 0) {
            command = command + separator + this.escapeAndQuote(this.options);
        }
        this.logger.info(command);
        return command;
    }
}

