/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.manager.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.asteriskjava.manager.ResponseEvents;
import org.asteriskjava.manager.event.ResponseEvent;
import org.asteriskjava.manager.response.ManagerResponse;

public class ResponseEventsImpl
implements ResponseEvents {
    private ManagerResponse response;
    private final Collection<ResponseEvent> events;
    private boolean complete = false;
    private final CountDownLatch latch = new CountDownLatch(1);

    public ResponseEventsImpl() {
        this.events = new ArrayList<ResponseEvent>();
    }

    @Override
    public ManagerResponse getResponse() {
        return this.response;
    }

    @Override
    public Collection<ResponseEvent> getEvents() {
        return this.events;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void setRepsonse(ManagerResponse response) {
        this.response = response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvent(ResponseEvent event) {
        Collection<ResponseEvent> collection = this.events;
        synchronized (collection) {
            this.events.add(event);
        }
    }

    public void setComplete(boolean complete) {
        this.complete = complete;
    }

    public void await(long timeout) throws InterruptedException {
        this.latch.await(timeout, TimeUnit.MILLISECONDS);
    }

    public void countDown() {
        this.latch.countDown();
    }

    public String toString() {
        return "ResponseEventsImpl [response=" + this.response + ",\nevents=" + this.events + ",\ncomplete=" + this.complete + "]";
    }
}

