/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.alignment.template;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.biojava.nbio.alignment.template.AbstractMatrixAligner;
import org.biojava.nbio.alignment.template.GapPenalty;
import org.biojava.nbio.alignment.template.Profile;
import org.biojava.nbio.alignment.template.ProfilePair;
import org.biojava.nbio.alignment.template.ProfileProfileAligner;
import org.biojava.nbio.alignment.template.SubstitutionMatrix;
import org.biojava.nbio.core.sequence.template.Compound;
import org.biojava.nbio.core.sequence.template.CompoundSet;
import org.biojava.nbio.core.sequence.template.Sequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProfileProfileAligner<S extends Sequence<C>, C extends Compound>
extends AbstractMatrixAligner<S, C>
implements ProfileProfileAligner<S, C> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractProfileProfileAligner.class);
    private Profile<S, C> query;
    private Profile<S, C> target;
    private Future<ProfilePair<S, C>> queryFuture;
    private Future<ProfilePair<S, C>> targetFuture;
    private List<C> cslist;
    private float[][] qfrac;
    private float[][] tfrac;
    protected ProfilePair<S, C> pair;

    protected AbstractProfileProfileAligner() {
    }

    protected AbstractProfileProfileAligner(Profile<S, C> query, Profile<S, C> target, GapPenalty gapPenalty, SubstitutionMatrix<C> subMatrix) {
        super(gapPenalty, subMatrix);
        this.query = query;
        this.target = target;
        this.reset();
    }

    protected AbstractProfileProfileAligner(Future<ProfilePair<S, C>> query, Future<ProfilePair<S, C>> target, GapPenalty gapPenalty, SubstitutionMatrix<C> subMatrix) {
        super(gapPenalty, subMatrix);
        this.queryFuture = query;
        this.targetFuture = target;
        this.reset();
    }

    protected AbstractProfileProfileAligner(Profile<S, C> query, Future<ProfilePair<S, C>> target, GapPenalty gapPenalty, SubstitutionMatrix<C> subMatrix) {
        super(gapPenalty, subMatrix);
        this.query = query;
        this.targetFuture = target;
        this.reset();
    }

    protected AbstractProfileProfileAligner(Future<ProfilePair<S, C>> query, Profile<S, C> target, GapPenalty gapPenalty, SubstitutionMatrix<C> subMatrix) {
        super(gapPenalty, subMatrix);
        this.queryFuture = query;
        this.target = target;
        this.reset();
    }

    public void setQuery(Profile<S, C> query) {
        this.query = query;
        this.queryFuture = null;
        this.reset();
    }

    public void setTarget(Profile<S, C> target) {
        this.target = target;
        this.targetFuture = null;
        this.reset();
    }

    @Override
    public ProfilePair<S, C> getPair() {
        if (this.pair == null) {
            this.align();
        }
        return this.pair;
    }

    @Override
    public Profile<S, C> getQuery() {
        return this.query;
    }

    @Override
    public Profile<S, C> getTarget() {
        return this.target;
    }

    @Override
    protected CompoundSet<C> getCompoundSet() {
        return this.query == null ? null : this.query.getCompoundSet();
    }

    @Override
    protected List<C> getCompoundsOfQuery() {
        return this.query == null ? new ArrayList() : this.query.getAlignedSequence(true).getAsList();
    }

    @Override
    protected List<C> getCompoundsOfTarget() {
        return this.target == null ? new ArrayList() : this.target.getAlignedSequence(true).getAsList();
    }

    @Override
    protected int[] getScoreMatrixDimensions() {
        return new int[]{this.query.getLength() + 1, this.target.getLength() + 1, this.getGapPenalty().getType() == GapPenalty.Type.LINEAR ? 1 : 3};
    }

    @Override
    protected int getSubstitutionScore(int queryColumn, int targetColumn) {
        return this.getSubstitutionScore(this.qfrac[queryColumn - 1], this.tfrac[targetColumn - 1]);
    }

    @Override
    protected boolean isReady() {
        try {
            if (this.query == null && this.queryFuture != null) {
                this.query = this.queryFuture.get();
            }
            if (this.target == null && this.targetFuture != null) {
                this.target = this.targetFuture.get();
            }
            this.reset();
        }
        catch (InterruptedException e) {
            logger.error("Interrupted Exception: ", (Throwable)e);
        }
        catch (ExecutionException e) {
            logger.error("Execution Exception: ", (Throwable)e);
        }
        return this.query != null && this.target != null && this.getGapPenalty() != null && this.getSubstitutionMatrix() != null && this.query.getCompoundSet().equals(this.target.getCompoundSet());
    }

    @Override
    protected void reset() {
        super.reset();
        this.pair = null;
        if (this.query != null && this.target != null && this.getGapPenalty() != null && this.getSubstitutionMatrix() != null && this.query.getCompoundSet().equals(this.target.getCompoundSet())) {
            int i;
            int maxq = 0;
            int maxt = 0;
            this.cslist = this.query.getCompoundSet().getAllCompounds();
            this.qfrac = new float[this.query.getLength()][];
            for (i = 0; i < this.qfrac.length; ++i) {
                this.qfrac[i] = this.query.getCompoundWeightsAt(i + 1, this.cslist);
                maxq += this.getSubstitutionScore(this.qfrac[i], this.qfrac[i]);
            }
            this.tfrac = new float[this.target.getLength()][];
            for (i = 0; i < this.tfrac.length; ++i) {
                this.tfrac[i] = this.target.getCompoundWeightsAt(i + 1, this.cslist);
                maxt += this.getSubstitutionScore(this.tfrac[i], this.tfrac[i]);
            }
            this.max = Math.max(maxq, maxt);
            this.min = this.isLocal() ? 0 : 2 * this.getGapPenalty().getOpenPenalty() + (this.query.getLength() + this.target.getLength()) * this.getGapPenalty().getExtensionPenalty();
            this.score = this.min;
        }
    }

    private int getSubstitutionScore(float[] qv, float[] tv) {
        float score = 0.0f;
        for (int q = 0; q < qv.length; ++q) {
            if (!(qv[q] > 0.0f)) continue;
            for (int t = 0; t < tv.length; ++t) {
                if (!(tv[t] > 0.0f)) continue;
                score += qv[q] * tv[t] * (float)this.getSubstitutionMatrix().getValue((Compound)this.cslist.get(q), (Compound)this.cslist.get(t));
            }
        }
        return Math.round(score);
    }
}

