/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.alignment;

import org.biojava.nbio.alignment.template.AbstractScorer;
import org.biojava.nbio.alignment.template.PairwiseSequenceScorer;
import org.biojava.nbio.core.alignment.template.SequencePair;
import org.biojava.nbio.core.alignment.template.SubstitutionMatrix;
import org.biojava.nbio.core.sequence.template.Compound;
import org.biojava.nbio.core.sequence.template.Sequence;

public class SubstitutionMatrixScorer<S extends Sequence<C>, C extends Compound>
extends AbstractScorer
implements PairwiseSequenceScorer<S, C> {
    private final SubstitutionMatrix<C> matrix;
    private S query;
    private S target;
    private double score;

    public SubstitutionMatrixScorer(SequencePair<S, C> pair, SubstitutionMatrix<C> matrix) {
        this.query = pair.getQuery().getOriginalSequence();
        this.target = pair.getTarget().getOriginalSequence();
        this.matrix = matrix;
        for (int i = 1; i <= pair.getLength(); ++i) {
            Compound query = pair.getCompoundAt(1, i);
            Compound target = pair.getCompoundAt(2, i);
            this.score += (double)matrix.getValue(query, target);
        }
    }

    @Override
    public double getMaxScore() {
        double score = 0.0;
        for (Compound queryC : this.query.getAsList()) {
            short max = Short.MIN_VALUE;
            for (Short value : this.matrix.getRow(queryC).values()) {
                if (value <= max) continue;
                max = value;
            }
            score += (double)max;
        }
        return score;
    }

    @Override
    public double getMinScore() {
        double score = 0.0;
        for (Compound queryC : this.query.getAsList()) {
            short min = Short.MAX_VALUE;
            for (Short value : this.matrix.getRow(queryC).values()) {
                if (value >= min) continue;
                min = value;
            }
            score += (double)min;
        }
        return score;
    }

    @Override
    public double getScore() {
        return this.score;
    }

    @Override
    public S getQuery() {
        return this.query;
    }

    @Override
    public S getTarget() {
        return this.target;
    }
}

