/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.gui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.lang.reflect.Method;
import javax.swing.JPanel;
import org.biojava.nbio.structure.align.StrucAligParameters;
import org.biojava.nbio.structure.align.pairwise.AlternativeAlignment;
import org.biojava.nbio.structure.align.pairwise.FragmentPair;
import org.biojava.nbio.structure.gui.util.color.ContinuousColorMapper;
import org.biojava.nbio.structure.gui.util.color.DefaultMatrixMapper;
import org.biojava.nbio.structure.jama.Matrix;

public class JMatrixPanel
extends JPanel {
    private static final long serialVersionUID = -1720879395453257846L;
    BufferedImage _bufImage;
    Matrix matrix;
    ContinuousColorMapper cellColor = new DefaultMatrixMapper(10.0, 0.9f);
    float scale = 1.0f;
    FragmentPair[] fragmentPairs;
    AlternativeAlignment[] aligs;
    int selectedAlignmentPos = -1;
    static final BasicStroke stroke = new BasicStroke(2.0f);
    StrucAligParameters params;

    public JMatrixPanel() {
        this.matrix = new Matrix(0, 0);
        this.params = new StrucAligParameters();
    }

    public int getSelectedAlignmentPos() {
        return this.selectedAlignmentPos;
    }

    public void setSelectedAlignmentPos(int selectedAlignmentPos) {
        this.selectedAlignmentPos = selectedAlignmentPos;
    }

    public AlternativeAlignment[] getAlternativeAligs() {
        return this.aligs;
    }

    public void setAlternativeAligs(AlternativeAlignment[] aligs) {
        this.aligs = aligs;
    }

    public FragmentPair[] getFragmentPairs() {
        return this.fragmentPairs;
    }

    public void setFragmentPairs(FragmentPair[] fragmentPairs) {
        this.fragmentPairs = fragmentPairs;
    }

    public float getScale() {
        return this.scale;
    }

    public void setPreferredSize() {
        int prefW = Math.round((float)this.matrix.getRowDimension() * this.scale);
        int prefH = Math.round((float)this.matrix.getColumnDimension() * this.scale);
        this.setPreferredSize(new Dimension(prefW, prefH));
    }

    public void setScale(float scale) {
        if (scale == this.scale) {
            return;
        }
        this.scale = scale;
        this.setPreferredSize();
        this.repaint();
    }

    public Matrix getMatrix() {
        return this.matrix;
    }

    public void setMatrix(Matrix matrix) {
        this.matrix = matrix;
        this.setPreferredSize();
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        if (this._bufImage == null) {
            int w = this.getWidth();
            int h = this.getHeight();
            this._bufImage = (BufferedImage)this.createImage(w, h);
        }
        g2.drawImage(this._bufImage, null, 0, 0);
        this.drawDistances(g);
        this.drawPairs(g);
        if (this.scale >= 4.0f) {
            this.drawBoxes(g);
        }
    }

    public void drawPairs(Graphics g) {
        if (this.aligs == null) {
            return;
        }
        int nr = this.aligs.length;
        Graphics2D g2D = (Graphics2D)g;
        Stroke oldStroke = g2D.getStroke();
        g2D.setStroke(stroke);
        int width = Math.round(this.scale);
        int w2 = width / 2;
        for (int i = 0; i < this.aligs.length; ++i) {
            Color color;
            AlternativeAlignment a = this.aligs[i];
            int[] idx1 = a.getIdx1();
            int[] idx2 = a.getIdx2();
            int xold = -1;
            int yold = -1;
            boolean start = true;
            if (this.selectedAlignmentPos != -1 && this.selectedAlignmentPos == i) {
                color = Color.white;
            } else {
                float hue = (float)i * (1.0f / (float)nr);
                color = Color.getHSBColor(hue, 1.0f, 1.0f);
            }
            g.setColor(color);
            for (int j = 0; j < idx1.length; ++j) {
                int x1 = Math.round((float)idx1[j] * this.scale);
                int y1 = Math.round((float)idx2[j] * this.scale);
                if (!start) {
                    g.fillRect(xold, yold, 2, 2);
                } else {
                    g.fillRect(x1, y1, w2, w2);
                    start = false;
                }
                xold = x1;
                yold = y1;
            }
            if (start) continue;
            g.fillRect(xold, yold, w2, w2);
        }
        g2D.setStroke(oldStroke);
    }

    public void drawBoxes(Graphics g) {
        if (this.fragmentPairs == null) {
            return;
        }
        g.setColor(Color.yellow);
        for (int i = 0; i < this.fragmentPairs.length; ++i) {
            FragmentPair fp = this.fragmentPairs[i];
            int xp = fp.getPos1();
            int yp = fp.getPos2();
            int width = Math.round(this.scale);
            g.drawRect(Math.round((float)xp * this.scale), Math.round((float)yp * this.scale), width, width);
        }
    }

    public void drawDistances(Graphics g1) {
        Graphics2D g = (Graphics2D)g1;
        int c = this.matrix.getRowDimension();
        int d = this.matrix.getColumnDimension();
        float scale = this.getScale();
        int width = Math.round(scale);
        for (int i = 0; i < c; ++i) {
            int ipaint = Math.round((float)i * scale);
            for (int j = 0; j < d; ++j) {
                double val = this.matrix.get(i, j);
                int jpaint = Math.round((float)j * scale);
                Color color = this.cellColor.getColor(val);
                g.setColor(color);
                g.fillRect(ipaint, jpaint, width, width);
            }
        }
    }

    @Deprecated
    public float getSaturation() {
        try {
            Method getSaturation = this.cellColor.getClass().getMethod("getSaturation", new Class[0]);
            Float saturation = (Float)getSaturation.invoke((Object)this.cellColor, new Object[0]);
            return saturation.floatValue();
        }
        catch (Exception e) {
            throw new IllegalStateException("Error calling getSaturation() for " + this.cellColor.getClass());
        }
    }

    @Deprecated
    public void setSaturation(float saturation) {
        try {
            Method setSaturation = this.cellColor.getClass().getMethod("setSaturation", Float.TYPE);
            setSaturation.invoke((Object)this.cellColor, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error calling setSaturation(float) for " + this.cellColor.getClass());
        }
    }

    @Deprecated
    public float getScalevalue() {
        try {
            Method getScalevalue = this.cellColor.getClass().getMethod("getScalevalue", new Class[0]);
            Float scalevalue = (Float)getScalevalue.invoke((Object)this.cellColor, new Object[0]);
            return scalevalue.floatValue();
        }
        catch (Exception e) {
            throw new IllegalStateException("Error calling getScalevalue() for " + this.cellColor.getClass());
        }
    }

    @Deprecated
    public void setScalevalue(float scalevalue) {
        try {
            Method setScalevalue = this.cellColor.getClass().getMethod("setScalevalue", Float.TYPE);
            setScalevalue.invoke((Object)this.cellColor, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error calling setScalevalue(float) for " + this.cellColor.getClass());
        }
    }

    public ContinuousColorMapper getCellColor() {
        return this.cellColor;
    }

    public void setCellColor(ContinuousColorMapper cellColor) {
        this.cellColor = cellColor;
    }
}

