/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.symmetry.jmolScript;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Color4f;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Quat4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.biojava.nbio.structure.symmetry.core.HelixAxisAligner;
import org.biojava.nbio.structure.symmetry.core.Subunits;
import org.biojava.nbio.structure.symmetry.jmolScript.ColorConverter;
import org.biojava.nbio.structure.symmetry.jmolScript.JmolSymmetryScriptGenerator;
import org.jcolorbrewer.ColorBrewer;

public class JmolSymmetryScriptGeneratorH
extends JmolSymmetryScriptGenerator {
    private static double AXIS_SCALE_FACTOR = 1.2;
    private static double SIDE_CHAIN_EXTENSION = 6.0;
    private HelixAxisAligner helixAxisAligner = null;
    private String name = "";
    private String defaultColoring = "";
    private boolean onTheFly = false;

    public JmolSymmetryScriptGeneratorH(HelixAxisAligner helixAxisAligner, String name) {
        this.helixAxisAligner = helixAxisAligner;
        this.name = name;
    }

    @Override
    public void setOnTheFly(boolean onTheFly) {
        this.onTheFly = onTheFly;
    }

    @Override
    public int getZoom() {
        int zoom = (int)Math.round(100.0 / AXIS_SCALE_FACTOR);
        return zoom;
    }

    @Override
    public String getDefaultOrientation() {
        StringBuilder s = new StringBuilder();
        s.append(this.setCentroid());
        Quat4d q = new Quat4d();
        q.set(this.helixAxisAligner.getRotationMatrix());
        s.append("moveto 0 quaternion{");
        s.append(JmolSymmetryScriptGeneratorH.jMolFloat(q.x));
        s.append(",");
        s.append(JmolSymmetryScriptGeneratorH.jMolFloat(q.y));
        s.append(",");
        s.append(JmolSymmetryScriptGeneratorH.jMolFloat(q.z));
        s.append(",");
        s.append(JmolSymmetryScriptGeneratorH.jMolFloat(q.w));
        s.append("};");
        return s.toString();
    }

    @Override
    public int getOrientationCount() {
        return 4;
    }

    @Override
    public String getOrientation(int index) {
        StringBuilder s = new StringBuilder();
        s.append(this.setCentroid());
        Matrix4d matrix = new Matrix4d();
        matrix.setIdentity();
        matrix.setRotation(new AxisAngle4d(1.0, 0.0, 0.0, 1.5707963267948966 * (double)(index + 1)));
        Quat4d r = new Quat4d();
        r.set(new AxisAngle4d(1.0, 0.0, 0.0, (double)index * Math.PI / 2.0));
        Quat4d q = new Quat4d();
        q.set(this.helixAxisAligner.getRotationMatrix());
        r.mul(q);
        s.append("moveto 4 quaternion{");
        s.append(JmolSymmetryScriptGeneratorH.jMolFloat(r.x));
        s.append(",");
        s.append(JmolSymmetryScriptGeneratorH.jMolFloat(r.y));
        s.append(",");
        s.append(JmolSymmetryScriptGeneratorH.jMolFloat(r.z));
        s.append(",");
        s.append(JmolSymmetryScriptGeneratorH.jMolFloat(r.w));
        s.append("}");
        s.append(";");
        return s.toString();
    }

    @Override
    public String getOrientationWithZoom(int index) {
        StringBuilder s = new StringBuilder();
        s.append(this.getOrientation(index));
        s.insert(s.length() - 1, this.getZoom());
        return s.toString();
    }

    @Override
    public String getOrientationName(int index) {
        switch (index) {
            case 0: {
                return "Side";
            }
            case 1: {
                return "Front";
            }
            case 2: {
                return "Other side";
            }
            case 3: {
                return "Back";
            }
        }
        return "";
    }

    @Override
    public Matrix4d getTransformation() {
        return this.helixAxisAligner.getTransformation();
    }

    @Override
    public void setDefaultColoring(String colorScript) {
        this.defaultColoring = colorScript;
    }

    @Override
    public String drawPolyhedron() {
        StringBuilder s = new StringBuilder();
        List<Point3d> vertices = this.helixAxisAligner.getSubunits().getOriginalCenters();
        vertices = this.extendUnitCenters(vertices);
        int index = 0;
        Color4f c = new Color4f(Color.MAGENTA);
        double width = this.getMaxExtension() * 0.007;
        List layerLines = this.helixAxisAligner.getHelixLayers().getByLargestContacts().getLayerLines();
        for (List line : layerLines) {
            s.append("draw polyhedron");
            s.append(this.name);
            s.append(index++);
            s.append(" line");
            Iterator iterator = line.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                s.append(JmolSymmetryScriptGeneratorH.getJmolPoint((Tuple3d)vertices.get(i)));
            }
            s.append("width ");
            s.append(JmolSymmetryScriptGeneratorH.fDot2(width));
            s.append(" color");
            s.append(JmolSymmetryScriptGeneratorH.getJmolColor(c));
            s.append(" off;");
        }
        List<Point3d> interiorVertices = this.interiorCenters(vertices);
        for (int i = 0; i < vertices.size(); ++i) {
            s.append("draw polyhedron");
            s.append(this.name);
            s.append(index++);
            s.append(" line");
            s.append(JmolSymmetryScriptGeneratorH.getJmolPoint((Tuple3d)vertices.get(i)));
            s.append(JmolSymmetryScriptGeneratorH.getJmolPoint((Tuple3d)interiorVertices.get(i)));
            s.append("width ");
            s.append(JmolSymmetryScriptGeneratorH.fDot2(width));
            s.append(" color");
            s.append(JmolSymmetryScriptGeneratorH.getJmolColor(c));
            s.append(" off;");
        }
        return s.toString();
    }

    @Override
    public String hidePolyhedron() {
        return "draw polyhedron* off;";
    }

    @Override
    public String showPolyhedron() {
        return "draw polyhedron* on;";
    }

    @Override
    public String drawAxes() {
        StringBuilder s = new StringBuilder();
        Point3d centroid = this.helixAxisAligner.calcCenterOfRotation();
        AxisAngle4d axisAngle = this.helixAxisAligner.getHelixLayers().getByLowestAngle().getAxisAngle();
        Vector3d axis = new Vector3d(axisAngle.x, axisAngle.y, axisAngle.z);
        s.append("draw axesHelical");
        s.append(this.name);
        s.append(0);
        s.append(" ");
        s.append("line");
        Point3d v1 = new Point3d((Tuple3d)axis);
        v1.scale(AXIS_SCALE_FACTOR * (this.helixAxisAligner.getDimension().y + SIDE_CHAIN_EXTENSION));
        Point3d v2 = new Point3d(v1);
        v2.negate();
        v1.add((Tuple3d)centroid);
        v2.add((Tuple3d)centroid);
        s.append(JmolSymmetryScriptGeneratorH.getJmolPoint((Tuple3d)v1));
        s.append(JmolSymmetryScriptGeneratorH.getJmolPoint((Tuple3d)v2));
        s.append("width 1.0 ");
        s.append(" color red");
        s.append(" off;");
        return s.toString();
    }

    @Override
    public String hideAxes() {
        return "draw axes* off;";
    }

    @Override
    public String showAxes() {
        return "draw axes* on;";
    }

    @Override
    public String playOrientations() {
        StringBuilder s = new StringBuilder();
        s.append(this.drawFooter("Symmetry Helical", "white"));
        s.append(this.drawPolyhedron());
        s.append(this.showPolyhedron());
        s.append(this.drawAxes());
        s.append(this.showAxes());
        for (int i = 0; i < this.getOrientationCount(); ++i) {
            s.append(this.deleteHeader());
            s.append(this.getOrientationWithZoom(i));
            s.append(this.drawHeader(this.getOrientationName(i), "white"));
            s.append("delay 4;");
        }
        s.append(this.deleteHeader());
        s.append(this.getOrientationWithZoom(0));
        s.append(this.drawHeader(this.getOrientationName(0), "white"));
        return s.toString();
    }

    @Override
    public String colorBySubunit() {
        Subunits subunits = this.helixAxisAligner.getSubunits();
        List modelNumbers = subunits.getModelNumbers();
        List chainIds = subunits.getChainIds();
        List orbits = this.helixAxisAligner.getOrbits();
        Color[] col = ColorBrewer.Spectral.getColorPalette(orbits.size());
        Color4f[] colors = ColorConverter.convertColor4f(col);
        int half = colors.length / 2;
        for (int i = 0; i < half; ++i) {
            if (i % 2 == 0) continue;
            Color4f temp = colors[i];
            colors[i] = colors[half + i];
            colors[half + i] = temp;
        }
        HashMap<Color4f, List<String>> colorMap = new HashMap<Color4f, List<String>>();
        for (int i = 0; i < orbits.size(); ++i) {
            for (Integer j : (List)orbits.get(i)) {
                Color4f c = colors[i];
                ArrayList<String> ids = (ArrayList<String>)colorMap.get(c);
                if (ids == null) {
                    ids = new ArrayList<String>();
                    colorMap.put(c, ids);
                }
                String id = this.getChainSpecification(modelNumbers, chainIds, j);
                ids.add(id);
            }
        }
        String coloring = this.defaultColoring + JmolSymmetryScriptGeneratorH.getJmolColorScript(colorMap);
        return coloring;
    }

    @Override
    public String colorBySequenceCluster() {
        Subunits subunits = this.helixAxisAligner.getSubunits();
        int n = subunits.getSubunitCount();
        List modelNumbers = subunits.getModelNumbers();
        List chainIds = subunits.getChainIds();
        List seqClusterIds = subunits.getSequenceClusterIds();
        int clusters = (Integer)Collections.max(seqClusterIds) + 1;
        Color[] col = ColorBrewer.BrBG.getColorPalette(clusters);
        Color4f[] colors = ColorConverter.convertColor4f(col);
        HashMap<Color4f, List<String>> colorMap = new HashMap<Color4f, List<String>>();
        for (int i = 0; i < n; ++i) {
            Color4f c = colors[(Integer)seqClusterIds.get(i)];
            ArrayList<String> ids = (ArrayList<String>)colorMap.get(c);
            if (ids == null) {
                ids = new ArrayList<String>();
                colorMap.put(c, ids);
            }
            String id = this.getChainSpecification(modelNumbers, chainIds, i);
            ids.add(id);
        }
        String coloring = this.defaultColoring + JmolSymmetryScriptGeneratorH.getJmolColorScript(colorMap);
        return coloring;
    }

    @Override
    public String colorBySymmetry() {
        List<List<Integer>> units = this.helixAxisAligner.getHelixLayers().getByLargestContacts().getLayerLines();
        units = this.orientLayerLines(units);
        Subunits subunits = this.helixAxisAligner.getSubunits();
        List modelNumbers = subunits.getModelNumbers();
        List chainIds = subunits.getChainIds();
        List clusterIds = subunits.getSequenceClusterIds();
        int clusterCount = (Integer)Collections.max(clusterIds) + 1;
        HashMap<Color4f, List<String>> colorMap = new HashMap<Color4f, List<String>>();
        int maxLen = 0;
        for (List<Integer> unit : units) {
            maxLen = Math.max(maxLen, unit.size());
        }
        Color4f[] colors = this.getSymmetryColors(subunits.getSubunitCount());
        int count = 0;
        for (int i = 0; i < maxLen; ++i) {
            for (int j = 0; j < units.size(); ++j) {
                int m = units.get(j).size();
                if (i >= m) continue;
                int subunit = units.get(j).get(i);
                int cluster = (Integer)clusterIds.get(subunit);
                float scale = 0.3f + 0.7f * (float)(cluster + 1) / (float)clusterCount;
                Color4f c = new Color4f(colors[count]);
                ++count;
                c.scale(scale);
                ArrayList<String> ids = (ArrayList<String>)colorMap.get(c);
                if (ids == null) {
                    ids = new ArrayList<String>();
                    colorMap.put(c, ids);
                }
                String id = this.getChainSpecification(modelNumbers, chainIds, subunit);
                ids.add(id);
            }
        }
        String coloring = this.defaultColoring + JmolSymmetryScriptGeneratorH.getJmolColorScript(colorMap);
        return coloring;
    }

    private String getChainSpecification(List<Integer> modelNumbers, List<String> chainIds, int subunit) {
        if (this.onTheFly) {
            if (Collections.max(modelNumbers) > 1) {
                return chainIds.get(subunit) + "&symop=" + (modelNumbers.get(subunit) + 1);
            }
            return chainIds.get(subunit);
        }
        return chainIds.get(subunit) + "/" + (modelNumbers.get(subunit) + 1);
    }

    private List<List<Integer>> orientLayerLines(List<List<Integer>> layerLines) {
        Matrix4d transformation = this.helixAxisAligner.getTransformation();
        List centers = this.helixAxisAligner.getSubunits().getOriginalCenters();
        for (int i = 0; i < layerLines.size(); ++i) {
            List<Integer> layerLine = layerLines.get(i);
            int first = layerLine.get(0);
            Point3d firstSubunit = new Point3d((Point3d)centers.get(first));
            transformation.transform(firstSubunit);
            int last = layerLine.get(layerLine.size() - 1);
            Point3d lastSubunit = new Point3d((Point3d)centers.get(last));
            transformation.transform(lastSubunit);
            if (!(firstSubunit.y > lastSubunit.y)) continue;
            Collections.reverse(layerLine);
        }
        return layerLines;
    }

    protected double getMaxExtension() {
        Vector3d dimension = this.helixAxisAligner.getDimension();
        double maxExtension = Math.max(dimension.x, dimension.y);
        maxExtension = Math.max(maxExtension, dimension.z);
        return maxExtension;
    }

    private List<Point3d> extendUnitCenters(List<Point3d> points) {
        Matrix4d transformation = this.helixAxisAligner.getTransformation();
        Matrix4d reversetransformation = this.helixAxisAligner.getReverseTransformation();
        double radius = this.helixAxisAligner.getRadius();
        radius += SIDE_CHAIN_EXTENSION;
        ArrayList<Point3d> ePoints = new ArrayList<Point3d>(points.size());
        for (Point3d p : points) {
            Point3d q = new Point3d(p);
            transformation.transform(q);
            double d = Math.sqrt(q.x * q.x + q.z * q.z);
            double scale = radius / d;
            q.x *= scale;
            q.z *= scale;
            reversetransformation.transform(q);
            ePoints.add(q);
        }
        return ePoints;
    }

    private List<Point3d> interiorCenters(List<Point3d> points) {
        Matrix4d transformation = this.helixAxisAligner.getTransformation();
        Matrix4d reversetransformation = this.helixAxisAligner.getReverseTransformation();
        ArrayList<Point3d> ePoints = new ArrayList<Point3d>(points.size());
        for (Point3d p : points) {
            Point3d q = new Point3d(p);
            transformation.transform(q);
            q.x = 0.0;
            q.z = 0.0;
            reversetransformation.transform(q);
            ePoints.add(q);
        }
        return ePoints;
    }

    private String drawHeader(String text, String color) {
        StringBuilder s = new StringBuilder();
        s.append("set echo top center;");
        s.append("color echo ");
        s.append(color);
        s.append(";");
        s.append("font echo 24 sanserif;");
        s.append("echo ");
        s.append(text);
        s.append(";");
        return s.toString();
    }

    private String deleteHeader() {
        return "set echo top center;echo ;";
    }

    private String drawFooter(String text, String color) {
        StringBuilder s = new StringBuilder();
        s.append("set echo bottom center;");
        s.append("color echo ");
        s.append(color);
        s.append(";");
        s.append("font echo 24 sanserif;");
        s.append("echo " + text);
        s.append(";");
        return s.toString();
    }

    private Color4f[] getSymmetryColors(int nColors) {
        int offset = 0;
        int dMax = nColors + offset;
        Color[] col = ColorBrewer.Spectral.getColorPalette(dMax);
        Color4f[] colors = ColorConverter.convertColor4f(col);
        System.arraycopy(colors, offset, colors, 0, dMax - offset);
        return colors;
    }

    private String setCentroid() {
        Point3d centroid = this.helixAxisAligner.calcCenterOfRotation();
        StringBuilder s = new StringBuilder();
        s.append("center");
        s.append(JmolSymmetryScriptGeneratorH.getJmolPoint((Tuple3d)centroid));
        s.append(";");
        return s.toString();
    }
}

