/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import org.biojava.nbio.structure.align.StructureAlignment;
import org.biojava.nbio.structure.align.gui.AlignmentCalcDB;
import org.biojava.nbio.structure.align.gui.ProgressThreadDrawer;
import org.biojava.nbio.structure.align.gui.SelectPDBPanel;
import org.biojava.nbio.structure.align.util.ResourceManager;
import org.biojava.nbio.structure.gui.util.PDBUploadPanel;
import org.biojava.nbio.structure.gui.util.ScopSelectPanel;

public class DBSearchGUI
extends JPanel {
    private static final long serialVersionUID = -5657960663049062301L;
    StructureAlignment algorithm;
    SelectPDBPanel tab1 = new SelectPDBPanel(false);
    JTabbedPane tabPane;
    PDBUploadPanel tab2 = new PDBUploadPanel(false);
    ScopSelectPanel tab3 = new ScopSelectPanel(false);
    JPanel listPane;
    JButton abortB;
    AlignmentCalcDB alicalc;
    JProgressBar progress;
    ProgressThreadDrawer drawer;
    JTextField outFileLocation;
    Boolean useDomainSplit = true;
    static final ResourceManager resourceManager = ResourceManager.getResourceManager((String)"ce");

    public DBSearchGUI() {
        this.tabPane = new JTabbedPane();
        this.tabPane.addTab("Select PDB ID", null, this.tab1, "Select PDB ID to align");
        this.tabPane.addTab("Domains", null, this.tab3, "Domains");
        this.tabPane.addTab("Custom files", null, this.tab2, "Align your own files.");
        this.listPane = this.createListPane();
        Box vBox = Box.createVerticalBox();
        vBox.add(this.tabPane);
        vBox.add(this.listPane);
        vBox.add(Box.createGlue());
        this.add(vBox);
        this.setVisible(true);
    }

    public boolean isDomainSplit() {
        return this.useDomainSplit;
    }

    public JTabbedPane getTabPane() {
        return this.tabPane;
    }

    public void setTabPane(JTabbedPane tabPane) {
        this.tabPane = tabPane;
    }

    public ScopSelectPanel getScopSelectPanel() {
        return this.tab3;
    }

    public SelectPDBPanel getSelectPDBPanel() {
        return this.tab1;
    }

    public PDBUploadPanel getPDBUploadPanel() {
        return this.tab2;
    }

    public String getOutFileLocation() {
        return this.outFileLocation.getText();
    }

    private JPanel createListPane() {
        JLabel lable = new JLabel("Select Output Directory");
        JPanel dir = new JPanel();
        this.outFileLocation = new JTextField(20);
        JButton chB = new JButton("Select");
        Box fileSelectBox = Box.createHorizontalBox();
        fileSelectBox.add(lable);
        fileSelectBox.add(this.outFileLocation);
        fileSelectBox.add(chB);
        fileSelectBox.add(Box.createGlue());
        Box hBox = Box.createVerticalBox();
        hBox.add(fileSelectBox);
        Box panel = this.createDomainSelectPane();
        hBox.add(panel);
        dir.add(hBox);
        chB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser();
                chooser.setMultiSelectionEnabled(false);
                chooser.setDialogTitle("Select Output Directory");
                chooser.setFileSelectionMode(1);
                chooser.setAcceptAllFileFilterUsed(false);
                int returnVal = chooser.showSaveDialog(null);
                if (returnVal == 0) {
                    File file = chooser.getSelectedFile();
                    DBSearchGUI.this.outFileLocation.setText(file.getPath());
                    DBSearchGUI.this.outFileLocation.repaint();
                }
            }
        });
        return dir;
    }

    private Box createDomainSelectPane() {
        this.useDomainSplit = true;
        String[] petStrings = new String[]{"Split proteins in Domains", "Use whole chains"};
        JComboBox<String> domainList = new JComboBox<String>(petStrings);
        domainList.setSelectedIndex(0);
        domainList.setToolTipText("Either align whole chains or SCOP domains and domains assigned with PDP, where no SCOP available.");
        domainList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JComboBox box = (JComboBox)arg0.getSource();
                int index = box.getSelectedIndex();
                DBSearchGUI.this.useDomainSplit = index == 0 ? Boolean.valueOf(true) : Boolean.valueOf(false);
            }
        });
        JLabel label = new JLabel("Domains:");
        Box domainBox = Box.createHorizontalBox();
        domainBox.add(label);
        domainBox.add(domainList);
        domainBox.add(Box.createGlue());
        return domainBox;
    }

    public void notifyCalcFinished() {
        if (this.drawer != null) {
            this.drawer.interrupt();
        }
        this.abortB.setEnabled(false);
        this.progress.setIndeterminate(false);
    }

    public StructureAlignment getStructureAlignment() {
        return this.algorithm;
    }
}

