/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.gui.util;

import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.align.ClusterAltAligs;
import org.biojava.nbio.structure.align.StructurePairAligner;
import org.biojava.nbio.structure.align.gui.AlignmentGui;
import org.biojava.nbio.structure.align.pairwise.AlternativeAlignment;
import org.biojava.nbio.structure.gui.util.AlternativeAlignmentFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlignmentCalc
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(AlignmentCalc.class);
    boolean interrupted = false;
    String pdb1;
    String pdb2;
    String chain1;
    String chain2;
    Structure structure1;
    Structure structure2;
    AlignmentGui parent;

    public AlignmentCalc(AlignmentGui parent, Structure s1, Structure s2) {
        this.parent = parent;
        this.structure1 = s1;
        this.structure2 = s2;
    }

    @Override
    public void run() {
        StructurePairAligner aligner = new StructurePairAligner();
        try {
            aligner.align(this.structure1, this.structure2);
        }
        catch (StructureException e) {
            logger.warn(e.getMessage());
        }
        AlternativeAlignment[] aligs = aligner.getAlignments();
        ClusterAltAligs.cluster((AlternativeAlignment[])aligs);
        this.showAlignment(aligner, aligs);
        this.parent.notifyCalcFinished();
    }

    private void showAlignment(StructurePairAligner alignment, AlternativeAlignment[] aligs) {
        AlternativeAlignmentFrame frame = new AlternativeAlignmentFrame(this.structure1, this.structure2);
        frame.setStructurePairAligner(alignment);
        frame.setAlternativeAlignments(aligs);
        frame.pack();
        frame.setVisible(true);
    }

    public void interrupt() {
        this.interrupted = true;
    }

    public void cleanup() {
        this.parent.notifyCalcFinished();
        this.parent = null;
        this.structure1 = null;
        this.structure2 = null;
    }
}

