/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.gui.util.color;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.color.ColorSpace;
import java.util.Collection;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.biojava.nbio.structure.gui.util.color.ColorInterpolator;
import org.biojava.nbio.structure.gui.util.color.ContinuousColorMapper;
import org.biojava.nbio.structure.gui.util.color.DefaultMatrixMapper;
import org.biojava.nbio.structure.gui.util.color.GradientPanel;
import org.biojava.nbio.structure.gui.util.color.HSVColorSpace;
import org.biojava.nbio.structure.gui.util.color.LinearColorInterpolator;

public class GradientMapper
implements ContinuousColorMapper,
Map<Double, Color> {
    public static final int BLACK_WHITE_GRADIENT = 1;
    public static final int WHITE_BLACK_GRADIENT = 2;
    public static final int RED_BLUE_GRADIENT = 3;
    public static final int RAINBOW_GRADIENT = 4;
    public static final int RAINBOW_INTENSITY_GRADIENT = 5;
    private NavigableMap<Double, Color> mapping = new TreeMap<Double, Color>();
    private ColorInterpolator interpolator;

    public GradientMapper() {
        this(Color.black, Color.white);
    }

    public GradientMapper(Color negInf, Color posInf) {
        this(negInf, posInf, ColorSpace.getInstance(1000));
    }

    public GradientMapper(Color negInf, Color posInf, ColorSpace cspace) {
        this.mapping.put(Double.NEGATIVE_INFINITY, negInf);
        this.mapping.put(Double.POSITIVE_INFINITY, posInf);
        this.interpolator = new LinearColorInterpolator(cspace);
    }

    public static GradientMapper getGradientMapper(int gradientType, double min, double max) {
        switch (gradientType) {
            case 1: {
                GradientMapper gm = new GradientMapper(Color.BLACK, Color.WHITE);
                gm.put(min, Color.BLACK);
                gm.put(max, Color.WHITE);
                return gm;
            }
            case 2: {
                GradientMapper gm = new GradientMapper(Color.WHITE, Color.BLACK);
                gm.put(min, Color.WHITE);
                gm.put(max, Color.BLACK);
                return gm;
            }
            case 3: {
                GradientMapper gm = new GradientMapper(Color.RED, Color.BLUE);
                gm.put(min, Color.RED);
                gm.put(max, Color.BLUE);
                return gm;
            }
            case 4: {
                ColorSpace hsv = HSVColorSpace.getHSVColorSpace();
                LinearColorInterpolator interp = new LinearColorInterpolator(hsv);
                interp.setInterpolationDirection(0, LinearColorInterpolator.InterpolationDirection.UPPER);
                Color hsvLow = new Color(hsv, new float[]{0.0f, 1.0f, 1.0f}, 1.0f);
                Color hsvHigh = new Color(hsv, new float[]{1.0f, 1.0f, 1.0f}, 1.0f);
                GradientMapper gm = new GradientMapper(hsvLow, hsvHigh, hsv);
                gm.put(min, hsvLow);
                gm.put(max, hsvHigh);
                gm.setInterpolator(interp);
                return gm;
            }
            case 5: {
                ColorSpace hsv = HSVColorSpace.getHSVColorSpace();
                LinearColorInterpolator interp = new LinearColorInterpolator(hsv);
                interp.setInterpolationDirection(0, LinearColorInterpolator.InterpolationDirection.LOWER);
                Color hsvLow = new Color(hsv, new float[]{1.0f, 1.0f, 1.0f}, 1.0f);
                Color hsvHigh = new Color(hsv, new float[]{0.0f, 1.0f, 0.0f}, 1.0f);
                GradientMapper gm = new GradientMapper(hsvLow, hsvHigh, hsv);
                gm.put(min, hsvLow);
                gm.put(max, hsvHigh);
                gm.setInterpolator(interp);
                return gm;
            }
        }
        throw new IllegalArgumentException("Unsupported gradient " + gradientType);
    }

    @Override
    public Color getColor(double value) {
        Double left = this.mapping.floorKey(value);
        Double right = this.mapping.higherKey(value);
        if (right == null || right.isInfinite()) {
            return (Color)this.mapping.get(Double.POSITIVE_INFINITY);
        }
        if (left == null || left.isInfinite()) {
            return (Color)this.mapping.get(Double.NEGATIVE_INFINITY);
        }
        float alpha = (float)((right - value) / (right - left));
        return this.interpolator.interpolate((Color)this.mapping.get(left), (Color)this.mapping.get(right), alpha);
    }

    @Override
    public void clear() {
        Color neg = (Color)this.mapping.get(Double.NEGATIVE_INFINITY);
        Color pos = (Color)this.mapping.get(Double.POSITIVE_INFINITY);
        this.mapping.clear();
        this.mapping.put(Double.NEGATIVE_INFINITY, neg);
        this.mapping.put(Double.POSITIVE_INFINITY, pos);
    }

    @Override
    public boolean containsKey(Object position) {
        return this.mapping.containsKey(position);
    }

    @Override
    public boolean containsValue(Object color) {
        return this.mapping.containsValue(color);
    }

    @Override
    public Set<Map.Entry<Double, Color>> entrySet() {
        return this.mapping.entrySet();
    }

    @Override
    public Color get(Object position) {
        return (Color)this.mapping.get(position);
    }

    @Override
    public boolean isEmpty() {
        return this.mapping.size() <= 2;
    }

    @Override
    public Set<Double> keySet() {
        return this.mapping.keySet();
    }

    @Override
    public Color put(Double position, Color color) {
        if (position == null) {
            throw new NullPointerException("Null endpoint position");
        }
        if (color == null) {
            throw new NullPointerException("Null colors are not allowed.");
        }
        return this.mapping.put(position, color);
    }

    @Override
    public void putAll(Map<? extends Double, ? extends Color> m) {
        this.mapping.putAll(m);
    }

    @Override
    public Color remove(Object position) {
        if (((Double)position).isInfinite()) {
            throw new UnsupportedOperationException("Cannot remove infinite endpoints");
        }
        return (Color)this.mapping.remove(position);
    }

    @Override
    public int size() {
        return this.mapping.size() - 2;
    }

    @Override
    public Collection<Color> values() {
        return this.mapping.values();
    }

    public ColorInterpolator getInterpolator() {
        return this.interpolator;
    }

    public void setInterpolator(ColorInterpolator interpolator) {
        this.interpolator = interpolator;
    }

    public static void main(String[] args) {
        GradientMapper[] mappers = new GradientMapper[20];
        int i = 0;
        ColorSpace hsv = HSVColorSpace.getHSVColorSpace();
        mappers[i] = new GradientMapper(Color.black, Color.white);
        mappers[i].put(-5.0, Color.red);
        mappers[i].put(5.0, Color.blue);
        mappers[++i] = GradientMapper.getGradientMapper(1, -5.0, 5.0);
        mappers[++i] = GradientMapper.getGradientMapper(5, -5.0, 5.0);
        mappers[++i] = new GradientMapper(Color.black, Color.white, hsv);
        mappers[i].put(-5.0, new Color(hsv, new float[]{0.0f, 1.0f, 1.0f}, 1.0f));
        mappers[i].put(5.0, new Color(hsv, new float[]{1.0f, 1.0f, 1.0f}, 1.0f));
        mappers[++i] = new GradientMapper(Color.black, Color.white, hsv);
        mappers[i].put(5.0, Color.red);
        mappers[i].put(-5.0, Color.blue);
        LinearColorInterpolator interp = new LinearColorInterpolator(hsv);
        interp.setInterpolationDirection(0, LinearColorInterpolator.InterpolationDirection.OUTER);
        mappers[++i] = new GradientMapper(Color.black, Color.white, hsv);
        mappers[i].put(5.0, Color.red);
        mappers[i].put(-5.0, Color.blue);
        mappers[i].setInterpolator(interp);
        interp = new LinearColorInterpolator(hsv);
        interp.setInterpolationDirection(0, LinearColorInterpolator.InterpolationDirection.UPPER);
        mappers[++i] = new GradientMapper(Color.black, Color.white, hsv);
        mappers[i].put(5.0, Color.red);
        mappers[i].put(-5.0, Color.blue);
        mappers[i].setInterpolator(interp);
        interp = new LinearColorInterpolator(hsv);
        interp.setInterpolationDirection(0, LinearColorInterpolator.InterpolationDirection.LOWER);
        mappers[++i] = new GradientMapper(Color.black, Color.white, hsv);
        mappers[i].put(5.0, Color.red);
        mappers[i].put(-5.0, Color.blue);
        mappers[i].setInterpolator(interp);
        interp = new LinearColorInterpolator(hsv);
        interp.setInterpolationDirection(0, LinearColorInterpolator.InterpolationDirection.INNER);
        mappers[++i] = new GradientMapper(Color.green, Color.black, hsv);
        mappers[i].put(0.0, new Color(hsv, new float[]{1.0f, 0.9f, 1.0f}, 1.0f));
        mappers[i].put(10.0, new Color(hsv, new float[]{0.0f, 0.9f, 0.0f}, 1.0f));
        mappers[i].setInterpolator(interp);
        interp = new LinearColorInterpolator(hsv);
        interp.setInterpolationDirection(0, LinearColorInterpolator.InterpolationDirection.INNER);
        mappers[++i] = new GradientMapper(Color.green, Color.black, hsv);
        mappers[i].put(0.0, new Color(hsv, new float[]{1.0f, 0.9f, 1.0f}, 1.0f));
        mappers[i].put(1.0, new Color(hsv, new float[]{0.0f, 0.9f, 1.0f}, 1.0f));
        mappers[i].put(1.000001, Color.white);
        mappers[i].put(10.0, Color.black);
        mappers[i].setInterpolator(interp);
        interp = new LinearColorInterpolator(hsv);
        interp.setInterpolationDirection(0, LinearColorInterpolator.InterpolationDirection.INNER);
        mappers[++i] = new GradientMapper(Color.green, Color.black, hsv);
        mappers[i].put(0.0, new Color(hsv, new float[]{1.0f, 0.9f, 1.0f}, 1.0f));
        mappers[i].put(1.0, new Color(hsv, new float[]{0.2f, 0.9f, 1.0f}, 1.0f));
        mappers[i].put(1.000001, Color.white);
        mappers[i].put(10.0, Color.black);
        mappers[i].setInterpolator(interp);
        ++i;
        DefaultMatrixMapper defaultMapper = new DefaultMatrixMapper(10.0, 0.9f);
        JFrame frame = new JFrame("GradientMapper");
        JPanel main = new JPanel();
        main.setPreferredSize(new Dimension(300, 500));
        for (int j = 0; j < i; ++j) {
            GradientPanel grad1 = new GradientPanel(mappers[j], -10.0, 10.0);
            main.add(grad1);
        }
        GradientPanel grad2 = new GradientPanel(defaultMapper, -10.0, 10.0);
        main.add(grad2);
        frame.getContentPane().add(main);
        frame.pack();
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }
}

