/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.gui.util.color;

import java.awt.Color;
import java.awt.color.ColorSpace;

public class HSVColorSpace
extends ColorSpace {
    private static final long serialVersionUID = 8324413992279510075L;
    private static HSVColorSpace hsvSpace;
    public static final int CS_HSV = 1007;

    public static void main(String[] args) {
        HSVColorSpace csHSV = new HSVColorSpace();
        ColorSpace csRGB = ColorSpace.getInstance(1000);
        Color c = Color.RED;
        float[] rgbComp = c.getColorComponents(csRGB, null);
        float[] hsvComp = c.getColorComponents(csHSV, null);
        assert (rgbComp.length == 3);
        assert (hsvComp.length == 3);
        System.out.format("RED\tRGB[%f %f %f] HSV[%f %f %f]\n", Float.valueOf(rgbComp[0]), Float.valueOf(rgbComp[1]), Float.valueOf(rgbComp[2]), Float.valueOf(hsvComp[0]), Float.valueOf(hsvComp[1]), Float.valueOf(hsvComp[2]));
        c = Color.WHITE;
        rgbComp = c.getColorComponents(csRGB, null);
        hsvComp = c.getColorComponents(csHSV, null);
        System.out.format("WHITE\tRGB[%f %f %f] HSV[%f %f %f]\n", Float.valueOf(rgbComp[0]), Float.valueOf(rgbComp[1]), Float.valueOf(rgbComp[2]), Float.valueOf(hsvComp[0]), Float.valueOf(hsvComp[1]), Float.valueOf(hsvComp[2]));
        c = Color.BLACK;
        rgbComp = c.getColorComponents(csRGB, null);
        hsvComp = c.getColorComponents(csHSV, null);
        System.out.format("BLACK\tRGB[%f %f %f] HSV[%f %f %f]\n", Float.valueOf(rgbComp[0]), Float.valueOf(rgbComp[1]), Float.valueOf(rgbComp[2]), Float.valueOf(hsvComp[0]), Float.valueOf(hsvComp[1]), Float.valueOf(hsvComp[2]));
        c = Color.GRAY;
        rgbComp = c.getColorComponents(csRGB, null);
        hsvComp = c.getColorComponents(csHSV, null);
        System.out.format("GRAY\tRGB[%f %f %f] HSV[%f %f %f]\n", Float.valueOf(rgbComp[0]), Float.valueOf(rgbComp[1]), Float.valueOf(rgbComp[2]), Float.valueOf(hsvComp[0]), Float.valueOf(hsvComp[1]), Float.valueOf(hsvComp[2]));
        c = Color.CYAN;
        rgbComp = c.getColorComponents(csRGB, null);
        hsvComp = c.getColorComponents(csHSV, null);
        System.out.format("CYAN\tRGB[%f %f %f] HSV[%f %f %f]\n", Float.valueOf(rgbComp[0]), Float.valueOf(rgbComp[1]), Float.valueOf(rgbComp[2]), Float.valueOf(hsvComp[0]), Float.valueOf(hsvComp[1]), Float.valueOf(hsvComp[2]));
    }

    public HSVColorSpace() {
        super(7, 3);
    }

    @Override
    public float[] fromCIEXYZ(float[] ciexyzvalue) {
        ColorSpace CIEXYZcs = ColorSpace.getInstance(1001);
        float[] rgb = CIEXYZcs.toRGB(ciexyzvalue);
        return this.fromRGB(rgb);
    }

    @Override
    public float[] fromRGB(float[] rgbvalue) {
        assert (rgbvalue.length == 3);
        Color rgbColor = new Color(rgbvalue[0], rgbvalue[1], rgbvalue[2]);
        return Color.RGBtoHSB(rgbColor.getRed(), rgbColor.getGreen(), rgbColor.getBlue(), null);
    }

    @Override
    public float[] toCIEXYZ(float[] hsv) {
        float[] rgb = this.toRGB(hsv);
        ColorSpace CIEXYZcs = ColorSpace.getInstance(1001);
        return CIEXYZcs.fromRGB(rgb);
    }

    @Override
    public float[] toRGB(float[] hsv) {
        int rgb = Color.HSBtoRGB(hsv[0], hsv[1], hsv[2]);
        Color rgbColor = new Color(rgb);
        return rgbColor.getColorComponents(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ColorSpace getInstance(int colorspace) {
        ColorSpace theColorSpace;
        switch (colorspace) {
            case 1007: {
                Class<HSVColorSpace> clazz = HSVColorSpace.class;
                synchronized (HSVColorSpace.class) {
                    if (hsvSpace == null) {
                        hsvSpace = new HSVColorSpace();
                    }
                    theColorSpace = hsvSpace;
                    // ** MonitorExit[var2_1] (shouldn't be in output)
                    break;
                }
            }
            default: {
                theColorSpace = ColorSpace.getInstance(colorspace);
            }
        }
        return theColorSpace;
    }

    public static ColorSpace getHSVColorSpace() {
        return HSVColorSpace.getInstance(1007);
    }
}

