/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.gui;

import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.StructureTools;
import org.biojava.nbio.structure.align.StructureAlignment;
import org.biojava.nbio.structure.align.ce.ConfigStrucAligParams;
import org.biojava.nbio.structure.align.gui.AlignmentCalculationRunnable;
import org.biojava.nbio.structure.align.gui.AlignmentGui;
import org.biojava.nbio.structure.align.gui.DisplayAFP;
import org.biojava.nbio.structure.align.gui.StructureAlignmentDisplay;
import org.biojava.nbio.structure.align.gui.jmol.StructureAlignmentJmol;
import org.biojava.nbio.structure.align.model.AFPChain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlignmentCalc
implements AlignmentCalculationRunnable {
    private static final Logger logger = LoggerFactory.getLogger(AlignmentCalc.class);
    boolean interrupted = false;
    String pdb1;
    String pdb2;
    String name1;
    String name2;
    Structure structure1;
    Structure structure2;
    AlignmentGui parent;

    public AlignmentCalc(AlignmentGui parent, Structure s1, Structure s2, String name1, String name2) {
        this.parent = parent;
        this.structure1 = s1;
        this.structure2 = s2;
        this.name1 = name1;
        this.name2 = name2;
    }

    @Override
    public void run() {
        StructureAlignment algorithm = this.parent.getStructureAlignment();
        try {
            Atom[] ca1 = StructureTools.getRepresentativeAtomArray((Structure)this.structure1);
            Atom[] ca2 = StructureTools.getRepresentativeAtomArray((Structure)this.structure2);
            AFPChain afpChain = algorithm.align(ca1, ca2);
            afpChain.setName1(this.name1);
            afpChain.setName2(this.name2);
            StructureAlignmentJmol jmol = StructureAlignmentDisplay.display(afpChain, ca1, ca2);
            Object title = jmol.getTitle();
            ConfigStrucAligParams params = algorithm.getParameters();
            if (params != null) {
                title = (String)title + " " + algorithm.getParameters().toString();
            }
            jmol.setTitle((String)title);
            DisplayAFP.showAlignmentPanel(afpChain, ca1, ca2, jmol);
            System.out.println(afpChain.toCE(ca1, ca2));
        }
        catch (StructureException e) {
            e.printStackTrace();
            logger.warn(e.getMessage());
        }
        this.parent.notifyCalcFinished();
    }

    @Override
    public void interrupt() {
        this.interrupted = true;
    }

    @Override
    public void cleanup() {
        this.parent.notifyCalcFinished();
        this.parent = null;
        this.structure1 = null;
        this.structure2 = null;
    }

    @Override
    public void setNrCPUs(int useNrCPUs) {
    }
}

