/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.gui.aligpanel;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JTextField;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.align.gui.DisplayAFP;
import org.biojava.nbio.structure.align.gui.jmol.JmolTools;
import org.biojava.nbio.structure.align.model.AFPChain;
import org.biojava.nbio.structure.gui.events.AlignmentPositionListener;
import org.biojava.nbio.structure.gui.util.AlignedPosition;

public class StatusDisplay
extends JTextField
implements AlignmentPositionListener,
WindowListener {
    private static final long serialVersionUID = 6939947266417830429L;
    AFPChain afpChain;
    Atom[] ca1;
    Atom[] ca2;

    public StatusDisplay() {
        this.setBackground(Color.white);
        this.setEditable(false);
        this.setMaximumSize(new Dimension(Short.MAX_VALUE, 30));
    }

    public void destroy() {
        this.afpChain = null;
        this.ca1 = null;
        this.ca2 = null;
    }

    @Override
    public void mouseOverPosition(AlignedPosition p) {
        if (this.afpChain == null) {
            return;
        }
        char[] aligs1 = this.afpChain.getAlnseq1();
        char[] aligs2 = this.afpChain.getAlnseq2();
        char c1 = aligs1[p.getPos1()];
        char c2 = aligs2[p.getPos2()];
        try {
            Atom a1 = DisplayAFP.getAtomForAligPos(this.afpChain, 0, p.getPos1(), this.ca1, false);
            Atom a2 = DisplayAFP.getAtomForAligPos(this.afpChain, 1, p.getPos2(), this.ca2, true);
            String pdbInfo1 = JmolTools.getPdbInfo(a1);
            String pdbInfo2 = JmolTools.getPdbInfo(a2);
            String msg = "alig pos:" + p.getPos1() + " " + pdbInfo1 + " (" + c1 + ") : " + pdbInfo2 + " (" + c2 + ")";
            this.setText(msg);
        }
        catch (StructureException e) {
            e.printStackTrace();
        }
        this.repaint();
    }

    @Override
    public void positionSelected(AlignedPosition p) {
        this.mouseOverPosition(p);
    }

    @Override
    public void toggleSelection(AlignedPosition p) {
        if (this.afpChain == null) {
            return;
        }
        char[] aligs1 = this.afpChain.getAlnseq1();
        char[] aligs2 = this.afpChain.getAlnseq2();
        char c1 = aligs1[p.getPos1()];
        char c2 = aligs2[p.getPos2()];
        try {
            Atom a1 = DisplayAFP.getAtomForAligPos(this.afpChain, 0, p.getPos1(), this.ca1, false);
            Atom a2 = DisplayAFP.getAtomForAligPos(this.afpChain, 1, p.getPos2(), this.ca2, true);
            String pdbInfo1 = JmolTools.getPdbInfo(a1);
            String pdbInfo2 = JmolTools.getPdbInfo(a2);
            String msg = "Clicked pos:" + p.getPos1() + " " + pdbInfo1 + " (" + c1 + ") : " + pdbInfo2 + " (" + c2 + ")";
            this.setText(msg);
        }
        catch (StructureException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void rangeSelected(AlignedPosition start, AlignedPosition end) {
        char[] aligs1 = this.afpChain.getAlnseq1();
        char[] aligs2 = this.afpChain.getAlnseq2();
        char c1 = aligs1[start.getPos1()];
        char c3 = aligs1[end.getPos1()];
        char c2 = aligs2[start.getPos2()];
        char c4 = aligs2[end.getPos2()];
        try {
            Atom a1 = DisplayAFP.getAtomForAligPos(this.afpChain, 0, start.getPos1(), this.ca1, false);
            Atom a2 = DisplayAFP.getAtomForAligPos(this.afpChain, 1, start.getPos2(), this.ca2, true);
            Atom a3 = DisplayAFP.getAtomForAligPos(this.afpChain, 0, end.getPos1(), this.ca1, false);
            Atom a4 = DisplayAFP.getAtomForAligPos(this.afpChain, 1, end.getPos2(), this.ca2, true);
            String pdbInfo1 = JmolTools.getPdbInfo(a1);
            String pdbInfo2 = JmolTools.getPdbInfo(a2);
            String pdbInfo3 = JmolTools.getPdbInfo(a3);
            String pdbInfo4 = JmolTools.getPdbInfo(a4);
            String msg = "Selected range1: " + pdbInfo1 + " (" + c1 + ") - " + pdbInfo3 + " (" + c3 + ")";
            msg = msg + " range2: " + pdbInfo2 + " (" + c2 + ") - " + pdbInfo4 + " (" + c4 + ")";
            this.setText(msg);
        }
        catch (StructureException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void selectionLocked() {
    }

    @Override
    public void selectionUnlocked() {
    }

    public AFPChain getAfpChain() {
        return this.afpChain;
    }

    public void setAfpChain(AFPChain afpChain) {
        this.afpChain = afpChain;
    }

    public Atom[] getCa1() {
        return this.ca1;
    }

    public void setCa1(Atom[] ca1) {
        this.ca1 = ca1;
    }

    public Atom[] getCa2() {
        return this.ca2;
    }

    public void setCa2(Atom[] ca2) {
        this.ca2 = ca2;
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.destroy();
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }
}

