/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Bond;
import org.biojava.nbio.structure.Element;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.PDBRecord;
import org.biojava.nbio.structure.io.FileConvert;

public class AtomImpl
implements Atom,
Serializable,
PDBRecord {
    private static final long serialVersionUID = -2258364127420562883L;
    String name = null;
    Element element = Element.R;
    double[] coords = new double[3];
    String pdbline = "";
    int pdbserial;
    double occupancy = 0.0;
    double tempfactor = 0.0;
    Character altLoc = null;
    Group parent = null;
    long id;
    private List<Bond> bonds = Collections.emptyList();

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @Override
    public void setName(String s) {
        this.name = s;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setPDBserial(int i) {
        this.pdbserial = i;
    }

    @Override
    public int getPDBserial() {
        return this.pdbserial;
    }

    @Override
    public void setCoords(double[] c) {
        this.coords = c;
    }

    @Override
    public double[] getCoords() {
        return this.coords;
    }

    @Override
    public void setX(double x) {
        this.coords[0] = x;
    }

    @Override
    public void setY(double y) {
        this.coords[1] = y;
    }

    @Override
    public void setZ(double z) {
        this.coords[2] = z;
    }

    @Override
    public double getX() {
        return this.coords[0];
    }

    @Override
    public double getY() {
        return this.coords[1];
    }

    @Override
    public double getZ() {
        return this.coords[2];
    }

    @Override
    public void setAltLoc(Character c) {
        this.altLoc = c;
    }

    @Override
    public Character getAltLoc() {
        return this.altLoc;
    }

    public String toString() {
        return this.name + " " + this.element + " " + this.pdbserial + " " + this.coords[0] + " " + this.coords[1] + " " + this.coords[2];
    }

    @Override
    public void setOccupancy(double occu) {
        this.occupancy = occu;
    }

    @Override
    public double getOccupancy() {
        return this.occupancy;
    }

    @Override
    public void setTempFactor(double temp) {
        this.tempfactor = temp;
    }

    @Override
    public double getTempFactor() {
        return this.tempfactor;
    }

    @Override
    public Object clone() {
        AtomImpl n = new AtomImpl();
        n.setOccupancy(this.getOccupancy());
        n.setTempFactor(this.getTempFactor());
        n.setAltLoc(this.getAltLoc());
        double[] coords = this.getCoords();
        n.setX(coords[0]);
        n.setY(coords[1]);
        n.setZ(coords[2]);
        n.setPDBserial(this.getPDBserial());
        n.setName(this.getName());
        n.setElement(this.getElement());
        return n;
    }

    @Override
    public void setGroup(Group parent) {
        this.parent = parent;
    }

    @Override
    public Group getGroup() {
        return this.parent;
    }

    @Override
    public Element getElement() {
        return this.element;
    }

    @Override
    public void setElement(Element e) {
        this.element = e;
    }

    @Override
    public String toPDB() {
        return FileConvert.toPDB(this);
    }

    @Override
    public void toPDB(StringBuffer buf) {
        FileConvert.toPDB((Atom)this, buf);
    }

    @Override
    public List<Bond> getBonds() {
        return this.bonds;
    }

    @Override
    public void addBond(Bond bond) {
        if (this.bonds.isEmpty()) {
            this.bonds = new ArrayList<Bond>(3);
        }
        this.bonds.add(bond);
    }
}

