/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure;

import java.io.Serializable;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.GroupType;
import org.biojava.nbio.structure.HetatomImpl;

public class NucleotideImpl
extends HetatomImpl
implements Group,
Serializable,
Cloneable {
    private static final long serialVersionUID = -7467726932980288712L;
    public static final GroupType type = GroupType.NUCLEOTIDE;

    @Override
    public GroupType getType() {
        return type;
    }

    @Override
    public String toString() {
        String str = "PDB: " + this.pdb_name + " " + this.residueNumber + " " + this.pdb_flag;
        if (this.pdb_flag) {
            str = str + "atoms: " + this.atoms.size();
        }
        return str;
    }

    public Atom getO3Prime() {
        return this.getAtom("O3'");
    }

    public Atom getO5Prime() {
        return this.getAtom("O5'");
    }

    public Atom getP() {
        return this.getAtom("P");
    }

    @Override
    public Object clone() {
        NucleotideImpl n = new NucleotideImpl();
        n.setPDBFlag(this.has3D());
        n.setResidueNumber(this.getResidueNumber());
        n.setPDBName(this.getPDBName());
        for (Atom atom1 : this.atoms) {
            Atom atom = (Atom)atom1.clone();
            n.addAtom(atom);
            atom.setGroup(n);
        }
        return n;
    }
}

