/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure;

import java.io.Serializable;
import javax.vecmath.Matrix4d;
import org.biojava.nbio.structure.xtal.CrystalCell;
import org.biojava.nbio.structure.xtal.SpaceGroup;

public class PDBCrystallographicInfo
implements Serializable {
    private static final long serialVersionUID = -7949886749566087669L;
    private CrystalCell cell;
    private SpaceGroup sg;
    private Matrix4d[] ncsOperators;

    public float getA() {
        return (float)this.cell.getA();
    }

    public float getB() {
        return (float)this.cell.getB();
    }

    public float getC() {
        return (float)this.cell.getC();
    }

    public float getAlpha() {
        return (float)this.cell.getAlpha();
    }

    public float getBeta() {
        return (float)this.cell.getBeta();
    }

    public float getGamma() {
        return (float)this.cell.getGamma();
    }

    public CrystalCell getCrystalCell() {
        return this.cell;
    }

    public void setCrystalCell(CrystalCell cell) {
        this.cell = cell;
    }

    public SpaceGroup getSpaceGroup() {
        return this.sg;
    }

    public void setSpaceGroup(SpaceGroup spaceGroup) {
        this.sg = spaceGroup;
    }

    public int getZ() {
        return 0;
    }

    public Matrix4d[] getTransformationsOrthonormal() {
        Matrix4d[] transfs = new Matrix4d[this.getSpaceGroup().getNumOperators()];
        transfs[0] = new Matrix4d(this.getSpaceGroup().getTransformation(0));
        for (int i = 1; i < this.getSpaceGroup().getNumOperators(); ++i) {
            transfs[i] = this.cell.transfToOrthonormal(this.getSpaceGroup().getTransformation(i));
        }
        return transfs;
    }

    public Matrix4d[] getNcsOperators() {
        return this.ncsOperators;
    }

    public void setNcsOperators(Matrix4d[] ncsOperators) {
        this.ncsOperators = ncsOperators;
    }

    public String toString() {
        return "[" + (this.sg == null ? "no SG" : this.sg.getShortSymbol()) + " - " + (this.cell == null ? "no Cell" : String.format("%.2f %.2f %.2f, %.2f %.2f %.2f", this.cell.getA(), this.cell.getB(), this.cell.getC(), this.cell.getAlpha(), this.cell.getBeta(), this.cell.getGamma())) + (this.ncsOperators == null ? "" : String.format(" - %d NCS operators", this.ncsOperators.length)) + "]";
    }
}

