/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure;

import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.AtomImpl;
import org.biojava.nbio.structure.Calc;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.jama.Matrix;
import org.biojava.nbio.structure.jama.SingularValueDecomposition;

public class SVDSuperimposer {
    Matrix rot;
    Matrix tran;
    Matrix centroidA;
    Matrix centroidB;

    public SVDSuperimposer(Atom[] atomSet1, Atom[] atomSet2) throws StructureException {
        if (atomSet1.length != atomSet2.length) {
            throw new StructureException("The two atom sets are not of same length!");
        }
        Atom cena = Calc.getCentroid(atomSet1);
        Atom cenb = Calc.getCentroid(atomSet2);
        double[][] centAcoords = new double[][]{{cena.getX(), cena.getY(), cena.getZ()}};
        this.centroidA = new Matrix(centAcoords);
        double[][] centBcoords = new double[][]{{cenb.getX(), cenb.getY(), cenb.getZ()}};
        this.centroidB = new Matrix(centBcoords);
        Atom[] ats1 = Calc.centerAtoms(atomSet1, cena);
        Atom[] ats2 = Calc.centerAtoms(atomSet2, cenb);
        double[][] coordSet1 = new double[ats1.length][3];
        double[][] coordSet2 = new double[ats2.length][3];
        for (int i = 0; i < ats1.length; ++i) {
            coordSet1[i] = ats1[i].getCoords();
            coordSet2[i] = ats2[i].getCoords();
        }
        this.calculate(coordSet1, coordSet2);
    }

    private void calculate(double[][] coordSet1, double[][] coordSet2) {
        Matrix a = new Matrix(coordSet1);
        Matrix b = new Matrix(coordSet2);
        Matrix b_trans = b.transpose();
        Matrix corr = b_trans.times(a);
        SingularValueDecomposition svd = corr.svd();
        Matrix u = svd.getU();
        Matrix vt = svd.getV();
        Matrix vt_orig = (Matrix)vt.clone();
        Matrix u_transp = u.transpose();
        Matrix rot_nottrans = vt.times(u_transp);
        this.rot = rot_nottrans.transpose();
        double det = this.rot.det();
        if (det < 0.0) {
            vt = vt_orig.transpose();
            vt.set(2, 0, 0.0 - vt.get(2, 0));
            vt.set(2, 1, 0.0 - vt.get(2, 1));
            vt.set(2, 2, 0.0 - vt.get(2, 2));
            Matrix nv_transp = vt.transpose();
            rot_nottrans = nv_transp.times(u_transp);
            this.rot = rot_nottrans.transpose();
        }
        Matrix cb_tmp = this.centroidB.times(this.rot);
        this.tran = this.centroidA.minus(cb_tmp);
    }

    public static double getRMS(Atom[] atomSet1, Atom[] atomSet2) throws StructureException {
        if (atomSet1.length != atomSet2.length) {
            throw new StructureException("The two atom sets are not of same length!");
        }
        double sum = 0.0;
        for (int i = 0; i < atomSet1.length; ++i) {
            double d = Calc.getDistance(atomSet1[i], atomSet2[i]);
            sum += d * d;
        }
        double avd = sum / (double)atomSet1.length;
        return Math.sqrt(avd);
    }

    public static double getTMScore(Atom[] atomSet1, Atom[] atomSet2, int len1, int len2) throws StructureException {
        if (atomSet1.length != atomSet2.length) {
            throw new StructureException("The two atom sets are not of same length!");
        }
        if (atomSet1.length > len1) {
            throw new StructureException("len1 must be greater or equal to the alignment length!");
        }
        if (atomSet2.length > len2) {
            throw new StructureException("len2 must be greater or equal to the alignment length!");
        }
        int Lmin = Math.min(len1, len2);
        int Laln = atomSet1.length;
        double d0 = 1.24 * Math.cbrt((double)Lmin - 15.0) - 1.8;
        double d0sq = d0 * d0;
        double sum = 0.0;
        for (int i = 0; i < Laln; ++i) {
            double d = Calc.getDistance(atomSet1[i], atomSet2[i]);
            sum += 1.0 / (1.0 + d * d / d0sq);
        }
        return sum / (double)Lmin;
    }

    public static double getTMScoreAlternate(Atom[] atomSet1, Atom[] atomSet2, int len1, int len2) throws StructureException {
        if (atomSet1.length != atomSet2.length) {
            throw new StructureException("The two atom sets are not of same length!");
        }
        if (atomSet1.length > len1) {
            throw new StructureException("len1 must be greater or equal to the alignment length!");
        }
        if (atomSet2.length > len2) {
            throw new StructureException("len2 must be greater or equal to the alignment length!");
        }
        int Lmax = Math.max(len1, len2);
        int Laln = atomSet1.length;
        double d0 = 1.24 * Math.cbrt((double)Lmax - 15.0) - 1.8;
        double d0sq = d0 * d0;
        double sum = 0.0;
        for (int i = 0; i < Laln; ++i) {
            double d = Calc.getDistance(atomSet1[i], atomSet2[i]);
            sum += 1.0 / (1.0 + d * d / d0sq);
        }
        return sum / (double)Lmax;
    }

    public Matrix getRotation() {
        return this.rot;
    }

    public Atom getTranslation() {
        AtomImpl a = new AtomImpl();
        a.setX(this.tran.get(0, 0));
        a.setY(this.tran.get(0, 1));
        a.setZ(this.tran.get(0, 2));
        return a;
    }
}

