/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure;

import java.io.IOException;
import java.util.List;
import org.biojava.nbio.structure.AtomPositionMap;
import org.biojava.nbio.structure.ResidueRange;
import org.biojava.nbio.structure.ResidueRangeAndLength;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.StructureIdentifier;
import org.biojava.nbio.structure.align.util.AtomCache;

public class SubstructureIdentifier
implements StructureIdentifier {
    private final String pdbId;
    private final List<? extends ResidueRange> ranges;

    public SubstructureIdentifier(String pdbId, List<ResidueRange> ranges) {
        this.pdbId = pdbId;
        this.ranges = ranges;
    }

    public SubstructureIdentifier(String id, AtomCache cache) throws IOException, StructureException {
        this.pdbId = id.contains(".") ? id.split("\\.")[0] : id;
        AtomPositionMap map = new AtomPositionMap(cache.getAtoms(this.pdbId));
        if (id.contains("_")) {
            String[] s = id.split("\\.");
            this.ranges = ResidueRangeAndLength.parseMultiple(s[1], map);
        } else {
            this.ranges = map.getRanges();
        }
    }

    @Override
    public String getIdentifier() {
        if (this.ranges.isEmpty()) {
            return this.pdbId;
        }
        return this.pdbId + "." + ResidueRange.toString(this.ranges);
    }

    @Override
    public String getPdbId() {
        return this.pdbId;
    }

    @Override
    public List<? extends ResidueRange> getResidueRanges() {
        return this.ranges;
    }

    @Override
    public List<String> getRanges() {
        return ResidueRange.toStrings(this.ranges);
    }

    public String toString() {
        return this.getIdentifier();
    }
}

