/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align;

import java.io.File;
import java.io.IOException;
import java.util.SortedSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.biojava.nbio.core.util.ConcurrencyTools;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureTools;
import org.biojava.nbio.structure.align.CallableStructureAlignment;
import org.biojava.nbio.structure.align.StructureAlignment;
import org.biojava.nbio.structure.align.ce.CeParameters;
import org.biojava.nbio.structure.align.ce.ConfigStrucAligParams;
import org.biojava.nbio.structure.align.client.FarmJobParameters;
import org.biojava.nbio.structure.align.client.JFatCatClient;
import org.biojava.nbio.structure.align.client.PdbPair;
import org.biojava.nbio.structure.align.client.StructureName;
import org.biojava.nbio.structure.align.model.AFPChain;
import org.biojava.nbio.structure.align.util.AtomCache;
import org.biojava.nbio.structure.align.util.SynchronizedOutFile;
import org.biojava.nbio.structure.domain.DomainProvider;
import org.biojava.nbio.structure.domain.DomainProviderFactory;
import org.biojava.nbio.structure.domain.RemoteDomainProvider;
import org.biojava.nbio.structure.io.LocalPDBDirectory;
import org.biojava.nbio.structure.io.PDBFileReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiThreadedDBSearch {
    private static final Logger logger = LoggerFactory.getLogger(MultiThreadedDBSearch.class);
    AtomicBoolean interrupted = new AtomicBoolean(false);
    StructureAlignment algorithm;
    String outFile;
    String name1;
    int nrCPUs;
    AtomCache cache;
    File resultList;
    SortedSet<String> representatives;
    boolean domainSplit;
    Structure structure1;
    String customFile1;
    String customChain1;

    public MultiThreadedDBSearch(String name, Structure structure, String outFile, StructureAlignment algorithm, int nrCPUs, boolean domainSplit) {
        this.name1 = name;
        this.structure1 = structure;
        this.outFile = outFile;
        this.algorithm = algorithm;
        this.nrCPUs = nrCPUs;
        this.domainSplit = domainSplit;
        this.cache = new AtomCache();
        String serverLocation = FarmJobParameters.DEFAULT_SERVER_URL;
        if (this.representatives == null) {
            SortedSet<String> repre = JFatCatClient.getRepresentatives(serverLocation, 40);
            logger.info("got {} representatives for comparison", (Object)repre.size());
            this.representatives = repre;
        }
    }

    public String getCustomFile1() {
        return this.customFile1;
    }

    public void setCustomFile1(String customFile1) {
        this.customFile1 = customFile1;
    }

    public String getCustomChain1() {
        return this.customChain1;
    }

    public void setCustomChain1(String customChain1) {
        this.customChain1 = customChain1;
    }

    public AtomCache getAtomCache() {
        return this.cache;
    }

    public void setAtomCache(AtomCache cache) {
        this.cache = cache;
    }

    public StructureAlignment getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(StructureAlignment algo) {
        this.algorithm = algo;
    }

    public String getOutFile() {
        return this.outFile;
    }

    public void setOutFile(String outFile) {
        this.outFile = outFile;
    }

    public static String getLegend(String algorithmName) {
        if (algorithmName.equalsIgnoreCase("jCE") || algorithmName.equalsIgnoreCase("jCE-sidechain") || algorithmName.equalsIgnoreCase("jCE Circular Permutation")) {
            return "# name1\tname2\tscore\tz-score\trmsd\tlen1\tlen2\tcov1\tcov2\t%ID\tDescription\t ";
        }
        return "# name1\tname2\tscore\tprobability\trmsd\tlen1\tlen2\tcov1\tcov2\t%ID\tDescription\t ";
    }

    public File getResultFile() {
        return this.resultList;
    }

    public void setResultFile(File resultList) {
        this.resultList = resultList;
    }

    public void run() {
        SynchronizedOutFile out;
        File outFileF = null;
        try {
            CeParameters ceParams;
            ConfigStrucAligParams params;
            this.checkLocalFiles();
            if (this.interrupted.get()) {
                return;
            }
            String header = "# algorithm:" + this.algorithm.getAlgorithmName();
            String legend = MultiThreadedDBSearch.getLegend(this.algorithm.getAlgorithmName());
            outFileF = new File(this.outFile);
            if (!outFileF.isDirectory()) {
                logger.error("{} is not a directory, can't create result files in there...", (Object)outFileF.getAbsolutePath());
                this.interrupt();
                this.cleanup();
            }
            if (this.name1 == null) {
                this.name1 = "CUSTOM";
            }
            this.resultList = new File(outFileF, "results_" + this.name1 + ".out");
            logger.info("writing results to {}", (Object)this.resultList.getAbsolutePath());
            out = new SynchronizedOutFile(this.resultList);
            out.write(header);
            out.write(AFPChain.newline);
            out.write(legend);
            out.write(AFPChain.newline);
            if (this.name1.equals("CUSTOM")) {
                String config1 = "#param:file1=" + this.customFile1;
                out.write(config1);
                out.write(AFPChain.newline);
                if (this.customChain1 != null) {
                    String config2 = "#param:chain1=" + this.customChain1;
                    out.write(config2);
                    out.write(AFPChain.newline);
                }
            }
            if (this.algorithm.getAlgorithmName().startsWith("jCE") && (params = this.algorithm.getParameters()) instanceof CeParameters && (ceParams = (CeParameters)params).getScoringStrategy() != CeParameters.ScoringStrategy.DEFAULT_SCORING_STRATEGY) {
                String scoring = "#param:scoring=" + (Object)((Object)ceParams.getScoringStrategy());
                out.write(scoring);
                out.write(AFPChain.newline);
            }
            out.flush();
        }
        catch (IOException e) {
            logger.error("Error while loading representative structure {}", (Object)this.name1, (Object)e);
            this.interrupt();
            this.cleanup();
            return;
        }
        DomainProvider domainProvider = DomainProviderFactory.getDomainProvider();
        ConcurrencyTools.setThreadPoolSize((int)this.nrCPUs);
        Atom[] ca1 = StructureTools.getAtomCAArray(this.structure1);
        int nrJobs = 0;
        for (String repre : this.representatives) {
            if (this.domainSplit) {
                SortedSet<String> domainNames = domainProvider.getDomainNames(repre);
                if (domainNames == null || domainNames.size() == 0) {
                    this.submit(this.name1, repre, ca1, this.algorithm, outFileF, out, this.cache);
                    ++nrJobs;
                    continue;
                }
                for (String domain : domainNames) {
                    this.submit(this.name1, domain, ca1, this.algorithm, outFileF, out, this.cache);
                    ++nrJobs;
                }
                continue;
            }
            this.submit(this.name1, repre, ca1, this.algorithm, outFileF, out, this.cache);
            ++nrJobs;
        }
        ThreadPoolExecutor pool = ConcurrencyTools.getThreadPool();
        logger.info("{}", (Object)pool.getPoolSize());
        long startTime = System.currentTimeMillis();
        try {
            while (pool.getCompletedTaskCount() < (long)(nrJobs - 1) && !this.interrupted.get()) {
                Thread.sleep(2000L);
            }
            out.close();
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
            this.interrupt();
            this.cleanup();
        }
        if (domainProvider instanceof RemoteDomainProvider) {
            RemoteDomainProvider remote = (RemoteDomainProvider)domainProvider;
            remote.flushCache();
        }
        long now = System.currentTimeMillis();
        logger.info("Calculation took : {} sec.", (Object)((now - startTime) / 1000L));
        logger.info("{} {} {} {}", new Object[]{pool.getCompletedTaskCount(), pool.getPoolSize(), pool.getActiveCount(), pool.getTaskCount()});
    }

    private void checkLocalFiles() throws IOException {
        logger.info("Checking local PDB installation in directory: {}", (Object)this.cache.getPath());
        File f = new File(this.cache.getPath());
        if (!f.isDirectory()) {
            logger.error("The path {} should point to a directory!", (Object)f.getAbsolutePath());
        }
        if (!f.canWrite()) {
            logger.error("You do not have permission to write to {}. There could be a problem if the PDB installation is not up-to-date with fetching missing PDB files.", (Object)f.getAbsolutePath());
        }
        DomainProvider domainProvider = DomainProviderFactory.getDomainProvider();
        for (String repre : this.representatives) {
            if (this.interrupted.get()) {
                return;
            }
            if (this.domainSplit) {
                SortedSet<String> domainNames = domainProvider.getDomainNames(repre);
                if (domainNames == null || domainNames.size() == 0) {
                    this.checkFile(repre);
                    continue;
                }
                for (String domain : domainNames) {
                    this.checkFile(domain);
                }
                continue;
            }
            this.checkFile(repre);
        }
        if (domainProvider instanceof RemoteDomainProvider) {
            RemoteDomainProvider remoteP = (RemoteDomainProvider)domainProvider;
            remoteP.flushCache();
        }
        logger.info("done checking local files...");
    }

    private void checkFile(String repre) throws IOException {
        StructureName name = new StructureName(repre);
        PDBFileReader reader = new PDBFileReader();
        reader.setFetchBehavior(LocalPDBDirectory.FetchBehavior.FETCH_REMEDIATED);
        reader.setPath(this.cache.getPath());
        reader.setFileParsingParameters(this.cache.getFileParsingParams());
        reader.prefetchStructure(name.getPdbId());
    }

    private void submit(String name12, String repre, Atom[] ca1, StructureAlignment algorithm, File outFileF, SynchronizedOutFile out, AtomCache cache) {
        CallableStructureAlignment ali = new CallableStructureAlignment();
        PdbPair pair = new PdbPair(this.name1, repre);
        try {
            ali.setCa1(ca1);
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
            ConcurrencyTools.shutdown();
            return;
        }
        ali.setAlgorithmName(algorithm.getAlgorithmName());
        ali.setParameters(algorithm.getParameters());
        ali.setPair(pair);
        ali.setOutFile(out);
        ali.setOutputDir(outFileF);
        ali.setCache(cache);
        ConcurrencyTools.submit((Callable)ali);
    }

    public void interrupt() {
        this.interrupted.set(true);
        ThreadPoolExecutor pool = ConcurrencyTools.getThreadPool();
        pool.shutdownNow();
        DomainProvider domainProvider = DomainProviderFactory.getDomainProvider();
        if (domainProvider instanceof RemoteDomainProvider) {
            RemoteDomainProvider remote = (RemoteDomainProvider)domainProvider;
            remote.flushCache();
        }
    }

    public void cleanup() {
        this.structure1 = null;
    }
}

