/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.contact;

import java.io.Serializable;
import java.util.Arrays;
import javax.vecmath.Vector3d;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.contact.StructureInterfaceList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoundingBox
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(StructureInterfaceList.class);
    public double xmin;
    public double xmax;
    public double ymin;
    public double ymax;
    public double zmin;
    public double zmax;

    public BoundingBox(double xmin, double xmax, double ymin, double ymax, double zmin, double zmax) {
        this.xmin = xmin;
        this.xmax = xmax;
        this.ymin = ymin;
        this.ymax = ymax;
        this.zmin = zmin;
        this.zmax = zmax;
    }

    public BoundingBox(BoundingBox bb) {
        this.xmin = bb.xmin;
        this.xmax = bb.xmax;
        this.ymin = bb.ymin;
        this.ymax = bb.ymax;
        this.zmin = bb.zmin;
        this.zmax = bb.zmax;
    }

    public BoundingBox(Atom[] atoms) {
        if (atoms.length == 0) {
            logger.error("Error! Empty list of atoms");
        }
        this.xmin = this.xmax = atoms[0].getX();
        this.ymin = this.ymax = atoms[0].getY();
        this.zmin = this.zmax = atoms[0].getZ();
        for (int i = 1; i < atoms.length; ++i) {
            if (atoms[i].getX() > this.xmax) {
                this.xmax = atoms[i].getX();
            } else if (atoms[i].getX() < this.xmin) {
                this.xmin = atoms[i].getX();
            }
            if (atoms[i].getY() > this.ymax) {
                this.ymax = atoms[i].getY();
            } else if (atoms[i].getY() < this.ymin) {
                this.ymin = atoms[i].getY();
            }
            if (atoms[i].getZ() > this.zmax) {
                this.zmax = atoms[i].getZ();
                continue;
            }
            if (!(atoms[i].getZ() < this.zmin)) continue;
            this.zmin = atoms[i].getZ();
        }
    }

    public BoundingBox(BoundingBox[] boxes) {
        if (boxes.length == 0) {
            logger.error("Error! Empty list of bounding boxes");
        }
        this.xmax = boxes[0].xmax;
        this.xmin = boxes[0].xmin;
        this.ymax = boxes[0].ymax;
        this.ymin = boxes[0].ymin;
        this.zmax = boxes[0].zmax;
        this.zmin = boxes[0].zmin;
        for (int i = 1; i < boxes.length; ++i) {
            if (boxes[i].xmax > this.xmax) {
                this.xmax = boxes[i].xmax;
            } else if (boxes[i].xmin < this.xmin) {
                this.xmin = boxes[i].xmin;
            }
            if (boxes[i].ymax > this.ymax) {
                this.ymax = boxes[i].ymax;
            } else if (boxes[i].ymin < this.ymin) {
                this.ymin = boxes[i].ymin;
            }
            if (boxes[i].zmax > this.zmax) {
                this.zmax = boxes[i].zmax;
                continue;
            }
            if (!(boxes[i].zmin < this.zmin)) continue;
            this.zmin = boxes[i].zmin;
        }
    }

    public boolean overlaps(BoundingBox o, double cutoff) {
        if (this == o) {
            return true;
        }
        if (!this.areOverlapping(this.xmin, this.xmax, o.xmin, o.xmax, cutoff)) {
            return false;
        }
        if (!this.areOverlapping(this.ymin, this.ymax, o.ymin, o.ymax, cutoff)) {
            return false;
        }
        return this.areOverlapping(this.zmin, this.zmax, o.zmin, o.zmax, cutoff);
    }

    private boolean areOverlapping(double imin, double imax, double jmin, double jmax, double cutoff) {
        Object[] bounds = new Bound[]{new Bound(0, imin), new Bound(1, imax), new Bound(2, jmin), new Bound(3, jmax)};
        Arrays.sort(bounds);
        return !(((Bound)bounds[0]).cardinal == 0 && ((Bound)bounds[1]).cardinal == 1 ? ((Bound)bounds[2]).value - ((Bound)bounds[1]).value > cutoff : ((Bound)bounds[0]).cardinal == 2 && ((Bound)bounds[1]).cardinal == 3 && ((Bound)bounds[2]).value - ((Bound)bounds[1]).value > cutoff);
    }

    public void translate(Vector3d translation) {
        this.xmin += translation.x;
        this.xmax += translation.x;
        this.ymin += translation.y;
        this.ymax += translation.y;
        this.zmin += translation.z;
        this.zmax += translation.z;
    }

    public double[] getMinMax(double[] array) {
        double[] minmax = new double[2];
        double max = Double.MIN_VALUE;
        double min = Double.MAX_VALUE;
        for (double value : array) {
            if (value > max) {
                max = value;
            }
            if (!(value < min)) continue;
            min = value;
        }
        minmax[0] = min;
        minmax[1] = max;
        return minmax;
    }

    public String toString() {
        return String.format("[(%7.2f,%7.2f),(%7.2f,%7.2f),(%7.2f,%7.2f)]", this.xmin, this.xmax, this.ymin, this.ymax, this.zmin, this.zmax);
    }

    private class Bound
    implements Comparable<Bound> {
        int cardinal;
        double value;

        public Bound(int cardinal, double value) {
            this.cardinal = cardinal;
            this.value = value;
        }

        @Override
        public int compareTo(Bound o) {
            return Double.compare(this.value, o.value);
        }

        public String toString() {
            return "[" + this.cardinal + "," + this.value + "]";
        }
    }
}

