/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.contact;

import java.util.ArrayList;
import java.util.List;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.contact.AtomContact;
import org.biojava.nbio.structure.contact.Pair;

public class GroupContact {
    private Pair<Group> pair;
    private List<AtomContact> atomContacts = new ArrayList<AtomContact>();

    public void addAtomContact(AtomContact atomContact) {
        this.atomContacts.add(atomContact);
    }

    public Pair<Group> getPair() {
        return this.pair;
    }

    public void setPair(Pair<Group> pair) {
        this.pair = pair;
    }

    public double getMinDistance() {
        if (this.atomContacts.size() == 0) {
            return 0.0;
        }
        double minDistance = Double.MAX_VALUE;
        for (AtomContact atomContact : this.atomContacts) {
            if (!(atomContact.getDistance() < minDistance)) continue;
            minDistance = atomContact.getDistance();
        }
        return minDistance;
    }

    public int getNumAtomContacts() {
        return this.atomContacts.size();
    }

    public List<AtomContact> getAtomContacts() {
        return this.atomContacts;
    }

    public List<AtomContact> getContactsWithinDistance(double distance) {
        ArrayList<AtomContact> list = new ArrayList<AtomContact>();
        for (AtomContact contact : this.atomContacts) {
            if (!(contact.getDistance() < distance)) continue;
            list.add(contact);
        }
        return list;
    }

    public String toString() {
        return this.pair.getFirst().getResidueNumber() + "," + this.pair.getSecond().getResidueNumber();
    }
}

