/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.domain;

import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.biojava.nbio.structure.align.client.JFatCatClient;
import org.biojava.nbio.structure.align.client.StructureName;
import org.biojava.nbio.structure.align.util.HTTPConnectionTools;
import org.biojava.nbio.structure.domain.AssignmentXMLSerializer;
import org.biojava.nbio.structure.domain.DomainProvider;
import org.biojava.nbio.structure.domain.PDPProvider;
import org.biojava.nbio.structure.domain.RemotePDPProvider;
import org.biojava.nbio.structure.domain.SerializableCache;
import org.biojava.nbio.structure.scop.ScopDatabase;
import org.biojava.nbio.structure.scop.ScopDomain;
import org.biojava.nbio.structure.scop.ScopFactory;
import org.biojava.nbio.structure.scop.server.XMLUtil;

public class RemoteDomainProvider
extends SerializableCache<String, SortedSet<String>>
implements DomainProvider {
    public String url = "http://source.rcsb.org/jfatcatserver/domains/";
    ScopDatabase scop;
    PDPProvider pdp;
    private static String CACHE_FILE_NAME = "remotedomaincache.ser";

    public RemoteDomainProvider() {
        this(false);
    }

    public RemoteDomainProvider(boolean cache) {
        super(CACHE_FILE_NAME);
        if (!cache) {
            this.disableCache();
        } else {
            this.loadRepresentativeDomainAssignments();
        }
        this.scop = ScopFactory.getSCOP();
        this.pdp = new RemotePDPProvider(true);
    }

    private void loadRepresentativeDomainAssignments() {
        AssignmentXMLSerializer results = null;
        try {
            URL u = new URL(this.url + "getRepresentativeDomains");
            System.out.println(u);
            InputStream response = HTTPConnectionTools.getInputStream(u);
            String xml = JFatCatClient.convertStreamToString(response);
            results = AssignmentXMLSerializer.fromXML(xml);
            Map<String, String> data = results.getAssignments();
            System.out.println("got " + data.size() + " ranges from server.");
            for (String key : data.keySet()) {
                String range = data.get(key);
                String[] spl = range.split(",");
                TreeSet<String> value = new TreeSet<String>();
                for (String s : spl) {
                    value.add(s);
                }
                this.serializedCache.put(key, value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public SortedSet<String> getDomainNames(String name) {
        if (name.length() < 4) {
            throw new IllegalArgumentException("Can't interpret IDs that are shorter than 4 residues!");
        }
        if (this.serializedCache != null && this.serializedCache.containsKey(name)) {
            return (SortedSet)this.serializedCache.get(name);
        }
        StructureName n = new StructureName(name);
        List<ScopDomain> scopDomains = this.scop.getDomainsForPDB(n.getPdbId());
        String chainID = n.getChainId();
        if (scopDomains == null || scopDomains.size() == 0) {
            SortedSet<String> data = this.getPDPDomains(n);
            this.cache(name, data);
            return data;
        }
        TreeSet<String> r = new TreeSet<String>();
        for (ScopDomain d : scopDomains) {
            StructureName s = new StructureName(d.getScopId());
            if (chainID == null) {
                r.add(s.getName());
                continue;
            }
            if (!s.getChainId().equalsIgnoreCase(n.getChainId())) continue;
            r.add(s.getName());
        }
        this.cache(name, r);
        return r;
    }

    private SortedSet<String> getPDPDomains(StructureName n) {
        SortedSet<String> pdpDomains = this.pdp.getPDPDomainNamesForPDB(n.getPdbId());
        TreeSet<String> r = new TreeSet<String>();
        String chainID = n.getChainId();
        for (String s : pdpDomains) {
            StructureName d = new StructureName(s);
            if (chainID == null) {
                r.add(s);
                continue;
            }
            if (!d.getChainId().equals(n.getChainId())) continue;
            r.add(s);
        }
        System.out.println(n + " got PDP domains: " + r);
        return r;
    }

    public static void main(String[] args) {
        String name = "3KIH.A";
        try {
            RemoteDomainProvider me = new RemoteDomainProvider(true);
            System.out.println(me.getDomainNames(name));
            StructureName n = new StructureName(name);
            System.out.println(n);
            me.flushCache();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void flushCache() {
        super.flushCache();
        if (this.pdp instanceof RemotePDPProvider) {
            RemotePDPProvider remotePDP = (RemotePDPProvider)this.pdp;
            remotePDP.flushCache();
        }
    }

    @Override
    public SortedSet<String> getRepresentativeDomains() {
        String url = "http://source.rcsb.org/jfatcatserver/domains/getRepresentativeDomainNames";
        SortedSet<String> domainRanges = null;
        try {
            URL u = new URL(url);
            InputStream response = HTTPConnectionTools.getInputStream(u);
            String xml = JFatCatClient.convertStreamToString(response);
            domainRanges = XMLUtil.getDomainRangesFromXML(xml);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return domainRanges;
    }
}

