/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.io;

import java.util.ArrayList;
import java.util.List;
import org.biojava.nbio.structure.AminoAcid;
import org.biojava.nbio.structure.AminoAcidImpl;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Chain;
import org.biojava.nbio.structure.ChainImpl;
import org.biojava.nbio.structure.Element;
import org.biojava.nbio.structure.Group;

public class CAConverter {
    public static List<Chain> getCAOnly(List<Chain> chains) {
        ArrayList<Chain> newChains = new ArrayList<Chain>();
        for (Chain chain : chains) {
            Chain newChain = CAConverter.getCAOnly(chain);
            newChains.add(newChain);
        }
        return newChains;
    }

    public static Chain getCAOnly(Chain chain) {
        ChainImpl newChain = new ChainImpl();
        newChain.setChainID(chain.getChainID());
        newChain.setCompound(chain.getCompound());
        newChain.setSwissprotId(chain.getSwissprotId());
        List<Group> groups = chain.getAtomGroups();
        block0: for (Group g : groups) {
            List<Atom> atoms = g.getAtoms();
            if (!(g instanceof AminoAcid)) continue;
            for (Atom a : atoms) {
                if (!a.getName().equals("CA") || a.getElement() != Element.C) continue;
                AminoAcidImpl n = new AminoAcidImpl();
                n.setPDBName(g.getPDBName());
                n.setResidueNumber(g.getResidueNumber());
                n.addAtom(a);
                newChain.addGroup(n);
                continue block0;
            }
        }
        return newChain;
    }
}

