/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.io;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.biojava.nbio.structure.Chain;
import org.biojava.nbio.structure.Compound;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.GroupType;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.StructureTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompoundFinder {
    private Structure s;
    private static final Logger logger = LoggerFactory.getLogger(CompoundFinder.class);
    public static final double RATIO_GAPS_FOR_MISMATCH = 0.5;

    public CompoundFinder(Structure s) {
        this.s = s;
    }

    public List<Compound> findCompounds() {
        TreeMap<String, Compound> chainIds2entities = this.findCompoundsFromAtomSequences();
        return CompoundFinder.findUniqueCompounds(chainIds2entities);
    }

    private static List<Compound> findUniqueCompounds(TreeMap<String, Compound> chainIds2entities) {
        ArrayList<Compound> list = new ArrayList<Compound>();
        for (Compound cluster : chainIds2entities.values()) {
            boolean present = false;
            for (Compound cl : list) {
                if (cl != cluster) continue;
                present = true;
                break;
            }
            if (present) continue;
            list.add(cluster);
        }
        return list;
    }

    private TreeMap<String, Compound> findCompoundsFromAtomSequences() {
        TreeMap<String, Compound> chainIds2compounds = new TreeMap<String, Compound>();
        int molId = 1;
        block0: for (int i = 0; i < this.s.getChains().size(); ++i) {
            for (int j = i + 1; j < this.s.getChains().size(); ++j) {
                Chain c2;
                Chain c1 = this.s.getChain(i);
                if (CompoundFinder.areResNumbersAligned(c1, c2 = this.s.getChain(j))) {
                    Compound ent;
                    if (!chainIds2compounds.containsKey(c1.getChainID()) && !chainIds2compounds.containsKey(c2.getChainID())) {
                        logger.debug("Creating Compound with chains {},{}", (Object)c1.getChainID(), (Object)c2.getChainID());
                        ent = new Compound();
                        ent.addChain(c1);
                        ent.addChain(c2);
                        ent.setMolId(molId++);
                        chainIds2compounds.put(c1.getChainID(), ent);
                        chainIds2compounds.put(c2.getChainID(), ent);
                    } else {
                        ent = chainIds2compounds.get(c1.getChainID());
                        if (ent == null) {
                            logger.debug("Adding chain {} to Compound {}", (Object)c1.getChainID(), (Object)c2.getChainID());
                            ent = chainIds2compounds.get(c2.getChainID());
                            ent.addChain(c1);
                            chainIds2compounds.put(c1.getChainID(), ent);
                        } else {
                            logger.debug("Adding chain {} to Compound {}", (Object)c2.getChainID(), (Object)c1.getChainID());
                            ent.addChain(c2);
                            chainIds2compounds.put(c2.getChainID(), ent);
                        }
                    }
                }
                if (chainIds2compounds.size() == this.s.getChains().size()) break block0;
            }
        }
        for (Chain c : this.s.getChains()) {
            if (chainIds2compounds.containsKey(c.getChainID())) continue;
            logger.debug("Creating a 1-member Compound for chain {}", (Object)c.getChainID());
            Compound ent = new Compound();
            ent.addChain(c);
            ent.setMolId(molId++);
            chainIds2compounds.put(c.getChainID(), ent);
        }
        return chainIds2compounds;
    }

    private static boolean areResNumbersAligned(Chain c1, Chain c2) {
        boolean isC2prot;
        boolean isC1prot = StructureTools.isProtein(c1);
        if (isC1prot != (isC2prot = StructureTools.isProtein(c2))) {
            return false;
        }
        List<Group> c1AtomGroups = null;
        c1AtomGroups = isC1prot ? c1.getAtomGroups(GroupType.AMINOACID) : c1.getAtomGroups(GroupType.NUCLEOTIDE);
        int countGaps = 0;
        for (Group g1 : c1AtomGroups) {
            try {
                Group g2 = c2.getGroupByPDB(g1.getResidueNumber());
                if (g2.getPDBName().equals(g1.getPDBName())) continue;
                logger.debug("Mismatch of residues between chains {},{} for residue number {}: {} {}", new Object[]{c1.getChainID(), c2.getChainID(), g1.getResidueNumber(), g1.getPDBName(), g2.getPDBName()});
                return false;
            }
            catch (StructureException e) {
                ++countGaps;
            }
        }
        if ((double)countGaps / (double)c1AtomGroups.size() > 0.5) {
            logger.info("More than {} of the residues ({} out of {}) are gaps in chain {} when compared to chain {}. Will not group these 2 chains in an entity", new Object[]{0.5, countGaps, c1AtomGroups.size(), c2.getChainID(), c1.getChainID()});
            return false;
        }
        return true;
    }
}

