/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.io;

import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileParsingParameters
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(FileParsingParameters.class);
    private static final long serialVersionUID = 5878292315163939027L;
    boolean parseSecStruc;
    boolean alignSeqRes;
    boolean loadChemCompInfo;
    boolean parseCAOnly;
    boolean headerOnly;
    boolean updateRemediatedFiles;
    private boolean storeEmptySeqRes;
    public static final int ATOM_CA_THRESHOLD = 500000;
    int atomCaThreshold;
    boolean parseBioAssembly;
    private boolean createAtomBonds;
    public static final int MAX_ATOMS = Integer.MAX_VALUE;
    int maxAtoms;
    String[] fullAtomNames;

    public FileParsingParameters() {
        this.setDefault();
    }

    public void setDefault() {
        this.parseSecStruc = false;
        this.alignSeqRes = false;
        this.parseCAOnly = false;
        this.loadChemCompInfo = false;
        this.headerOnly = false;
        this.storeEmptySeqRes = false;
        this.updateRemediatedFiles = false;
        this.fullAtomNames = null;
        this.maxAtoms = Integer.MAX_VALUE;
        this.atomCaThreshold = 500000;
        this.parseBioAssembly = false;
        this.createAtomBonds = false;
    }

    public boolean isParseSecStruc() {
        return this.parseSecStruc;
    }

    public void setParseSecStruc(boolean parseSecStruc) {
        this.parseSecStruc = parseSecStruc;
    }

    public boolean isLoadChemCompInfo() {
        return this.loadChemCompInfo;
    }

    public void setLoadChemCompInfo(boolean loadChemCompInfo) {
        if (loadChemCompInfo) {
            System.setProperty("loadChemCompInfo", "true");
        } else {
            System.setProperty("loadChemCompInfo", "false");
        }
        this.loadChemCompInfo = loadChemCompInfo;
    }

    public boolean isHeaderOnly() {
        return this.headerOnly;
    }

    public void setHeaderOnly(boolean headerOnly) {
        this.headerOnly = headerOnly;
    }

    public boolean isParseCAOnly() {
        return this.parseCAOnly;
    }

    public void setParseCAOnly(boolean parseCAOnly) {
        this.parseCAOnly = parseCAOnly;
    }

    public boolean isAlignSeqRes() {
        return this.alignSeqRes;
    }

    public void setAlignSeqRes(boolean alignSeqRes) {
        this.alignSeqRes = alignSeqRes;
    }

    public boolean getStoreEmptySeqRes() {
        return this.storeEmptySeqRes;
    }

    public void setStoreEmptySeqRes(boolean storeEmptySeqRes) {
        this.storeEmptySeqRes = storeEmptySeqRes;
    }

    @Deprecated
    public boolean isUpdateRemediatedFiles() {
        return this.updateRemediatedFiles;
    }

    @Deprecated
    public void setUpdateRemediatedFiles(boolean updateRemediatedFiles) {
        logger.warn("FileParsingParameters.setUpdateRemediatedFiles() is deprecated, please use LocalPDBDirectory.setFetchBehavior() instead. The option will be removed in upcoming releases");
        this.updateRemediatedFiles = updateRemediatedFiles;
    }

    public String[] getAcceptedAtomNames() {
        return this.fullAtomNames;
    }

    public void setAcceptedAtomNames(String[] fullAtomNames) {
        this.fullAtomNames = fullAtomNames;
    }

    public int getMaxAtoms() {
        return this.maxAtoms;
    }

    public void setMaxAtoms(int maxAtoms) {
        this.maxAtoms = maxAtoms;
    }

    public int getAtomCaThreshold() {
        return this.atomCaThreshold;
    }

    public void setAtomCaThreshold(int atomCaThreshold) {
        this.atomCaThreshold = atomCaThreshold;
    }

    public boolean isParseBioAssembly() {
        return this.parseBioAssembly;
    }

    public void setParseBioAssembly(boolean parseBioAssembly) {
        this.parseBioAssembly = parseBioAssembly;
    }

    public boolean shouldCreateAtomBonds() {
        return this.createAtomBonds;
    }

    public void setCreateAtomBonds(boolean createAtomBonds) {
        this.createAtomBonds = createAtomBonds;
    }
}

