/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.io.mmcif;

import org.biojava.nbio.core.util.SoftHashMap;
import org.biojava.nbio.structure.AminoAcidImpl;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.HetatomImpl;
import org.biojava.nbio.structure.NucleotideImpl;
import org.biojava.nbio.structure.io.mmcif.ChemCompProvider;
import org.biojava.nbio.structure.io.mmcif.DownloadChemCompProvider;
import org.biojava.nbio.structure.io.mmcif.chem.PolymerType;
import org.biojava.nbio.structure.io.mmcif.model.ChemComp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChemCompGroupFactory {
    private static final Logger logger = LoggerFactory.getLogger(ChemCompGroupFactory.class);
    private static ChemCompProvider chemCompProvider = new DownloadChemCompProvider();
    private static SoftHashMap<String, ChemComp> cache = new SoftHashMap(0);

    public static ChemComp getChemComp(String recordName) {
        ChemComp cc = (ChemComp)cache.get((Object)(recordName = recordName.toUpperCase().trim()));
        if (cc != null) {
            logger.debug("Chem comp " + cc.getThree_letter_code() + " read from cache");
            return cc;
        }
        logger.debug("Chem comp " + recordName + " read from provider " + chemCompProvider.getClass().getCanonicalName());
        cc = chemCompProvider.getChemComp(recordName);
        cache.put((Object)recordName, (Object)cc);
        return cc;
    }

    public static void setChemCompProvider(ChemCompProvider provider) {
        logger.debug("Setting new chem comp provider to " + provider.getClass().getCanonicalName());
        logger.debug("Chem comp provider cache reset after change of provider ");
        cache = new SoftHashMap(0);
        chemCompProvider = provider;
    }

    public static ChemCompProvider getChemCompProvider() {
        return chemCompProvider;
    }

    public static Group getGroupFromChemCompDictionary(String recordName) {
        recordName = recordName.toUpperCase().trim();
        HetatomImpl g = null;
        ChemComp cc = ChemCompGroupFactory.getChemComp(recordName);
        if (cc == null) {
            return null;
        }
        if (PolymerType.PROTEIN_ONLY.contains(cc.getPolymerType())) {
            String parent;
            AminoAcidImpl aa = new AminoAcidImpl();
            String one_letter = cc.getOne_letter_code();
            if ((one_letter == null || one_letter.equals("X") || one_letter.equals("?") || one_letter.length() == 0) && (parent = cc.getMon_nstd_parent_comp_id()) != null && parent.length() == 3) {
                String parentid = cc.getMon_nstd_parent_comp_id();
                ChemComp parentCC = ChemCompGroupFactory.getChemComp(parentid);
                one_letter = parentCC.getOne_letter_code();
            }
            if (one_letter == null || one_letter.length() == 0 || one_letter.equals("?")) {
                logger.warn("Problem with chemical component: " + recordName + "  Did not find one letter code! Setting it to 'X'");
                aa.setAminoType(Character.valueOf('X'));
            } else {
                aa.setAminoType(Character.valueOf(one_letter.charAt(0)));
            }
            g = aa;
        } else if (PolymerType.POLYNUCLEOTIDE_ONLY.contains(cc.getPolymerType())) {
            NucleotideImpl nuc = new NucleotideImpl();
            g = nuc;
        } else {
            g = new HetatomImpl();
        }
        g.setChemComp(cc);
        return g;
    }

    public static String getOneLetterCode(ChemComp cc) {
        String oneLetter = cc.getOne_letter_code();
        if (oneLetter == null || oneLetter.equals("X") || oneLetter.equals("?")) {
            String parentId = cc.getMon_nstd_parent_comp_id();
            if (parentId == null) {
                return oneLetter;
            }
            ChemComp parentCC = ChemCompGroupFactory.getChemComp(parentId);
            if (parentCC == null) {
                return oneLetter;
            }
            oneLetter = parentCC.getOne_letter_code();
        }
        return oneLetter;
    }
}

