/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.secstruc;

import java.io.Serializable;

public enum SecStrucType implements Serializable
{
    coil("Coil", Character.valueOf(' ')),
    helix4("alpha Helix", Character.valueOf('H')),
    helix3("3-10 Helix", Character.valueOf('G')),
    helix5("pi helix", Character.valueOf('I')),
    turn("Turn", Character.valueOf('T')),
    bend("Bend", Character.valueOf('S')),
    extended("Extended", Character.valueOf('E')),
    bridge("Bridge", Character.valueOf('B'));

    public final Character type;
    public final String name;

    private SecStrucType(String name, Character stype) {
        this.name = name;
        this.type = stype;
    }

    public static SecStrucType fromCharacter(Character stype) {
        for (SecStrucType c : SecStrucType.values()) {
            if (!c.type.equals(stype)) continue;
            return c;
        }
        return null;
    }

    public String toString() {
        return this.type.toString();
    }

    public boolean isHelixType() {
        return this.type.equals(SecStrucType.helix4.type) || this.type.equals(SecStrucType.helix3.type) || this.type.equals(SecStrucType.helix5.type);
    }
}

