/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.symmetry.analysis;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.SortedSet;
import org.biojava.nbio.structure.PDBCrystallographicInfo;
import org.biojava.nbio.structure.PDBHeader;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.StructureIO;
import org.biojava.nbio.structure.align.util.AtomCache;
import org.biojava.nbio.structure.io.FileParsingParameters;
import org.biojava.nbio.structure.io.mmcif.AllChemCompProvider;
import org.biojava.nbio.structure.io.mmcif.ChemCompGroupFactory;
import org.biojava.nbio.structure.rcsb.GetRepresentatives;
import org.biojava.nbio.structure.symmetry.core.QuatSymmetryDetector;
import org.biojava.nbio.structure.symmetry.core.QuatSymmetryParameters;
import org.biojava.nbio.structure.symmetry.core.QuatSymmetryResults;
import org.biojava.nbio.structure.symmetry.core.Subunits;
import org.biojava.nbio.structure.symmetry.misc.ProteinComplexSignature;
import org.biojava.nbio.structure.symmetry.utils.BlastClustReader;
import org.biojava.nbio.structure.xtal.SpaceGroup;

public class ScanSymmetry
implements Runnable {
    private AtomCache cache = null;
    private static String RESULT_DIR = "/Users/peter/Results/ScanSymmetry/";

    public ScanSymmetry() {
        this.initializeCache();
    }

    public static void main(String[] args) {
        new ScanSymmetry().run();
    }

    @Override
    public void run() {
        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(Calendar.getInstance().getTime());
        System.out.println("Reading blastclust files");
        BlastClustReader reader95 = new BlastClustReader(95);
        BlastClustReader reader30 = new BlastClustReader(30);
        PrintWriter out = null;
        PrintWriter error = null;
        try {
            out = new PrintWriter(new FileWriter(RESULT_DIR + timeStamp + "_symm.csv"));
            error = new PrintWriter(new FileWriter(RESULT_DIR + timeStamp + "_error.txt"));
        }
        catch (IOException e1) {
            e1.printStackTrace();
            System.exit(-1);
        }
        long t1 = System.nanoTime();
        int success = 0;
        int proteins = 0;
        int failure = 0;
        String header = "pdbId,bioassembly,local,pseudostoichiometric,stoichiometry,pseudosymmetric,pointgroup,order,lowSymmetry,minidentity,maxidentity,subunitrmsd,rmsd,tm,minrmsd,maxrmsd,mintm,maxtm,rmsdintra,tmintra,symdeviation,subunits,nucleiacids,cacount,time,signature95,stoich95,signature30,stoich30,spacegroup";
        out.println(header);
        QuatSymmetryParameters parameters = new QuatSymmetryParameters();
        SortedSet<String> set = GetRepresentatives.getAll();
        set.clear();
        set.add("4HHB");
        boolean skip = false;
        String restartId = "10MH";
        for (String pdbId : set) {
            if (skip && pdbId.equals(restartId)) {
                skip = false;
            }
            if (skip) continue;
            System.out.println("------------- " + pdbId + "-------------");
            StructureIO.setAtomCache(this.cache);
            int bioAssemblyCount = StructureIO.getNrBiologicalAssemblies(pdbId);
            int first = 0;
            int last = 1;
            if (bioAssemblyCount != -1) {
                first = 1;
                last = bioAssemblyCount + 1;
            }
            for (int i = first; i < last; ++i) {
                Structure structure = null;
                try {
                    structure = StructureIO.getBiologicalAssembly(pdbId, i);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    error.println(pdbId + "[" + i + "]: " + e.getMessage());
                    error.flush();
                }
                catch (StructureException e) {
                    e.printStackTrace();
                    error.println(pdbId + "[" + i + "]: " + e.getMessage());
                    error.flush();
                }
                long ts1 = System.nanoTime();
                try {
                    QuatSymmetryDetector detector;
                    SpaceGroup spaceGroup = null;
                    float resolution = 0.0f;
                    if (structure != null) {
                        PDBCrystallographicInfo info = structure.getCrystallographicInfo();
                        if (info != null) {
                            spaceGroup = info.getSpaceGroup();
                        }
                        PDBHeader pdbHeader = structure.getPDBHeader();
                        resolution = pdbHeader.getResolution();
                    }
                    if ((detector = new QuatSymmetryDetector(structure, parameters)).hasProteinSubunits()) {
                        long ts2 = System.nanoTime();
                        int time = Math.round((float)(ts2 - ts1) / 1000000.0f);
                        List<QuatSymmetryResults> globalResults = detector.getGlobalSymmetry();
                        this.printToCsv(reader95, reader30, out, pdbId, i, time, globalResults, spaceGroup);
                        for (List<QuatSymmetryResults> localResults : detector.getLocalSymmetries()) {
                            this.printToCsv(reader95, reader30, out, pdbId, i, time, localResults, spaceGroup);
                        }
                        ++proteins;
                    }
                    ++success;
                    out.flush();
                    continue;
                }
                catch (Exception e) {
                    ++failure;
                    e.printStackTrace();
                    error.println(pdbId + "[" + i + "]: " + e.getMessage());
                    error.flush();
                }
            }
        }
        long t2 = System.nanoTime();
        System.out.println("PDBs succeeded: " + success);
        System.out.println("PDBs failed   : " + failure);
        System.out.println("Proteins      : " + proteins);
        System.out.println("Total structure: " + set.size());
        System.out.println("Cpu time: " + (t2 - t1) / 1000000L + " ms.");
        out.close();
        error.close();
    }

    private void printToCsv(BlastClustReader reader95, BlastClustReader reader30, PrintWriter out, String pdbId, int bioAssemblyId, int time, List<QuatSymmetryResults> resultsList, SpaceGroup spaceGroup) {
        for (QuatSymmetryResults results : resultsList) {
            ProteinComplexSignature s95 = new ProteinComplexSignature(pdbId, results.getSubunits().getChainIds(), reader95);
            String signature95 = s95.getComplexSignature();
            String stoich95 = s95.getComplexStoichiometry();
            ProteinComplexSignature s30 = new ProteinComplexSignature(pdbId, results.getSubunits().getChainIds(), reader30);
            String signature30 = s30.getComplexSignature();
            String stoich30 = s30.getComplexStoichiometry();
            int order = 1;
            if (!results.getSymmetry().equals("H")) {
                order = results.getRotationGroup().getOrder();
            }
            out.println("PDB" + pdbId + "," + bioAssemblyId + "," + results.isLocal() + "," + results.getSubunits().isPseudoStoichiometric() + "," + results.getSubunits().getStoichiometry() + "," + results.getSubunits().isPseudoSymmetric() + "," + results.getSymmetry() + "," + order + "," + this.isLowSymmetry(results) + "," + Math.round(results.getSubunits().getMinSequenceIdentity() * 100.0) + "," + Math.round(results.getSubunits().getMaxSequenceIdentity() * 100.0) + "," + (float)results.getScores().getRmsdCenters() + "," + (float)results.getScores().getRmsd() + "," + (float)results.getScores().getTm() + "," + (float)results.getScores().getMinRmsd() + "," + (float)results.getScores().getMaxRmsd() + "," + (float)results.getScores().getMinTm() + "," + (float)results.getScores().getMaxTm() + "," + (float)results.getScores().getRmsdIntra() + "," + (float)results.getScores().getTmIntra() + "," + (float)results.getScores().getSymDeviation() + "," + results.getSubunits().getSubunitCount() + "," + results.getNucleicAcidChainCount() + "," + results.getSubunits().getCalphaCount() + "," + time + "," + signature95 + "," + stoich95 + "," + signature30 + "," + stoich30 + "," + spaceGroup);
        }
    }

    private boolean isLowSymmetry(QuatSymmetryResults results) {
        return this.getMinFold(results.getSubunits()) > 1 && results.getRotationGroup() != null && results.getRotationGroup().getPointGroup().equals("C1");
    }

    private int getMinFold(Subunits subunits) {
        if (subunits.getFolds().size() > 1) {
            return subunits.getFolds().get(1);
        }
        return subunits.getFolds().get(0);
    }

    private void initializeCache() {
        this.cache = new AtomCache();
        FileParsingParameters params = this.cache.getFileParsingParams();
        this.cache.setUseMmCif(true);
        params.setStoreEmptySeqRes(true);
        params.setAlignSeqRes(true);
        params.setParseCAOnly(true);
        params.setLoadChemCompInfo(true);
        ChemCompGroupFactory.setChemCompProvider(new AllChemCompProvider());
    }
}

