/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.symmetry.core;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.vecmath.Point3d;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.symmetry.core.C2RotationSolver;
import org.biojava.nbio.structure.symmetry.core.ChainClusterer;
import org.biojava.nbio.structure.symmetry.core.ClusterProteinChains;
import org.biojava.nbio.structure.symmetry.core.HelixLayers;
import org.biojava.nbio.structure.symmetry.core.HelixSolver;
import org.biojava.nbio.structure.symmetry.core.QuatSymmetryParameters;
import org.biojava.nbio.structure.symmetry.core.QuatSymmetryResults;
import org.biojava.nbio.structure.symmetry.core.QuatSymmetrySolver;
import org.biojava.nbio.structure.symmetry.core.RotationGroup;
import org.biojava.nbio.structure.symmetry.core.RotationSolver;
import org.biojava.nbio.structure.symmetry.core.SubunitGraph;
import org.biojava.nbio.structure.symmetry.core.Subunits;
import org.biojava.nbio.structure.symmetry.utils.CombinationGenerator;
import org.biojava.nbio.structure.symmetry.utils.ComponentFinder;
import org.biojava.nbio.structure.symmetry.utils.Graph;

public class QuatSymmetryDetector {
    private Structure structure = null;
    private QuatSymmetryParameters parameters = null;
    private List<QuatSymmetryResults> globalSymmetry = new ArrayList<QuatSymmetryResults>();
    private List<List<QuatSymmetryResults>> localSymmetries = new ArrayList<List<QuatSymmetryResults>>();
    private int proteinChainCount = 0;
    private boolean complete = false;

    public QuatSymmetryDetector(Structure structure, QuatSymmetryParameters parameters) {
        this.structure = structure;
        this.parameters = parameters;
    }

    public boolean hasProteinSubunits() {
        this.run();
        return this.proteinChainCount > 0;
    }

    public List<QuatSymmetryResults> getGlobalSymmetry() {
        this.run();
        return this.globalSymmetry;
    }

    public List<List<QuatSymmetryResults>> getLocalSymmetries() {
        this.run();
        return this.localSymmetries;
    }

    private void run() {
        if (this.complete) {
            return;
        }
        this.complete = true;
        ClusterProteinChains clusterer = new ClusterProteinChains(this.structure, this.parameters);
        this.proteinChainCount = clusterer.getProteinChainCount();
        if (!this.hasProteinSubunits()) {
            return;
        }
        int nucleicAcidChainCount = clusterer.getNucleicAcidChainCount();
        double[] thresholds = (double[])this.parameters.getSequenceIdentityThresholds().clone();
        Arrays.sort(thresholds);
        for (int index = 0; index < thresholds.length; ++index) {
            ChainClusterer chainClusterer = new ChainClusterer(clusterer.getSequenceAlignmentClusters(thresholds[index]));
            Subunits globalSubunits = this.createGlobalSubunits(chainClusterer, nucleicAcidChainCount);
            QuatSymmetryResults gSymmetry = this.calcQuatSymmetry(globalSubunits);
            gSymmetry.setSequenceIdentityThreshold(thresholds[index]);
            this.globalSymmetry.add(gSymmetry);
            if (this.parameters.isLocalSymmetry() && globalSubunits.getSubunitCount() <= this.parameters.getMaximumLocalSubunits() && gSymmetry.getSymmetry().equals("C1") && this.proteinChainCount > 2) {
                ArrayList<QuatSymmetryResults> lSymmetry = new ArrayList<QuatSymmetryResults>();
                long start = System.nanoTime();
                for (Subunits subunits : this.createLocalSubunits(chainClusterer)) {
                    QuatSymmetryResults result = this.calcQuatSymmetry(subunits);
                    this.addToLocalSymmetry(result, lSymmetry);
                    double time = (System.nanoTime() - start) / 1000000000L;
                    if (!(time > this.parameters.getLocalTimeLimit())) continue;
                    System.out.println("Warning: QuatSymmetryDetector: Exceeded time limit for local symmetry calculations: " + time + " seconds. Results may be incomplete");
                    break;
                }
                this.localSymmetries.add(lSymmetry);
            }
            if (!gSymmetry.getSubunits().isPseudoStoichiometric()) break;
        }
        this.trimGlobalSymmetryResults();
        this.trimLocalSymmetryResults();
        this.setPseudoSymmetry();
        this.setPreferredResults();
    }

    private void trimGlobalSymmetryResults() {
        Iterator<QuatSymmetryResults> iter = this.globalSymmetry.iterator();
        while (iter.hasNext()) {
            QuatSymmetryResults result = iter.next();
            if (!result.getSymmetry().equals("C1") || !result.getSubunits().isPseudoStoichiometric()) continue;
            iter.remove();
        }
    }

    private void trimLocalSymmetryResults() {
        boolean hasGlobalSymmetry = false;
        for (QuatSymmetryResults result : this.globalSymmetry) {
            if (result.getSymmetry().equals("C1")) continue;
            hasGlobalSymmetry = true;
            break;
        }
        if (hasGlobalSymmetry) {
            this.localSymmetries.clear();
        }
    }

    private void setPseudoSymmetry() {
        this.setPseudoSymmetry(this.globalSymmetry);
        for (List<QuatSymmetryResults> localSymmetry : this.localSymmetries) {
            this.setPseudoSymmetry(localSymmetry);
        }
    }

    private void setPseudoSymmetry(List<QuatSymmetryResults> results) {
        int maxOrder = 0;
        for (QuatSymmetryResults result : results) {
            if (result.getRotationGroup() == null || result.getSubunits().isPseudoStoichiometric() || result.getRotationGroup().getOrder() <= maxOrder) continue;
            maxOrder = result.getRotationGroup().getOrder();
        }
        for (QuatSymmetryResults result : results) {
            if (result.getRotationGroup() == null || result.getRotationGroup().getOrder() <= maxOrder) continue;
            result.getSubunits().setPseudoSymmetric(true);
        }
    }

    private void setPreferredResults() {
        int i;
        int[] score = new int[this.globalSymmetry.size()];
        for (int i2 = 0; i2 < this.globalSymmetry.size(); ++i2) {
            QuatSymmetryResults result = this.globalSymmetry.get(i2);
            if (!result.getSymmetry().equals("C1")) {
                int n = i2;
                score[n] = score[n] + 2;
            }
            if (result.getSubunits().isPseudoStoichiometric()) continue;
            int n = i2;
            score[n] = score[n] + 1;
        }
        int bestGlobal = 0;
        int bestScore = 0;
        for (i = 0; i < score.length; ++i) {
            if (score[i] <= bestScore) continue;
            bestScore = score[i];
            bestGlobal = i;
        }
        if (bestScore >= 2) {
            QuatSymmetryResults g = this.globalSymmetry.get(bestGlobal);
            g.setPreferredResult(true);
            return;
        }
        score = new int[this.localSymmetries.size()];
        for (i = 0; i < this.localSymmetries.size(); ++i) {
            List<QuatSymmetryResults> results = this.localSymmetries.get(i);
            for (QuatSymmetryResults result : results) {
                if (!result.getSymmetry().equals("C1")) {
                    int n = i;
                    score[n] = score[n] + 2;
                }
                if (result.getSubunits().isPseudoStoichiometric()) continue;
                int n = i;
                score[n] = score[n] + 1;
            }
        }
        int bestLocal = 0;
        bestScore = 0;
        for (int i3 = 0; i3 < score.length; ++i3) {
            if (score[i3] <= bestScore) continue;
            bestScore = score[i3];
            bestLocal = i3;
        }
        if (bestScore > 0) {
            List<QuatSymmetryResults> results = this.localSymmetries.get(bestLocal);
            for (QuatSymmetryResults result : results) {
                result.setPreferredResult(true);
            }
        } else {
            QuatSymmetryResults g = this.globalSymmetry.get(bestGlobal);
            g.setPreferredResult(true);
        }
    }

    private void addToLocalSymmetry(QuatSymmetryResults testResults, List<QuatSymmetryResults> localSymmetry) {
        if (testResults.getSymmetry().equals("C1")) {
            return;
        }
        for (QuatSymmetryResults results : localSymmetry) {
            if (!results.getSubunits().overlaps(testResults.getSubunits())) continue;
            return;
        }
        testResults.setLocal(true);
        localSymmetry.add(testResults);
    }

    private Subunits createGlobalSubunits(ChainClusterer chainClusterer, int nucleicAcidChainCount) {
        Subunits subunits = new Subunits(chainClusterer.getCalphaCoordinates(), chainClusterer.getSequenceClusterIds(), chainClusterer.getPseudoStoichiometry(), chainClusterer.getMinSequenceIdentity(), chainClusterer.getMaxSequenceIdentity(), chainClusterer.getFolds(), chainClusterer.getChainIds(), chainClusterer.getModelNumbers());
        subunits.setNucleicAcidChainCount(nucleicAcidChainCount);
        return subunits;
    }

    private List<Subunits> createLocalSubunits(ChainClusterer chainClusterer) {
        ArrayList<Subunits> subunits = new ArrayList<Subunits>();
        List<List<Integer>> subClusters = this.decomposeClusters(chainClusterer.getCalphaCoordinates(), chainClusterer.getSequenceClusterIds());
        for (List<Integer> subCluster : subClusters) {
            subunits.add(this.createLocalSubunit(subCluster, chainClusterer));
        }
        return subunits;
    }

    private Subunits createLocalSubunit(List<Integer> subCluster, ChainClusterer chainClusterer) {
        ArrayList<Point3d[]> subCalphaCoordinates = new ArrayList<Point3d[]>(subCluster.size());
        ArrayList<Integer> subSequenceIds = new ArrayList<Integer>(subCluster.size());
        ArrayList<Boolean> subPseudoStoichiometry = new ArrayList<Boolean>(subCluster.size());
        ArrayList<Double> subMinSequenceIdentity = new ArrayList<Double>(subCluster.size());
        ArrayList<Double> subMaxSequenceIdentity = new ArrayList<Double>(subCluster.size());
        ArrayList<String> subChainIds = new ArrayList<String>(subCluster.size());
        ArrayList<Integer> subModelNumbers = new ArrayList<Integer>(subCluster.size());
        for (int index : subCluster) {
            subCalphaCoordinates.add(chainClusterer.getCalphaCoordinates().get(index));
            subSequenceIds.add(chainClusterer.getSequenceClusterIds().get(index));
            subPseudoStoichiometry.add(chainClusterer.getPseudoStoichiometry().get(index));
            subMinSequenceIdentity.add(chainClusterer.getMinSequenceIdentity().get(index));
            subMaxSequenceIdentity.add(chainClusterer.getMaxSequenceIdentity().get(index));
            subChainIds.add(chainClusterer.getChainIds().get(index));
            subModelNumbers.add(chainClusterer.getModelNumbers().get(index));
        }
        QuatSymmetryDetector.standardizeSequenceIds(subSequenceIds);
        Integer[] array = subSequenceIds.toArray(new Integer[subSequenceIds.size()]);
        List<Integer> subFolds = QuatSymmetryDetector.getFolds(array, subSequenceIds.size());
        Subunits subunits = new Subunits(subCalphaCoordinates, subSequenceIds, subPseudoStoichiometry, subMinSequenceIdentity, subMaxSequenceIdentity, subFolds, subChainIds, subModelNumbers);
        return subunits;
    }

    private static void standardizeSequenceIds(List<Integer> subSequenceIds) {
        int count = 0;
        int current = subSequenceIds.get(0);
        for (int i = 0; i < subSequenceIds.size(); ++i) {
            if (subSequenceIds.get(i) > current) {
                current = subSequenceIds.get(i);
                ++count;
            }
            subSequenceIds.set(i, count);
        }
    }

    private List<List<Integer>> decomposeClusters(List<Point3d[]> caCoords, List<Integer> clusterIds) {
        ArrayList<List<Integer>> subClusters = new ArrayList<List<Integer>>();
        int last = QuatSymmetryDetector.getLastMultiSubunit(clusterIds);
        List<Point3d[]> subList = caCoords;
        if (last < caCoords.size()) {
            subList = caCoords.subList(0, last);
        } else {
            last = caCoords.size();
        }
        SubunitGraph subunitGraph = new SubunitGraph(subList);
        Graph<Integer> graph = subunitGraph.getProteinGraph();
        for (int i = last; i > 1; --i) {
            CombinationGenerator generator = new CombinationGenerator(last, i);
            int[] indices = null;
            Integer[] subCluster = new Integer[i];
            BigInteger maxCombinations = BigInteger.valueOf(this.parameters.getMaximumLocalCombinations());
            if (generator.getTotal().compareTo(maxCombinations) > 0) continue;
            while (generator.hasNext()) {
                indices = generator.getNext();
                for (int j = 0; j < indices.length; ++j) {
                    subCluster[j] = clusterIds.get(indices[j]);
                }
                List<Integer> folds = QuatSymmetryDetector.getFolds(subCluster, last);
                if (folds.size() < 2) continue;
                ArrayList<Integer> subSet = new ArrayList<Integer>(indices.length);
                for (int index : indices) {
                    subSet.add(index);
                }
                Graph<Integer> subGraph = graph.extractSubGraph(subSet);
                if (!QuatSymmetryDetector.isConnectedGraph(subGraph)) continue;
                subClusters.add(subSet);
                if (subClusters.size() <= this.parameters.getMaximumLocalResults()) continue;
                return subClusters;
            }
        }
        return subClusters;
    }

    private static int getLastMultiSubunit(List<Integer> clusterIds) {
        int n = clusterIds.size();
        for (int i = 0; i < n; ++i) {
            if (i < n - 2 && clusterIds.get(i) != clusterIds.get(i + 1) && clusterIds.get(i + 1) != clusterIds.get(i + 2)) {
                return i + 1;
            }
            if (i != n - 2 || clusterIds.get(i) == clusterIds.get(i + 1)) continue;
            return i + 1;
        }
        return clusterIds.size();
    }

    private static boolean isConnectedGraph(Graph<Integer> graph) {
        ComponentFinder<Integer> finder = new ComponentFinder<Integer>();
        finder.setGraph(graph);
        return finder.getComponentCount() == 1;
    }

    private static List<Integer> getFolds(Integer[] subCluster, int size) {
        ArrayList<Integer> denominators = new ArrayList<Integer>();
        int[] counts = new int[size];
        Integer[] arr$ = subCluster;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int element;
            int n = element = arr$[i$].intValue();
            counts[n] = counts[n] + 1;
        }
        for (int d = 1; d <= subCluster.length; ++d) {
            int count = 0;
            for (int i = 0; i < size; ++i) {
                if (counts[i] <= 0 || counts[i] % d != 0) continue;
                count += counts[i];
            }
            if (count != subCluster.length) continue;
            denominators.add(d);
        }
        Collections.sort(denominators);
        return denominators;
    }

    private QuatSymmetryResults calcQuatSymmetry(Subunits subunits) {
        HelixSolver hc;
        HelixLayers helixLayers;
        QuatSymmetrySolver solver;
        if (subunits.getSubunitCount() == 0) {
            return null;
        }
        RotationGroup rotationGroup = null;
        String method = null;
        if (subunits.getFolds().size() == 1) {
            method = "norotation";
            rotationGroup = new RotationGroup();
            rotationGroup.setC1(subunits.getSubunitCount());
        } else if (subunits.getSubunitCount() == 2 && subunits.getFolds().contains(2)) {
            method = "C2rotation";
            solver = new C2RotationSolver(subunits, this.parameters);
            rotationGroup = solver.getSymmetryOperations();
        } else {
            method = "rotation";
            solver = new RotationSolver(subunits, this.parameters);
            rotationGroup = solver.getSymmetryOperations();
        }
        QuatSymmetryResults results = new QuatSymmetryResults(subunits, rotationGroup, method);
        String symmetry = results.getSymmetry();
        if (symmetry.equals("C1")) {
            subunits.setPseudoSymmetric(false);
        }
        if (symmetry.startsWith("C") && (helixLayers = (hc = new HelixSolver(subunits, rotationGroup.getOrder(), this.parameters)).getSymmetryOperations()).size() > 0) {
            double cRmsd = rotationGroup.getScores().getRmsd();
            double hRmsd = helixLayers.getScores().getRmsd();
            double deltaRmsd = hRmsd - cRmsd;
            if (symmetry.equals("C1") || !symmetry.equals("C1") && deltaRmsd <= this.parameters.getHelixRmsdThreshold()) {
                method = "rottranslation";
                results = new QuatSymmetryResults(subunits, helixLayers, method);
            }
        }
        return results;
    }
}

