/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.symmetry.core;

import java.util.Arrays;

public class QuatSymmetryParameters {
    private int minimumSequenceLength = 20;
    private int absoluteMinimumSequenceLength = 5;
    private double minimumSequenceLengthFraction = 0.75;
    private double[] sequenceIdentityThresholds = new double[]{0.0, 0.95};
    private double sequencePseudoSymmetryThreshold = 0.95;
    private double alignmentFractionThreshold = 0.9;
    private double rmsdThreshold = 7.0;
    private double angleThreshold = 10.0;
    private double helixRmsdThreshold = 0.05;
    private double helixRmsdToRiseRatio = 0.5;
    private double minimumHelixRise = 1.0;
    private double minimumHelixAngle = 5.0;
    private int maximumLocalCombinations = 50000;
    private int maximumLocalResults = 1000;
    private int maximumLocalSubunits = 20;
    private boolean localSymmetry = true;
    private double localTimeLimit = 120.0;
    private boolean onTheFly = true;
    private boolean verbose = false;
    private static final String n = System.getProperty("line.separator");

    public int getMinimumSequenceLength() {
        return this.minimumSequenceLength;
    }

    public void setMinimumSequenceLength(int minimumSequenceLength) {
        this.minimumSequenceLength = minimumSequenceLength;
    }

    public int getAbsoluteMinimumSequenceLength() {
        return this.absoluteMinimumSequenceLength;
    }

    public void setAbsoluteMinimumSequenceLength(int absoluteMinimumSequenceLength) {
        this.absoluteMinimumSequenceLength = absoluteMinimumSequenceLength;
    }

    public double getMinimumSequenceLengthFraction() {
        return this.minimumSequenceLengthFraction;
    }

    public void setMinimumSequenceLengthFraction(double minimumSequenceLengthFraction) {
        this.minimumSequenceLengthFraction = minimumSequenceLengthFraction;
    }

    public double[] getSequenceIdentityThresholds() {
        return this.sequenceIdentityThresholds;
    }

    public void setSequenceIdentityThresholds(double[] sequenceIdentityThresholds) {
        this.sequenceIdentityThresholds = sequenceIdentityThresholds;
    }

    public double getAlignmentFractionThreshold() {
        return this.alignmentFractionThreshold;
    }

    public void setAlignmentFractionThreshold(double alignmentFractionThreshold) {
        this.alignmentFractionThreshold = alignmentFractionThreshold;
    }

    public double getRmsdThreshold() {
        return this.rmsdThreshold;
    }

    public void setRmsdThreshold(double rmsdThreshold) {
        this.rmsdThreshold = rmsdThreshold;
    }

    public double getAngleThreshold() {
        return this.angleThreshold;
    }

    public void setAngleThreshold(double angleThreshold) {
        this.angleThreshold = angleThreshold;
    }

    public double getHelixRmsdThreshold() {
        return this.helixRmsdThreshold;
    }

    public void setHelixRmsdThreshold(double helixRmsdThreshold) {
        this.helixRmsdThreshold = helixRmsdThreshold;
    }

    public double getHelixRmsdToRiseRatio() {
        return this.helixRmsdToRiseRatio;
    }

    public void setHelixRmsdToRiseRatio(double helixRmsdToRiseRatio) {
        this.helixRmsdToRiseRatio = helixRmsdToRiseRatio;
    }

    public double getMinimumHelixRise() {
        return this.minimumHelixRise;
    }

    public void setMinimumHelixRise(double minimumHelixRise) {
        this.minimumHelixRise = minimumHelixRise;
    }

    public double getMinimumHelixAngle() {
        return this.minimumHelixAngle;
    }

    public void setMinimumHelixAngle(double minimumHelixAngle) {
        this.minimumHelixAngle = minimumHelixAngle;
    }

    public double getSequencePseudoSymmetryThreshold() {
        return this.sequencePseudoSymmetryThreshold;
    }

    public void setSequencePseudoSymmetryThreshold(double sequencePseudoSymmetryThreshold) {
        this.sequencePseudoSymmetryThreshold = sequencePseudoSymmetryThreshold;
    }

    public int getMaximumLocalCombinations() {
        return this.maximumLocalCombinations;
    }

    public void setMaximumLocalCombinations(int maximumLocalCombinations) {
        this.maximumLocalCombinations = maximumLocalCombinations;
    }

    public int getMaximumLocalResults() {
        return this.maximumLocalResults;
    }

    public int getMaximumLocalSubunits() {
        return this.maximumLocalSubunits;
    }

    public void setMaximumLocalSubunits(int maximumLocalSubunits) {
        this.maximumLocalSubunits = maximumLocalSubunits;
    }

    public void setMaximumLocalResults(int maximumLocalResults) {
        this.maximumLocalResults = maximumLocalResults;
    }

    public boolean isLocalSymmetry() {
        return this.localSymmetry;
    }

    public void setLocalSymmetry(boolean localSymmetry) {
        this.localSymmetry = localSymmetry;
    }

    public double getLocalTimeLimit() {
        return this.localTimeLimit;
    }

    public void setLocalTimeLimit(double localTimeLimit) {
        this.localTimeLimit = localTimeLimit;
    }

    public boolean isOnTheFly() {
        return this.onTheFly;
    }

    public void setOnTheFly(boolean useJmolBioAssemblies) {
        this.onTheFly = useJmolBioAssemblies;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("Minimum protein sequence length   : ");
        s.append(this.minimumSequenceLength);
        s.append(n);
        s.append("Sequence identity thresholds      : ");
        s.append(Arrays.toString(this.sequenceIdentityThresholds));
        s.append(n);
        s.append("Sequence pseudosymmetry threshold : ");
        s.append(this.sequencePseudoSymmetryThreshold);
        s.append(n);
        s.append("Alignment fraction threshold      : ");
        s.append(this.alignmentFractionThreshold);
        s.append(n);
        s.append("Angle threshold                   : ");
        s.append(this.angleThreshold);
        s.append(n);
        s.append("Symmetry RMSD threshold           : ");
        s.append(this.rmsdThreshold);
        s.append(n);
        s.append("Local symmetry                    : ");
        s.append(this.localSymmetry);
        s.append(n);
        s.append("Verbose                           : ");
        s.append(this.verbose);
        s.append(n);
        return s.toString();
    }
}

